/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.readers.KeyValue;
import cytoscape.view.CyNetworkView;
import giny.model.Edge;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class GMLWriter {
    private Set<Integer> newNodes;
    private Set<Integer> newEdges;

    public void writeGML(CyNetwork network, CyNetworkView view, List oldList) {
        this.newNodes = new HashSet<Integer>(network.getNodeCount());
        this.newEdges = new HashSet<Integer>(network.getEdgeCount());
        Iterator it = network.nodesIterator();
        while (it.hasNext()) {
            this.newNodes.add(new Integer(((Node)it.next()).getRootGraphIndex()));
        }
        it = network.edgesIterator();
        while (it.hasNext()) {
            this.newEdges.add(new Integer(((Edge)it.next()).getRootGraphIndex()));
        }
        KeyValue graph = null;
        KeyValue creator = null;
        KeyValue version = null;
        KeyValue keyVal2 = null;
        KeyValue title = null;
        for (KeyValue keyVal2 : oldList) {
            if (keyVal2.key.equals("graph")) {
                graph = keyVal2;
                continue;
            }
            if (keyVal2.key.equals("Creator")) {
                creator = keyVal2;
                continue;
            }
            if (!keyVal2.key.equals("Version")) continue;
            version = keyVal2;
        }
        if (creator == null) {
            creator = new KeyValue("Creator", null);
            oldList.add(creator);
        }
        if (version == null) {
            version = new KeyValue("Version", null);
            oldList.add(version);
        }
        if (graph == null) {
            graph = new KeyValue("graph", new Vector());
            oldList.add(graph);
        }
        if (title == null) {
            title = new KeyValue("Title", network.getTitle());
            oldList.add(title);
        }
        this.writeGraph(network, view, (List)graph.value);
        creator.value = "Cytoscape";
        version.value = new Double(1.0);
        List graph_list = (List)graph.value;
        while (!this.newNodes.isEmpty()) {
            KeyValue nodePair = new KeyValue("node", new Vector());
            graph_list.add(nodePair);
            ((List)nodePair.value).add(new KeyValue("root_index", this.newNodes.iterator().next()));
            this.writeGraphNode(network, view, (List)nodePair.value);
        }
        while (!this.newEdges.isEmpty()) {
            KeyValue edgePair = new KeyValue("edge", new Vector());
            graph_list.add(edgePair);
            ((List)edgePair.value).add(new KeyValue("root_index", this.newEdges.iterator().next()));
            this.writeGraphEdge(network, view, (List)edgePair.value);
        }
    }

    private void writeGraph(CyNetwork network, CyNetworkView view, List oldList) {
        Iterator it = oldList.iterator();
        while (it.hasNext()) {
            KeyValue keyVal = (KeyValue)it.next();
            if (keyVal.key.equals("node")) {
                if (this.writeGraphNode(network, view, (List)keyVal.value)) continue;
                it.remove();
                continue;
            }
            if (!keyVal.key.equals("edge") || this.writeGraphEdge(network, view, (List)keyVal.value)) continue;
            it.remove();
        }
    }

    private boolean writeGraphNode(CyNetwork network, CyNetworkView view, List oldList) {
        Integer root_index = null;
        KeyValue graphicsPair = null;
        KeyValue labelPair = null;
        KeyValue idPair = null;
        for (KeyValue keyVal : oldList) {
            if (keyVal.key.equals("root_index")) {
                root_index = (Integer)keyVal.value;
                continue;
            }
            if (keyVal.key.equals("graphics")) {
                graphicsPair = keyVal;
                continue;
            }
            if (keyVal.key.equals("label")) {
                labelPair = keyVal;
                continue;
            }
            if (!keyVal.key.equals("id")) continue;
            idPair = keyVal;
        }
        if (root_index == null) {
            return false;
        }
        Node node = Cytoscape.getRootGraph().getNode(root_index);
        if (!network.containsNode(node)) {
            return false;
        }
        this.newNodes.remove(root_index);
        if (idPair == null) {
            idPair = new KeyValue("id", null);
            oldList.add(idPair);
        }
        idPair.value = root_index;
        if (view != Cytoscape.getNullNetworkView()) {
            if (graphicsPair == null) {
                graphicsPair = new KeyValue("graphics", new Vector());
                oldList.add(graphicsPair);
            }
            this.writeGraphNodeGraphics(network, view.getNodeView(node), (List)graphicsPair.value);
        }
        if (labelPair == null) {
            labelPair = new KeyValue("label", null);
            oldList.add(labelPair);
        }
        labelPair.value = node.getIdentifier();
        return true;
    }

    private boolean writeGraphEdge(CyNetwork network, CyNetworkView view, List oldList) {
        Integer root_index = null;
        KeyValue graphicsPair = null;
        KeyValue labelPair = null;
        KeyValue sourcePair = null;
        KeyValue targetPair = null;
        for (KeyValue keyVal : oldList) {
            if (keyVal.key.equals("graphics")) {
                graphicsPair = keyVal;
                continue;
            }
            if (keyVal.key.equals("label")) {
                labelPair = keyVal;
                continue;
            }
            if (keyVal.key.equals("root_index")) {
                root_index = (Integer)keyVal.value;
                continue;
            }
            if (keyVal.key.equals("source")) {
                sourcePair = keyVal;
                continue;
            }
            if (!keyVal.key.equals("target")) continue;
            targetPair = keyVal;
        }
        if (root_index == null) {
            return false;
        }
        Edge edge = Cytoscape.getRootGraph().getEdge(root_index);
        if (!network.containsEdge(edge)) {
            return false;
        }
        this.newEdges.remove(root_index);
        if (targetPair == null) {
            targetPair = new KeyValue("target", null);
            oldList.add(targetPair);
        }
        targetPair.value = new Integer(edge.getTarget().getRootGraphIndex());
        if (sourcePair == null) {
            sourcePair = new KeyValue("source", null);
            oldList.add(sourcePair);
        }
        sourcePair.value = new Integer(edge.getSource().getRootGraphIndex());
        if (view != Cytoscape.getNullNetworkView()) {
            if (graphicsPair == null) {
                graphicsPair = new KeyValue("graphics", new Vector());
                oldList.add(graphicsPair);
            }
            this.writeGraphEdgeGraphics(network, view.getEdgeView(edge), (List)graphicsPair.value);
        }
        if (labelPair == null) {
            labelPair = new KeyValue("label", null);
            oldList.add(labelPair);
        }
        labelPair.value = Cytoscape.getEdgeAttributes().getStringAttribute(edge.getIdentifier(), "interaction");
        return true;
    }

    private void writeGraphNodeGraphics(CyNetwork network, NodeView nodeView, List oldList) {
        KeyValue x = null;
        KeyValue y = null;
        KeyValue w = null;
        KeyValue h = null;
        KeyValue type = null;
        KeyValue fill = null;
        KeyValue outline = null;
        KeyValue outline_width = null;
        for (KeyValue keyVal : oldList) {
            if (keyVal.key.equals("x")) {
                x = keyVal;
                continue;
            }
            if (keyVal.key.equals("y")) {
                y = keyVal;
                continue;
            }
            if (keyVal.key.equals("w")) {
                w = keyVal;
                continue;
            }
            if (keyVal.key.equals("h")) {
                h = keyVal;
                continue;
            }
            if (keyVal.key.equals("type")) {
                type = keyVal;
                continue;
            }
            if (keyVal.key.equals("fill")) {
                fill = keyVal;
                continue;
            }
            if (keyVal.key.equals("outline")) {
                outline = keyVal;
                continue;
            }
            if (!keyVal.key.equals("outline_width")) continue;
            outline_width = keyVal;
        }
        if (x == null) {
            x = new KeyValue("x", null);
            oldList.add(x);
        }
        if (y == null) {
            y = new KeyValue("y", null);
            oldList.add(y);
        }
        if (w == null) {
            w = new KeyValue("w", null);
            oldList.add(w);
        }
        if (h == null) {
            h = new KeyValue("h", null);
            oldList.add(h);
        }
        if (fill == null) {
            fill = new KeyValue("fill", null);
            oldList.add(fill);
        }
        if (type == null) {
            type = new KeyValue("type", null);
            oldList.add(type);
        }
        if (outline == null) {
            outline = new KeyValue("outline", null);
            oldList.add(outline);
        }
        if (outline_width == null) {
            outline_width = new KeyValue("outline_width", null);
            oldList.add(outline_width);
        }
        x.value = new Double(nodeView.getXPosition());
        y.value = new Double(nodeView.getYPosition());
        w.value = new Double(nodeView.getWidth());
        h.value = new Double(nodeView.getHeight());
        fill.value = GMLWriter.getColorHexString((Color)nodeView.getUnselectedPaint());
        outline.value = GMLWriter.getColorHexString((Color)nodeView.getBorderPaint());
        outline_width.value = new Double(nodeView.getBorderWidth());
        switch (nodeView.getShape()) {
            case 6: {
                type.value = "rectangle";
                break;
            }
            case 2: {
                type.value = "ellipse";
                break;
            }
            case 1: {
                type.value = "diamond";
                break;
            }
            case 3: {
                type.value = "hexagon";
                break;
            }
            case 4: {
                type.value = "octagon";
                break;
            }
            case 5: {
                type.value = "parallelogram";
                break;
            }
            case 0: {
                type.value = "triangle";
            }
        }
    }

    private void writeGraphEdgeGraphics(CyNetwork network, EdgeView edgeView, List oldList) {
        KeyValue width = null;
        KeyValue fill = null;
        KeyValue line = null;
        KeyValue type = null;
        KeyValue source_arrow = null;
        KeyValue target_arrow = null;
        for (KeyValue keyVal : oldList) {
            if (keyVal.key.equals("width")) {
                width = keyVal;
                continue;
            }
            if (keyVal.key.equals("fill")) {
                fill = keyVal;
                continue;
            }
            if (keyVal.key.equals("Line")) {
                line = keyVal;
                continue;
            }
            if (keyVal.key.equals("type")) {
                type = keyVal;
                continue;
            }
            if (keyVal.key.equals("source_arrow")) {
                source_arrow = keyVal;
                continue;
            }
            if (!keyVal.key.equals("target_arrow")) continue;
            target_arrow = keyVal;
        }
        if (width == null) {
            width = new KeyValue("width", null);
            oldList.add(width);
        }
        width.value = new Double(edgeView.getStrokeWidth());
        if (fill == null) {
            fill = new KeyValue("fill", null);
            oldList.add(fill);
        }
        fill.value = GMLWriter.getColorHexString((Color)edgeView.getUnselectedPaint());
        if (type == null) {
            type = new KeyValue("type", null);
            oldList.add(type);
        }
        switch (edgeView.getLineType()) {
            case 2: {
                type.value = "line";
                break;
            }
            case 1: {
                type.value = "curved";
            }
        }
        if (line == null) {
            line = new KeyValue("Line", null);
            oldList.add(line);
        }
        Point2D[] pointsArray = edgeView.getBend().getDrawPoints();
        Vector<KeyValue> points = new Vector<KeyValue>(pointsArray.length);
        for (int idx = pointsArray.length - 2; idx > 0; --idx) {
            Vector<KeyValue> coords = new Vector<KeyValue>(2);
            coords.add(new KeyValue("x", new Double(pointsArray[idx].getX())));
            coords.add(new KeyValue("y", new Double(pointsArray[idx].getY())));
            points.add(new KeyValue("point", coords));
        }
        line.value = points;
        if (source_arrow == null) {
            source_arrow = new KeyValue("source_arrow", null);
            oldList.add(source_arrow);
        }
        source_arrow.value = new Integer(edgeView.getSourceEdgeEnd());
        if (target_arrow == null) {
            target_arrow = new KeyValue("target_arrow", null);
            oldList.add(target_arrow);
        }
        target_arrow.value = new Integer(edgeView.getTargetEdgeEnd());
    }

    private static String getColorHexString(Color c) {
        return "#" + Integer.toHexString(256 + c.getRed()).substring(1) + Integer.toHexString(256 + c.getGreen()).substring(1) + Integer.toHexString(256 + c.getBlue()).substring(1);
    }
}

