## ----knitr, echo=FALSE, results="hide"-----------------------------------
library("knitr")
opts_chunk$set(tidy=FALSE,
               fig.width=6,fig.height=5,
               message=FALSE)

## ----style, eval=TRUE, echo=FALSE, results="asis"--------------------------
BiocStyle::latex()

## ----package-load,message=FALSE--------------------------------------------
library(DEGreport)
data(humanGender)

## ----chunk-1---------------------------------------------------------------
library(DESeq2)
idx <- c(1:10, 75:85)
dds <- DESeqDataSetFromMatrix(assays(humanGender)[[1]][1:1000, idx],
                              colData(humanGender)[idx,], design=~group)
dds <- DESeq(dds)
res <- results(dds)

## ----chunk-2---------------------------------------------------------------
counts <- counts(dds, normalized = TRUE)
design <- as.data.frame(colData(dds))

## ----chunk-size-factor-----------------------------------------------------
degCheckFactors(counts[, 1:6])

## ----chunk-qc--------------------------------------------------------------
degQC(counts, design[["group"]], pvalue = res[["pvalue"]])

## ----chunk-covariates------------------------------------------------------
resCov <- degCovariates(log2(counts(dds)+0.5),
                        colData(dds))

## ----chunk-cor-covariates--------------------------------------------------
cor <- degCorCov(colData(dds))
names(cor)

## ----chunk-qc-report, eval=FALSE-------------------------------------------
#  createReport(colData(dds)[["group"]], counts(dds, normalized = TRUE),
#               row.names(res)[1:20], res[["pvalue"]], path = "~/Downloads")

## ----chunk-degComps--------------------------------------------------------
degs <- degComps(dds, combs = "group",
                 contrast = list("group_Male_vs_Female",
                                 c("group", "Female", "Male")))
names(degs)

## ----chunk-deg-------------------------------------------------------------
deg(degs[[1]])

## ----chunk-deg-raw---------------------------------------------------------
deg(degs[[1]], "raw", "tibble")

## ----chunk-significants----------------------------------------------------
significants(degs[[1]], fc = 0, fdr = 0.05)

## ----chunk-plotMA----------------------------------------------------------
plotMA(degs[[1]], diff = 2, limit = 3)

## ----chunk-plotMA-raw------------------------------------------------------
plotMA(degs[[1]], diff = 2, limit = 3, raw = TRUE)

## ----chunk-plotMA-cor------------------------------------------------------
plotMA(degs[[1]], limit = 3, correlation = TRUE)

## ----deseq2-volcano--------------------------------------------------------
res[["id"]] <- row.names(res)
# show <- as.data.frame(res[1:10, c("log2FoldChange", "padj", "id")])
degVolcano(res[,c("log2FoldChange", "padj")])

## ----deseq2-gene-plots-----------------------------------------------------
degPlot(dds = dds, res = res, n = 6, xs = "group")

## ----deseq2-gene-plot-wide-------------------------------------------------
degPlotWide(dds, rownames(dds)[1:5], group="group")

## ----deseq2----------------------------------------------------------------
resreport <- degResults(dds = dds, name = "test", org = NULL,
                        do_go = FALSE, group = "group", xs = "group",
                        path_results = NULL)

## ----chunk-shiny, eval=FALSE-----------------------------------------------
#  degObj(counts, design, "degObj.rda")
#  library(shiny)
#  shiny::runGitHub("lpantano/shiny", subdir="expression")

## ----pattern---------------------------------------------------------------
ma = assay(rlog(dds))[row.names(res)[1:100],]
res <- degPatterns(ma, design, time = "group", col=NULL)

## ----chunk-filter----------------------------------------------------------
cat("gene in original count matrix: 1000")
filter_count <- degFilter(counts(dds),
                          design, "group",
                          min=1, minreads = 50)
cat("gene in final count matrix", nrow(filter_count))

