## ----style, echo=FALSE, results="asis", cache=FALSE, message=FALSE--------------------------------
library(knitr)
library(rmarkdown)
BiocStyle::markdown()

opts_chunk$set(fig.width=14, fig.height=10, cache=TRUE, 
error=FALSE, message = FALSE)
options(digits = 4, scipen = 10, stringsAsFactors = FALSE, width=100)
#options("citation_format" = "pandoc")

## ----setup, cache = FALSE-------------------------------------------------------------------------
library(DChIPRep)
library(ggplot2)
library(DESeq2)

## ----pythonScripts ,cache=FALSE-------------------------------------------------------------------

pythonScriptsDir <- system.file( "exec" , package = "DChIPRep" ) 
pythonScriptsDir
list.files(pythonScriptsDir)


## ----sampleTable, markup = 'asis', message = TRUE-------------------------------------------------
data(exampleSampleTable)
exampleSampleTable

## ----data_import_R_Py, dependson="sampleTable"----------------------------------------------------
directory <- file.path(system.file("extdata", package="DChIPRep"))
importedData <- importData(exampleSampleTable, directory)

## ----show_imported_data, dependson="data_import_R_Py"---------------------------------------------
importedData
DESeq2Data(importedData) 
head(normalizationFactors(DESeq2Data(importedData)))

## ----inspect_example_data, dependson="sampleTable"------------------------------------------------

data(exampleInputData)
data(exampleChipData)

exampleSampleTable

exampleInputData[1:10, ]
exampleChipData[1:10, ]

imDataFromMatrices <- importDataFromMatrices(inputData = exampleInputData, 
                                              chipData = exampleChipData, 
                                              sampleTable = exampleSampleTable)
  

## ----import_soGGi, eval = FALSE-------------------------------------------------------------------
#  
#  data(sample_table_galonska)
#  data(TSS_galonska)
#  
#  bam_dir <- file.path(system.file("extdata", package="DChIPRep"))
#  wce_bam <- "subsampled_0001_pc_SRR2144628_WCE_bowtie2_mapped-only_XS-filt_no-dups.bam"
#  mat_wce <- importData_soGGi(bam_paths = file.path(bam_dir, wce_bam),
#                           TSS = TSS_galonska,
#                           fragment_lengths = sample_table_galonska$input_fragment_length[1],
#                           sample_ids =  sample_table_galonska$input[1],
#                        paired = FALSE,
#                          removeDup=FALSE
#  )
#  
#  head(mat_wce)
#  

## ----perform_Tests, dependson="inspect_example_data"----------------------------------------------
imDataFromMatrices  <- runTesting(imDataFromMatrices, plotFDR = TRUE)

## ----accessResults, dependson="perform_Tests"-----------------------------------------------------

res <- resultsDChIPRep(imDataFromMatrices)
head(res)

table( res$lfdr < 0.2)

## ----plot_Sig, dependson="accessResults"----------------------------------------------------------

sigPlot <- plotSignificance(imDataFromMatrices)
sigPlot

## ----plot_TSS, dependson="accessResults"----------------------------------------------------------
profilePlot <- plotProfiles(imDataFromMatrices)
profilePlot

## ---- cache=FALSE---------------------------------------------------------------------------------
sessionInfo()

