### R code from vignette source 'CellMapper.Rnw'

###################################################
### code chunk number 1: style
###################################################
BiocStyle::latex()


###################################################
### code chunk number 2: CellMapper.Rnw:66-68 (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("CellMapper")


###################################################
### code chunk number 3: CellMapper.Rnw:83-87
###################################################
library("ExperimentHub")
hub <- ExperimentHub()
x <- query(hub, "CellMapperData")
x


###################################################
### code chunk number 4: CellMapper.Rnw:96-98
###################################################
BrainAtlas <- hub[["EH170"]]
BrainAtlas


###################################################
### code chunk number 5: CellMapper.Rnw:192-193
###################################################
library(CellMapper)


###################################################
### code chunk number 6: CellMapper.Rnw:207-210
###################################################
library(ExperimentHub)
hub <- ExperimentHub()
query(hub, "CellMapperData")


###################################################
### code chunk number 7: CellMapper.Rnw:216-217
###################################################
BrainAtlas <- hub[["EH170"]]


###################################################
### code chunk number 8: CellMapper.Rnw:225-226
###################################################
query <- "2571"


###################################################
### code chunk number 9: CellMapper.Rnw:233-234
###################################################
GABAergic <- CMsearch(BrainAtlas, query.genes = query)


###################################################
### code chunk number 10: CellMapper.Rnw:241-242
###################################################
head(GABAergic)


###################################################
### code chunk number 11: CellMapper.Rnw:247-248 (eval = FALSE)
###################################################
## write.csv(GABAergic, file = "CellMapper analysis for GABAergic neurons.csv")


###################################################
### code chunk number 12: CellMapper.Rnw:260-263
###################################################
Engreitz <- hub[["EH171"]]
Lukk <- hub[["EH172"]]
ZhengBradley <- hub[["EH173"]]


###################################################
### code chunk number 13: CellMapper.Rnw:274-279
###################################################
query2 <- "3856"

SimpleEpithelia <- CMsearch(list(Engreitz, Lukk, ZhengBradley), query.genes = 
query2)
head(SimpleEpithelia)


###################################################
### code chunk number 14: CellMapper.Rnw:309-311
###################################################
library(ALL)
data(ALL)


###################################################
### code chunk number 15: CellMapper.Rnw:316-317
###################################################
prepped.data <- CMprep(ALL)


###################################################
### code chunk number 16: CellMapper.Rnw:327-328 (eval = FALSE)
###################################################
## save(prepped.data, file = "Custom Data for CellMapper.Rdata")


###################################################
### code chunk number 17: CellMapper.Rnw:333-334 (eval = FALSE)
###################################################
## load("Custom Data for CellMapper.Rdata")


###################################################
### code chunk number 18: CellMapper.Rnw:345-347
###################################################
out <- CMsearch(prepped.data, query.genes = "1000_at")
head(out)


###################################################
### code chunk number 19: CellMapper.Rnw:382-383
###################################################
query(hub, "HumanAffyData")


###################################################
### code chunk number 20: CellMapper.Rnw:388-390
###################################################
E.MTAB.62 <- hub[["EH177"]]
E.MTAB.62


###################################################
### code chunk number 21: CellMapper.Rnw:399-400
###################################################
pDat <- pData(E.MTAB.62)


###################################################
### code chunk number 22: CellMapper.Rnw:408-409
###################################################
unique(pDat$OrganismPart)[1:30]


###################################################
### code chunk number 23: CellMapper.Rnw:417-419
###################################################
samples <- which(pDat$OrganismPart %in% c("colon", "colon mucosa",
"Small intestine"))


###################################################
### code chunk number 24: CellMapper.Rnw:425-426
###################################################
Lukk_unprocessed.gut <- exprs(E.MTAB.62)[, samples] 


###################################################
### code chunk number 25: CellMapper.Rnw:434-435
###################################################
Lukk.gut <- CMprep(Lukk_unprocessed.gut)


###################################################
### code chunk number 26: CellMapper.Rnw:443-445
###################################################
GSE64985 <- hub[["EH176"]]
pDat <- pData(GSE64985)


###################################################
### code chunk number 27: CellMapper.Rnw:454-460
###################################################
keywords <- c("colon", "intestin")

select = grepl(paste(keywords, collapse = "|"),
	pDat$title, ignore.case = TRUE) | 
	grepl(paste(keywords, collapse = "|"), 
	pDat$description, ignore.case = TRUE)


###################################################
### code chunk number 28: CellMapper.Rnw:468-469
###################################################
Engreitz_unprocessed.gut = exprs(GSE64985)[,select]


###################################################
### code chunk number 29: CellMapper.Rnw:474-475
###################################################
Engreitz.gut = CMprep(Engreitz_unprocessed.gut)


###################################################
### code chunk number 30: CellMapper.Rnw:482-486
###################################################
query = "1113"
EECs <- CMsearch(list(Lukk = Lukk.gut, Engreitz = Engreitz.gut), query.genes = 
	query)
head(EECs)


