/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import weka.experiment.Experiment;
import weka.gui.experiment.SetupPanel;
import weka.gui.experiment.SimpleSetupPanel;

public class SetupModePanel
extends JPanel {
    protected JRadioButton m_SimpleSetupRBut = new JRadioButton("Simple");
    protected JRadioButton m_AdvancedSetupRBut = new JRadioButton("Advanced");
    protected SimpleSetupPanel m_simplePanel = new SimpleSetupPanel();
    protected SetupPanel m_advancedPanel = new SetupPanel();

    public SetupModePanel() {
        this.m_simplePanel.setModePanel(this);
        this.m_SimpleSetupRBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetupModePanel.this.switchToSimple(null);
            }
        });
        this.m_AdvancedSetupRBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetupModePanel.this.switchToAdvanced(null);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_SimpleSetupRBut);
        buttonGroup.add(this.m_AdvancedSetupRBut);
        this.m_SimpleSetupRBut.setSelected(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 0));
        jPanel.add(this.m_SimpleSetupRBut);
        jPanel.add(this.m_AdvancedSetupRBut);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 0));
        jPanel2.add(new JLabel("Experiment Configuration Mode:"));
        jPanel2.add(jPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel2, "North");
        this.add((Component)this.m_simplePanel, "Center");
    }

    public void switchToAdvanced(Experiment experiment) {
        if (experiment == null) {
            experiment = this.m_simplePanel.getExperiment();
        }
        if (experiment != null) {
            this.m_AdvancedSetupRBut.setSelected(true);
            this.m_advancedPanel.setExperiment(experiment);
        }
        this.remove(this.m_simplePanel);
        this.m_simplePanel.removeNotesFrame();
        this.add((Component)this.m_advancedPanel, "Center");
        this.validate();
        this.repaint();
    }

    public void switchToSimple(Experiment experiment) {
        if (experiment == null) {
            experiment = this.m_advancedPanel.getExperiment();
        }
        if (experiment != null && !this.m_simplePanel.setExperiment(experiment)) {
            this.m_AdvancedSetupRBut.setSelected(true);
            this.switchToAdvanced(experiment);
        } else {
            this.remove(this.m_advancedPanel);
            this.m_advancedPanel.removeNotesFrame();
            this.add((Component)this.m_simplePanel, "Center");
            this.validate();
            this.repaint();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_simplePanel.addPropertyChangeListener(propertyChangeListener);
        this.m_advancedPanel.addPropertyChangeListener(propertyChangeListener);
    }

    public Experiment getExperiment() {
        if (this.m_SimpleSetupRBut.isSelected()) {
            return this.m_simplePanel.getExperiment();
        }
        return this.m_advancedPanel.getExperiment();
    }
}

