/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.clusterers.DensityBasedClusterer;
import weka.clusterers.EM;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.Remove;

public class ClusterMembership
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    protected DensityBasedClusterer m_clusterer = new EM();
    protected DensityBasedClusterer[] m_clusterers;
    protected Range m_ignoreAttributesRange;
    protected Filter m_removeAttributes;
    protected double[] m_priors;

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.m_removeAttributes = null;
        this.m_priors = null;
        return false;
    }

    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.outputFormatPeek() == null) {
            int n;
            int n2;
            Instances[] instancesArray;
            Instances instances = this.getInputFormat();
            if (instances.classIndex() >= 0 && instances.classAttribute().isNominal()) {
                int n3;
                instancesArray = new Instances[instances.numClasses()];
                for (n3 = 0; n3 < instances.numClasses(); ++n3) {
                    instancesArray[n3] = new Instances(instances, instances.numInstances());
                }
                for (n3 = 0; n3 < instances.numInstances(); ++n3) {
                    instancesArray[(int)instances.instance(n3).classValue()].add(instances.instance(n3));
                }
                this.m_priors = new double[instances.numClasses()];
                for (n3 = 0; n3 < instances.numClasses(); ++n3) {
                    instancesArray[n3].compactify();
                    this.m_priors[n3] = instancesArray[n3].sumOfWeights();
                }
                Utils.normalize(this.m_priors);
            } else {
                instancesArray = new Instances[]{instances};
                this.m_priors = new double[1];
                this.m_priors[0] = 1.0;
            }
            if (this.m_ignoreAttributesRange != null || instances.classIndex() >= 0) {
                this.m_removeAttributes = new Remove();
                String string = "";
                if (this.m_ignoreAttributesRange != null) {
                    string = string + this.m_ignoreAttributesRange.getRanges();
                }
                if (instances.classIndex() >= 0) {
                    string = string.length() > 0 ? string + "," + (instances.classIndex() + 1) : "" + (instances.classIndex() + 1);
                }
                ((Remove)this.m_removeAttributes).setAttributeIndices(string);
                ((Remove)this.m_removeAttributes).setInvertSelection(false);
                ((Remove)this.m_removeAttributes).setInputFormat(instances);
                for (n2 = 0; n2 < instancesArray.length; ++n2) {
                    instancesArray[n2] = Filter.useFilter(instancesArray[n2], this.m_removeAttributes);
                }
            }
            if (instances.classIndex() <= 0 || !instances.classAttribute().isNominal()) {
                this.m_clusterers = DensityBasedClusterer.makeCopies(this.m_clusterer, 1);
                this.m_clusterers[0].buildClusterer(instancesArray[0]);
            } else {
                this.m_clusterers = DensityBasedClusterer.makeCopies(this.m_clusterer, instances.numClasses());
                for (int i = 0; i < this.m_clusterers.length; ++i) {
                    if (instancesArray[i].numInstances() == 0) {
                        this.m_clusterers[i] = null;
                        continue;
                    }
                    this.m_clusterers[i].buildClusterer(instancesArray[i]);
                }
            }
            FastVector fastVector = new FastVector();
            for (n2 = 0; n2 < this.m_clusterers.length; ++n2) {
                if (this.m_clusterers[n2] == null) continue;
                for (n = 0; n < this.m_clusterers[n2].numberOfClusters(); ++n) {
                    fastVector.addElement(new Attribute("pCluster_" + n2 + "_" + n));
                }
            }
            if (instances.classIndex() >= 0) {
                fastVector.addElement(instances.classAttribute().copy());
            }
            fastVector.trimToSize();
            Instances instances2 = new Instances(instances.relationName() + "_clusterMembership", fastVector, 0);
            if (instances.classIndex() >= 0) {
                instances2.setClassIndex(instances2.numAttributes() - 1);
            }
            this.setOutputFormat(instances2);
            for (n = 0; n < instances.numInstances(); ++n) {
                this.convertInstance(instances.instance(n));
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.outputFormatPeek() != null) {
            this.convertInstance(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    protected double[] logs2densities(int n, Instance instance) throws Exception {
        double[] dArray = this.m_clusterers[n].logJointDensitiesForInstance(instance);
        int n2 = 0;
        while (n2 < dArray.length) {
            int n3 = n2++;
            dArray[n3] = dArray[n3] + Math.log(this.m_priors[n]);
        }
        return dArray;
    }

    protected void convertInstance(Instance instance) throws Exception {
        double[] dArray = new double[this.outputFormatPeek().numAttributes()];
        double[] dArray2 = instance.classIndex() >= 0 ? new double[this.outputFormatPeek().numAttributes() - 1] : new double[this.outputFormatPeek().numAttributes()];
        int n = 0;
        for (int i = 0; i < this.m_clusterers.length; ++i) {
            double[] dArray3;
            if (this.m_clusterers[i] == null) continue;
            if (this.m_removeAttributes != null) {
                this.m_removeAttributes.input(instance);
                dArray3 = this.logs2densities(i, this.m_removeAttributes.output());
            } else {
                dArray3 = this.logs2densities(i, instance);
            }
            System.arraycopy(dArray3, 0, dArray2, n, dArray3.length);
            n += dArray3.length;
        }
        dArray2 = Utils.logs2probs(dArray2);
        System.arraycopy(dArray2, 0, dArray, 0, dArray2.length);
        if (instance.classIndex() >= 0) {
            dArray[dArray.length - 1] = instance.classValue();
        }
        this.push(new Instance(instance.weight(), dArray));
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tFull name of clusterer to use (required).\n\teg: weka.clusterers.EM", "W", 1, "-W <clusterer name>"));
        vector.addElement(new Option("\tThe range of attributes the clusterer should ignore.\n\t(the class attribute is automatically ignored)", "I", 1, "-I <att1,att2-att4,...>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('W', stringArray);
        if (string.length() == 0) {
            throw new Exception("A clusterer must be specified with the -W option.");
        }
        this.setDensityBasedClusterer((DensityBasedClusterer)Utils.forName(DensityBasedClusterer.class, string, Utils.partitionOptions(stringArray)));
        this.setIgnoredAttributeIndices(Utils.getOption('I', stringArray));
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[]{};
        if (this.m_clusterer != null && this.m_clusterer instanceof OptionHandler) {
            stringArray = ((OptionHandler)((Object)this.m_clusterer)).getOptions();
        }
        String[] stringArray2 = new String[stringArray.length + 5];
        int n = 0;
        if (!this.getIgnoredAttributeIndices().equals("")) {
            stringArray2[n++] = "-I";
            stringArray2[n++] = this.getIgnoredAttributeIndices();
        }
        if (this.m_clusterer != null) {
            stringArray2[n++] = "-W";
            stringArray2[n++] = this.getDensityBasedClusterer().getClass().getName();
        }
        stringArray2[n++] = "--";
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public String globalInfo() {
        return "A filter that uses a density-based clusterer to generate cluster membership values; filtered instances are composed of these values plus the class attribute (if set in the input data). If a (nominal) class attribute is set, the clusterer is run separately for each class. The class attribute (if set) and any user-specified attributes are ignored during the clustering operation";
    }

    public String clustererTipText() {
        return "The clusterer that will generate membership values for the instances.";
    }

    public void setDensityBasedClusterer(DensityBasedClusterer densityBasedClusterer) {
        this.m_clusterer = densityBasedClusterer;
    }

    public DensityBasedClusterer getDensityBasedClusterer() {
        return this.m_clusterer;
    }

    public String ignoredAttributeIndicesTipText() {
        return "The range of attributes to be ignored by the clusterer. eg: first-3,5,9-last";
    }

    public String getIgnoredAttributeIndices() {
        if (this.m_ignoreAttributesRange == null) {
            return "";
        }
        return this.m_ignoreAttributesRange.getRanges();
    }

    public void setIgnoredAttributeIndices(String string) {
        if (string == null || string.length() == 0) {
            this.m_ignoreAttributesRange = null;
        } else {
            this.m_ignoreAttributesRange = new Range();
            this.m_ignoreAttributesRange.setRanges(string);
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new ClusterMembership(), stringArray);
            } else {
                Filter.filterFile(new ClusterMembership(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

