/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.Serializable;
import java.util.Enumeration;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.NoSupportForMissingValuesException;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.UnsupportedClassTypeException;

public class Prism
extends Classifier {
    private PrismRule m_rules;

    public String globalInfo() {
        return "Class for building and using a PRISM rule set for classification. Can only deal with nominal attributes. Can't deal with missing values. Doesn't do any pruning. For more information, see \n\nJ. Cendrowska (1987). \"PRISM: An algorithm for inducing modular rules\". International Journal of Man-Machine Studies. Vol.27, No.4, pp.349-370.";
    }

    public double classifyInstance(Instance instance) {
        int n = this.m_rules.resultRules(instance);
        if (n == -1) {
            return Instance.missingValue();
        }
        return n;
    }

    public void buildClassifier(Instances instances) throws Exception {
        Attribute attribute;
        PrismRule prismRule = null;
        Test test = null;
        Test test2 = null;
        if (instances.checkForStringAttributes()) {
            throw new UnsupportedAttributeTypeException("Cannot handle string attributes!");
        }
        if (instances.classAttribute().isNumeric()) {
            throw new UnsupportedClassTypeException("Prism can't handle a numeric class!");
        }
        instances = new Instances(instances);
        Enumeration enumeration = instances.enumerateAttributes();
        while (enumeration.hasMoreElements()) {
            attribute = (Attribute)enumeration.nextElement();
            if (!attribute.isNominal()) {
                throw new UnsupportedAttributeTypeException("Prism can only deal with nominal attributes!");
            }
            Enumeration enumeration2 = instances.enumerateInstances();
            while (enumeration2.hasMoreElements()) {
                if (!((Instance)enumeration2.nextElement()).isMissing(attribute)) continue;
                throw new NoSupportForMissingValuesException("Prism can't handle attributes with missing values!");
            }
        }
        instances.deleteWithMissingClass();
        if (instances.numInstances() == 0) {
            throw new Exception("No instances with a class value!");
        }
        for (int i = 0; i < instances.numClasses(); ++i) {
            Instances instances2 = instances;
            while (Prism.contains(instances2, i)) {
                prismRule = this.addRule(prismRule, new PrismRule(instances2, i));
                Instances instances3 = instances2;
                while (prismRule.m_errors != 0) {
                    test = new Test();
                    int n = 0;
                    int n2 = 0;
                    int n3 = 0;
                    enumeration = instances3.enumerateAttributes();
                    while (enumeration.hasMoreElements()) {
                        attribute = (Attribute)enumeration.nextElement();
                        if (Prism.isMentionedIn(attribute, prismRule.m_test)) {
                            ++n;
                            continue;
                        }
                        int n4 = attribute.numValues();
                        int[] nArray = new int[n4];
                        int[] nArray2 = new int[n4];
                        for (int j = 0; j < n4; ++j) {
                            nArray2[j] = 0;
                            nArray[j] = 0;
                        }
                        Enumeration enumeration3 = instances3.enumerateInstances();
                        while (enumeration3.hasMoreElements()) {
                            Instance instance = (Instance)enumeration3.nextElement();
                            int n5 = (int)instance.value(attribute);
                            nArray[n5] = nArray[n5] + 1;
                            if ((int)instance.classValue() != i) continue;
                            int n6 = (int)instance.value(attribute);
                            nArray2[n6] = nArray2[n6] + 1;
                        }
                        for (int j = 0; j < n4; ++j) {
                            int n7 = nArray2[j] * n2 - n3 * nArray[j];
                            if (test.m_attr != -1 && n7 <= 0 && (n7 != 0 || nArray2[j] <= n3)) continue;
                            n3 = nArray2[j];
                            n2 = nArray[j];
                            test.m_attr = attribute.index();
                            test.m_val = j;
                            prismRule.m_errors = n2 - n3;
                        }
                    }
                    if (test.m_attr == -1) break;
                    test2 = this.addTest(prismRule, test2, test);
                    instances3 = prismRule.coveredBy(instances3);
                    if (n != instances.numAttributes() - 1) continue;
                }
                instances2 = prismRule.notCoveredBy(instances2);
            }
        }
    }

    private PrismRule addRule(PrismRule prismRule, PrismRule prismRule2) {
        if (prismRule == null) {
            this.m_rules = prismRule2;
        } else {
            prismRule.m_next = prismRule2;
        }
        return prismRule2;
    }

    private Test addTest(PrismRule prismRule, Test test, Test test2) {
        if (prismRule.m_test == null) {
            prismRule.m_test = test2;
        } else {
            test.m_next = test2;
        }
        return test2;
    }

    private static boolean contains(Instances instances, int n) throws Exception {
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            if ((int)((Instance)enumeration.nextElement()).classValue() != n) continue;
            return true;
        }
        return false;
    }

    private static boolean isMentionedIn(Attribute attribute, Test test) {
        if (test == null) {
            return false;
        }
        if (test.m_attr == attribute.index()) {
            return true;
        }
        return Prism.isMentionedIn(attribute, test.m_next);
    }

    public String toString() {
        if (this.m_rules == null) {
            return "Prism: No model built yet.";
        }
        return "Prism rules\n----------\n" + this.m_rules.toString();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new Prism(), stringArray));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    private class Test
    implements Serializable {
        private int m_attr = -1;
        private int m_val;
        private Test m_next = null;

        private Test() {
        }

        private boolean satisfies(Instance instance) {
            if ((int)instance.value(this.m_attr) == this.m_val) {
                if (this.m_next == null) {
                    return true;
                }
                return this.m_next.satisfies(instance);
            }
            return false;
        }
    }

    private class PrismRule
    implements Serializable {
        private int m_classification;
        private Instances m_instances;
        private Test m_test;
        private int m_errors;
        private PrismRule m_next;

        public PrismRule(Instances instances, int n) throws Exception {
            this.m_instances = instances;
            this.m_classification = n;
            this.m_test = null;
            this.m_next = null;
            this.m_errors = 0;
            Enumeration enumeration = instances.enumerateInstances();
            while (enumeration.hasMoreElements()) {
                if ((int)((Instance)enumeration.nextElement()).classValue() == n) continue;
                ++this.m_errors;
            }
            this.m_instances = new Instances(this.m_instances, 0);
        }

        public int resultRule(Instance instance) {
            if (this.m_test == null || this.m_test.satisfies(instance)) {
                return this.m_classification;
            }
            return -1;
        }

        public int resultRules(Instance instance) {
            if (this.resultRule(instance) != -1) {
                return this.m_classification;
            }
            if (this.m_next != null) {
                return this.m_next.resultRules(instance);
            }
            return -1;
        }

        public Instances coveredBy(Instances instances) {
            Instances instances2 = new Instances(instances, instances.numInstances());
            Enumeration enumeration = instances.enumerateInstances();
            while (enumeration.hasMoreElements()) {
                Instance instance = (Instance)enumeration.nextElement();
                if (this.resultRule(instance) == -1) continue;
                instances2.add(instance);
            }
            instances2.compactify();
            return instances2;
        }

        public Instances notCoveredBy(Instances instances) {
            Instances instances2 = new Instances(instances, instances.numInstances());
            Enumeration enumeration = instances.enumerateInstances();
            while (enumeration.hasMoreElements()) {
                Instance instance = (Instance)enumeration.nextElement();
                if (this.resultRule(instance) != -1) continue;
                instances2.add(instance);
            }
            instances2.compactify();
            return instances2;
        }

        public String toString() {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                if (this.m_test != null) {
                    stringBuffer.append("If ");
                    Test test = this.m_test;
                    while (test != null) {
                        if (test.m_attr == -1) {
                            stringBuffer.append("?");
                        } else {
                            stringBuffer.append(this.m_instances.attribute(test.m_attr).name() + " = " + this.m_instances.attribute(test.m_attr).value(test.m_val));
                        }
                        if (test.m_next != null) {
                            stringBuffer.append("\n   and ");
                        }
                        test = test.m_next;
                    }
                    stringBuffer.append(" then ");
                }
                stringBuffer.append(this.m_instances.classAttribute().value(this.m_classification) + "\n");
                if (this.m_next != null) {
                    stringBuffer.append(this.m_next.toString());
                }
                return stringBuffer.toString();
            }
            catch (Exception exception) {
                return "Can't print Prism classifier!";
            }
        }
    }
}

