## ------------------------------------------------------------------------
#source("https://bioconductor.org/biocLite.R")
#biocLite("BgeeDB")

## ---- message = FALSE, warning = FALSE-----------------------------------
library(BgeeDB)

## ------------------------------------------------------------------------
listBgeeSpecies()

## ------------------------------------------------------------------------
listBgeeSpecies(release = "13.2", order = 2)

## ------------------------------------------------------------------------
bgee <- Bgee$new(species = "Mus_musculus", dataType = "rna_seq")

## ------------------------------------------------------------------------
annotation_bgee_mouse <- getAnnotation(bgee)
# list the first experiments and libraries
lapply(annotation_bgee_mouse, head)

## ------------------------------------------------------------------------
# download all RNA-seq experiments from mouse
data_bgee_mouse <- getData(bgee)
# number of experiments downloaded
length(data_bgee_mouse)
# check the downloaded data
lapply(data_bgee_mouse, head)
# isolate the first experiment
data_bgee_experiment1 <- data_bgee_mouse[[1]]

## ------------------------------------------------------------------------
# download data for GSE30617
data_bgee_mouse_gse30617 <- getData(bgee, experimentId = "GSE30617")

## ------------------------------------------------------------------------
# use only present calls and fill expression matric with RPKM values
gene.expression.mouse.rpkm <- formatData(bgee, data_bgee_mouse_gse30617, callType = "present", stats = "rpkm")
gene.expression.mouse.rpkm 

## ------------------------------------------------------------------------
# Creating new Bgee class object
bgee <- Bgee$new(species = "Danio_rerio")

## ------------------------------------------------------------------------
# Loading calls of expression
myTopAnatData <- loadTopAnatData(bgee)
# Look at the data
## str(myTopAnatData)

## ---- eval=FALSE---------------------------------------------------------
#  ## Loading only high-quality expression calls from affymetrix data made on embryonic samples only
#  ## This is just given as an example, but is not run in this vignette because only few data are returned
#  bgee <- Bgee$new(species = "Danio_rerio", dataType="affymetrix")
#  myTopAnatData <- loadTopAnatData(bgee, stage="UBERON:0000068", confidence="high_quality")

## ---- eval=FALSE---------------------------------------------------------
#  # source("https://bioconductor.org/biocLite.R")
#  # biocLite("biomaRt")
#  library(biomaRt)
#  ensembl <- useMart("ensembl")
#  ensembl <- useDataset("drerio_gene_ensembl", mart=ensembl)
#  
#  # Foreground genes are those with GO annotation "spermatogenesis" or childrem terms
#  myGenes <- getBM(attributes= "ensembl_gene_id", filters=c("go_parent_term"), values=list(c("GO:0007283")), mart=ensembl)
#  
#  # Background are all genes with GO annotation
#  universe <- getBM(attributes= "ensembl_gene_id", filters=c("with_go"), values=list(c(TRUE)), mart=ensembl)
#  
#  # Prepare the gene list vector
#  geneList <- factor(as.integer(universe[,1] %in% myGenes[,1]))
#  names(geneList) <- universe[,1]
#  head(geneList)
#  summary(geneList == 1)
#  
#  # Prepare the topGO object
#  myTopAnatObject <-  topAnat(myTopAnatData, geneList)

## ------------------------------------------------------------------------
data(geneList)
myTopAnatObject <-  topAnat(myTopAnatData, geneList)

## ------------------------------------------------------------------------
results <- runTest(myTopAnatObject, algorithm = 'classic', statistic = 'fisher')

## ---- eval=FALSE---------------------------------------------------------
#  results <- runTest(myTopAnatObject, algorithm = 'weight', statistic = 'fisher')

## ------------------------------------------------------------------------
# Display results sigificant at a 10% FDR threshold
makeTable(myTopAnatData, myTopAnatObject, results, cutoff = 0.1)

