### R code from vignette source 'BaseSpaceR.Rnw'

###################################################
### code chunk number 1: BaseSpaceR.Rnw:41-42
###################################################
options(width = 95)


###################################################
### code chunk number 2: BaseSpaceR.Rnw:133-135 (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite()


###################################################
### code chunk number 3: BaseSpaceR.Rnw:141-143 (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("BaseSpaceR")


###################################################
### code chunk number 4: BaseSpaceR.Rnw:147-148
###################################################
library(BaseSpaceR)


###################################################
### code chunk number 5: BaseSpaceR.Rnw:269-271
###################################################
data(aAuth)
aAuth


###################################################
### code chunk number 6: BaseSpaceR.Rnw:289-291
###################################################
u <- Users(aAuth)
u


###################################################
### code chunk number 7: BaseSpaceR.Rnw:298-300
###################################################
Id(u)
Name(u)


###################################################
### code chunk number 8: BaseSpaceR.Rnw:308-311
###################################################
u$Id
u$Email
u$fakeElement


###################################################
### code chunk number 9: BaseSpaceR.Rnw:318-322
###################################################
u <- Users()
u
u$Id
u$UserOwnedBy


###################################################
### code chunk number 10: BaseSpaceR.Rnw:329-331
###################################################
Users(aAuth, id = 1463464)
Users(aAuth, id = "1463464")


###################################################
### code chunk number 11: BaseSpaceR.Rnw:347-349
###################################################
g <- listGenomes(aAuth, Limit = 100)
g$SpeciesName


###################################################
### code chunk number 12: BaseSpaceR.Rnw:362-364
###################################################
length(g)
TotalCount(g)


###################################################
### code chunk number 13: BaseSpaceR.Rnw:370-372
###################################################
g[[3]]
is(g[[3]], "Item")


###################################################
### code chunk number 14: BaseSpaceR.Rnw:378-380
###################################################
g[2:4]
g[1]


###################################################
### code chunk number 15: BaseSpaceR.Rnw:393-397
###################################################
listGenomes(aAuth, Limit = 2)
g <- listGenomes(aAuth, Offset = 5, Limit = 2, SortBy = "Build")
g
TotalCount(g) # Collection size remains constant


###################################################
### code chunk number 16: BaseSpaceR.Rnw:404-405
###################################################
Genomes(aAuth, id = 4)


###################################################
### code chunk number 17: BaseSpaceR.Rnw:412-413
###################################################
Genomes(aAuth, id = c(4, 1, 110))


###################################################
### code chunk number 18: BaseSpaceR.Rnw:420-421
###################################################
Genomes(aAuth, id = 4, simplify = TRUE)


###################################################
### code chunk number 19: BaseSpaceR.Rnw:428-429
###################################################
Genomes(g)


###################################################
### code chunk number 20: BaseSpaceR.Rnw:442-444
###################################################
r <- listRuns(aAuth)
r


###################################################
### code chunk number 21: BaseSpaceR.Rnw:450-451
###################################################
listRuns(aAuth, Statuses = "Failed") # no failed runs in our case


###################################################
### code chunk number 22: BaseSpaceR.Rnw:457-459
###################################################
myRun <- Runs(r[1], simplify = TRUE)
myRun


###################################################
### code chunk number 23: BaseSpaceR.Rnw:466-468
###################################################
f <- listFiles(myRun)
Name(f)


###################################################
### code chunk number 24: BaseSpaceR.Rnw:473-474
###################################################
listFiles(myRun, Limit = 2, Extensions = ".bcl")


###################################################
### code chunk number 25: BaseSpaceR.Rnw:488-489
###################################################
Projects(listProjects(aAuth, Limit = 1), simplify = TRUE)


###################################################
### code chunk number 26: BaseSpaceR.Rnw:495-497
###################################################
myNewProj <- createProject(aAuth, name = "My New Project")
myNewProj


###################################################
### code chunk number 27: BaseSpaceR.Rnw:526-528
###################################################
reseq <- listAppResults(aAuth, projectId = 21383369, Limit = 1)
AppResults(reseq)


###################################################
### code chunk number 28: BaseSpaceR.Rnw:537-538 (eval = FALSE)
###################################################
## system.file("doc", "BaseSpaceR-QscoreApp.pdf", package = "BaseSpaceR")


###################################################
### code chunk number 29: BaseSpaceR.Rnw:558-561
###################################################
f <- listFiles(AppResults(reseq))
TotalCount(f)
Name(f)


###################################################
### code chunk number 30: BaseSpaceR.Rnw:567-568
###################################################
identical(f, listFiles(aAuth, appResultId = Id(reseq)))


###################################################
### code chunk number 31: BaseSpaceR.Rnw:577-579
###################################################
f <- listFiles(aAuth, appResultId = Id(reseq), Extensions = ".bam")
Name(f)


###################################################
### code chunk number 32: BaseSpaceR.Rnw:586-587
###################################################
Files(f)


###################################################
### code chunk number 33: BaseSpaceR.Rnw:612-616
###################################################
bamFiles <- listFiles(AppResults(reseq), Extensions = ".bam")
Name(bamFiles)
Id(bamFiles)
bamFiles


###################################################
### code chunk number 34: BaseSpaceR.Rnw:622-623
###################################################
getCoverageStats(aAuth, id = Id(bamFiles), "phix")


###################################################
### code chunk number 35: BaseSpaceR.Rnw:639-643
###################################################
vcfs <- listFiles(AppResults(reseq), Extensions = ".vcf")
Name(vcfs)
Id(vcfs)
vcfs


###################################################
### code chunk number 36: BaseSpaceR.Rnw:649-650 (eval = FALSE)
###################################################
## getVariants(aAuth, Id(vcfs)[1], chrom = "chr", EndPos = 1000000L, Limit = 5)


###################################################
### code chunk number 37: BaseSpaceR.Rnw:694-700
###################################################
myAppClientId <- "aaaaa8acb37a441fa71af5072fd7432b"
myAppClientSecret <- "bbbbb8acb37a441fa71af5072fd7432b"

aAuth <- AppAuth(client_id = myAppClientId,
                 client_secret = myAppClientSecret,
                 scope = "create global")


###################################################
### code chunk number 38: BaseSpaceR.Rnw:734-739
###################################################
aAuth <- AppAuth(client_id = myAppClientId,
                 client_secret = myAppClientSecret,
                 scope = "read global", 
                 doOAuth = FALSE) 
aAuth


###################################################
### code chunk number 39: BaseSpaceR.Rnw:748-750
###################################################
res <- initializeAuth(aAuth, scope = character())
res


###################################################
### code chunk number 40: BaseSpaceR.Rnw:765-767 (eval = FALSE)
###################################################
## requestAccessToken(aAuth)
## hasAccess(aAuth)


###################################################
### code chunk number 41: BaseSpaceR.Rnw:795-797
###################################################
data(aAuth)
app_access_token <- aAuth$access_token


###################################################
### code chunk number 42: BaseSpaceR.Rnw:803-805
###################################################
newAuth <- AppAuth(access_token = app_access_token)
newAuth


###################################################
### code chunk number 43: BaseSpaceR.Rnw:818-822
###################################################
newAuth <- AppAuth(access_token = app_access_token, 
                   client_secret = myAppClientSecret,
                   client_id = myAppClientId)
newAuth


###################################################
### code chunk number 44: BaseSpaceR.Rnw:835-836
###################################################
toLatex(sessionInfo())


