## ----environment, echo=FALSE-----------------------------------------------
suppressPackageStartupMessages(library("synapter"))
suppressPackageStartupMessages(library("synapterdata"))
suppressPackageStartupMessages(library("BiocStyle"))
synobj2RData()

## ----loadsynobj2, eval=FALSE-----------------------------------------------
#  library("synapterdata")
#  synobj2RData()

## ----create-synobj2-file, echo=FALSE, comment=NA---------------------------
cat(readLines(system.file(file.path("scripts", "create_synobj2.R"),
                          package="synapterdata"), n=13), sep="\n")

## ----create_synobj2--------------------------------------------------------
synobj2 <- synergise1(object=synobj2,
                      outputdir=tempdir())

## ----filterfragmentsplot, fig.cap="Cumulative Number of Fragments"---------
plotCumulativeNumberOfFragments(synobj2,
                                what = "fragments.ident")
plotCumulativeNumberOfFragments(synobj2,
                                what = "spectra.quant")

## ----filterfragments-------------------------------------------------------
filterFragments(synobj2,
                what = "fragments.ident",
                minIntensity = 70)
filterFragments(synobj2,
                what = "spectra.quant",
                minIntensity = 70)

## ----fm--------------------------------------------------------------------
setFragmentMatchingPpmTolerance(synobj2, 25)
fragmentMatching(synobj2)

## ----plotfm22, fig.cap="Fragment matching for cases with 28 common fragments. The identification data are shown on the top (blue) and the quantitation data are on the bottom (red). Common peaks are displayed in darker colours and highlighted by full points."----
plotFragmentMatching(synobj2,
                     key = 28,
                     column = "FragmentMatching")

## ----plotfmseq, fig.cap="Fragment matching for peptide *TALIDGLAQ*."-------
plotFragmentMatching(synobj2,
                     key = "TALIDGLAQR",
                     column = "peptide.seq")

## ---- plotfmid, fig.cap="Fragment matching precursor with *leID* identifier 12589."----
plotFragmentMatching(synobj2,
                     key = 12589,
                     column = "precursor.leID.ident")

## ----plotfmperformance, fig.cap="Number of true/false match peptides for different peak matching thresholds and difference in number of peaks between the first and second (in terms of number of common peaks) possible matches. The former metric is used to filter out possible false positive unique matches while the second is used to filter multiple matches. Empty circles indicate zero peptides."----
m <- plotFragmentMatchingPerformance(synobj2)

## ----confusionmatrixunique, results="asis", echo=FALSE---------------------
knitr::kable(m$unique[1:15,], row.names=FALSE,
             caption="Number of true positives, false negatives, false positives, false negatives and false discovery rate for a given number of common peaks.")

## ----confusionmatrixnonunqiue, results="asis", echo=FALSE------------------
knitr::kable(m$nonunique[1:15,], row.names=FALSE,
             caption="Number of true positives, false negatives, false positives, false negatives and false discovery rate for a given difference in number of common peaks between the higest and second highest multiply matching EMRTs in terms of number of common peptides.")

## ----filerunique-----------------------------------------------------------
performance(synobj2)
getEMRTtable(synobj2)
filterUniqueMatches(synobj2, minNumber = 1)
performance(synobj2)
getEMRTtable(synobj2)

## ----filernonunique, echo=-1-----------------------------------------------
oldEMRTtable <- getEMRTtable(synobj2)
performance(synobj2)
getEMRTtable(synobj2)
filterNonUniqueMatches(synobj2, minDelta = 2)
performance(synobj2)
getEMRTtable(synobj2)

## ----export, eval=FALSE----------------------------------------------------
#  writeMatchedEMRTs(synobj2, file = "MatchedEMRTs.csv")

## ----sessioninfo-----------------------------------------------------------
sessionInfo()

