### R code from vignette source 'methylationAnalysis.Rnw'

###################################################
### code chunk number 1: <style-Sweave
###################################################
BiocStyle::latex()


###################################################
### code chunk number 2: methylationAnalysis.Rnw:28-29
###################################################
  library(segmentSeq)


###################################################
### code chunk number 3: methylationAnalysis.Rnw:34-41
###################################################
if(require("parallel")) 
{
    numCores <- min(8, detectCores())
    cl <- makeCluster(numCores)
} else {
    cl <- NULL
}


###################################################
### code chunk number 4: methylationAnalysis.Rnw:44-45 (eval = FALSE)
###################################################
## cl <- NULL


###################################################
### code chunk number 5: methylationAnalysis.Rnw:50-59
###################################################
datadir <- system.file("extdata", package = "segmentSeq")
files <- c("short_18B_C24_C24_trim.fastq_CG_methCalls.gz",
"short_Sample_17A_trimmed.fastq_CG_methCalls.gz",
"short_13_C24_col_trim.fastq_CG_methCalls.gz",
"short_Sample_28_trimmed.fastq_CG_methCalls.gz")

mD <- readMeths(files = files, dir = datadir,
libnames = c("A1", "A2", "B1", "B2"), replicates = c("A","A","B","B"),
nonconversion = c(0.004777, 0.005903, 0.016514, 0.006134))


###################################################
### code chunk number 6: methDist
###################################################
par(mfrow = c(2,1))
dists <- plotMethDistribution(mD, main = "Distributions of methylation", chr = "Chr1")
plotMethDistribution(mD, 
                     subtract = rowMeans(sapply(dists, function(x) x[,2])), 
                     main = "Differences between distributions", chr = "Chr1")


###################################################
### code chunk number 7: figMethDist
###################################################
par(mfrow = c(2,1))
dists <- plotMethDistribution(mD, main = "Distributions of methylation", chr = "Chr1")
plotMethDistribution(mD, 
                     subtract = rowMeans(sapply(dists, function(x) x[,2])), 
                     main = "Differences between distributions", chr = "Chr1")


###################################################
### code chunk number 8: methylationAnalysis.Rnw:87-88
###################################################
sD <- processAD(mD, cl = cl)


###################################################
### code chunk number 9: methylationAnalysis.Rnw:91-92
###################################################
if(nrow(sD) != 215191) stop("sD object is the wrong size (should have 215191 rows). Failure.")


###################################################
### code chunk number 10: methylationAnalysis.Rnw:101-104
###################################################
thresh <- thresholdFinder("beta", mD, cl = cl, bootstrap = 1)
hS <- heuristicSeg(sD = sD, aD = mD, prop = thresh, cl = cl, gap = 100, getLikes = FALSE)
hS


###################################################
### code chunk number 11: methylationAnalysis.Rnw:107-108
###################################################
if(nrow(hS) != 4298) stop("hS object is the wrong size (should have 4298 rows). Failure.")


###################################################
### code chunk number 12: methylationAnalysis.Rnw:114-115
###################################################
hS <- mergeMethSegs(hS, mD, gap = 5000, cl = cl)


###################################################
### code chunk number 13: methylationAnalysis.Rnw:120-121 (eval = FALSE)
###################################################
## hSL <- lociLikelihoods(hS, mD, cl = cl)


###################################################
### code chunk number 14: methylationAnalysis.Rnw:124-125
###################################################
data(hSL)


###################################################
### code chunk number 15: plotMeth
###################################################
plotMeth(mD, hSL, chr = "Chr1", limits = c(1, 50000), cap = 10)


###################################################
### code chunk number 16: figplotMeth
###################################################
plotMeth(mD, hSL, chr = "Chr1", limits = c(1, 50000), cap = 10)


###################################################
### code chunk number 17: methylationAnalysis.Rnw:164-165
###################################################
groups(hSL) <- list(NDE = c(1,1,1,1), DE = c("A", "A", "B", "B"))


###################################################
### code chunk number 18: methylationAnalysis.Rnw:169-170
###################################################
hSL <- methObservables(hSL)


###################################################
### code chunk number 19: methylationAnalysis.Rnw:174-175
###################################################
densityFunction(hSL) <- bbNCDist


###################################################
### code chunk number 20: methylationAnalysis.Rnw:179-180
###################################################
hSL <- getPriors(hSL, cl = cl)


###################################################
### code chunk number 21: methylationAnalysis.Rnw:185-186
###################################################
hSL <- getLikelihoods(hSL, cl = cl)


###################################################
### code chunk number 22: methylationAnalysis.Rnw:191-192
###################################################
topCounts(hSL, "DE")


###################################################
### code chunk number 23: <stopCluster
###################################################
if(!is.null(cl))
    stopCluster(cl)


###################################################
### code chunk number 24: methylationAnalysis.Rnw:205-206
###################################################
sessionInfo()


