/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public class PklFile {
    private int precurorCharge;
    private double precursorMz;
    private double precursorIntensity;
    private double[] mzValues;
    private double[] intensityValues;
    private String fileName;
    private String spectrumFileId;

    public PklFile(File pklFile) throws IOException {
        if (pklFile.isDirectory()) {
            throw new IOException("File is a directory!");
        }
        if (!pklFile.getAbsolutePath().toLowerCase().endsWith(".pkl")) {
            throw new IOException("File is not a PKL file!");
        }
        FileReader f = new FileReader(pklFile);
        BufferedReader b = new BufferedReader(f);
        this.fileName = pklFile.getName();
        this.spectrumFileId = pklFile.getName().substring(0, pklFile.getName().length() - 4);
        String precursorLine = b.readLine();
        String[] precursorDetails = precursorLine.split("\t");
        if (precursorDetails.length != 3) {
            throw new IOException("File is not a PKL file - incorrect number of precursor paramaters!");
        }
        this.precursorMz = new Double(precursorDetails[0]);
        this.precursorIntensity = new Double(precursorDetails[1]);
        this.precurorCharge = new Integer(precursorDetails[2]);
        HashMap<Double, Double> peaks = new HashMap<Double, Double>();
        String peakLine = b.readLine();
        while (peakLine != null) {
            String[] peakDetails = peakLine.split("\t");
            if (peakDetails.length != 2) {
                throw new IOException("File is not a PKL file - incorrect number of peak paramaters!");
            }
            peaks.put(new Double(peakDetails[0]), new Double(peakDetails[1]));
            peakLine = b.readLine();
        }
        TreeSet treeSet = new TreeSet();
        treeSet.clear();
        treeSet.addAll(peaks.keySet());
        Iterator treeSetIterator = treeSet.iterator();
        this.mzValues = new double[peaks.size()];
        this.intensityValues = new double[peaks.size()];
        int peakCounter = 0;
        while (treeSetIterator.hasNext()) {
            Double tempMz = (Double)treeSetIterator.next();
            this.mzValues[peakCounter] = tempMz;
            this.intensityValues[peakCounter++] = (Double)peaks.get(tempMz);
        }
        b.close();
        f.close();
    }

    public int getPrecurorCharge() {
        return this.precurorCharge;
    }

    public void setPrecurorCharge(int precurorCharge) {
        this.precurorCharge = precurorCharge;
    }

    public double getPrecursorMz() {
        return this.precursorMz;
    }

    public void setPrecursorMz(double precursorMz) {
        this.precursorMz = precursorMz;
    }

    public double getPrecursorIntensity() {
        return this.precursorIntensity;
    }

    public void setPrecursorIntensity(double precursorIntensity) {
        this.precursorIntensity = precursorIntensity;
    }

    public double[] getMzValues() {
        return this.mzValues;
    }

    public void setMzValues(double[] mzValues) {
        this.mzValues = mzValues;
    }

    public double[] getIntensityValues() {
        return this.intensityValues;
    }

    public void setIntensityValues(double[] intensityValues) {
        this.intensityValues = intensityValues;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getSpectrumFileId() {
        return this.spectrumFileId;
    }

    public void setSpectrumFileId(String spectrumFileId) {
        this.spectrumFileId = spectrumFileId;
    }
}

