## ----setup, include=FALSE--------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ----eval=FALSE------------------------------------------------------------
#  source( "http://bioconductor.org/biocLite.R" )
#  biocLite( "psygenet2r" )

## ----load_library, messages=FALSE------------------------------------------
library( psygenet2r )

## ----dataGenet1, echo=FALSE------------------------------------------------
t1 <- psygenetGene( gene = 4852, 
                    database = "ALL")

## ----dataGenet2------------------------------------------------------------
t1
class( t1 )

## ----search_gene_1---------------------------------------------------------
t1 <- psygenetGene( gene = 4852, 
                    database = "ALL")
t1

## ----search_gene_2---------------------------------------------------------
t2 <- psygenetGene( gene = "NPY", 
                    database = "ALL" )
t2

## ----searcg_gene_class-----------------------------------------------------
class( t1 )
class( t2 )

## ----plot_disease, fig.width=8, fig.height=8-------------------------------
plot( t1, type = "individual disease" )

## ----plot_psychiatric, fig.width=8, fig.height=8---------------------------
plot( t1, type = "disease class" )

## ----search_multiple_genes-------------------------------------------------
genesOfInterest <- c( "COMT", "CLOCK", "DRD3", "GNB3", "HTR1A",
                      "MAOA", "HTR2A","HTR2C", "HTR6", "SLC6A4", 
                      "ACE",  "BDNF", "DRD4", "HTR1B", "HTR2B",
                      "HTR2C", "MTHFR", "SLC6A3", "TPH1", "SLC6A2", 
                      "GABRA3"
)

## ----search_multiple_search------------------------------------------------
m1 <- psygenetGene(
    gene     = genesOfInterest, 
    database = "ALL",
    verbose  = TRUE
)

## ----show_multiple---------------------------------------------------------
m1

## ----plot_psychiatric1a,  fig.height=8, fig.width=8------------------------
plot( m1 )

## ----plot_psychiatric1b, warning=FALSE,  fig.height=8, fig.width=8---------
plot( m1, type = "disease class" )

## ----heatmap_disease_m,  fig.height=8, fig.width=8-------------------------
plot( m1, type="heatmapGenes" )

## ----plot_psychiatric_heamap, warning = FALSE,  fig.height=8, fig.width=8----
plot( m1, type = "heatmap" )

## ----panther_gene,  fig.height=8, fig.width=8------------------------------
genesOfInterest <- unique( genesOfInterest )
pantherGraphic( genesOfInterest, "ALL" )

## ----plot_diseaseBarplot,  fig.height=8, fig.width=8-----------------------
geneAttrPlot( m1, type = "category" )

## ----plot_diseaseBarplotGene,  fig.height=8, fig.width=8-------------------
geneAttrPlot( m1, type = "gene" )

## ----plot_pieChart, fig.width=8, fig.height=8------------------------------
geneAttrPlot( m1, type = "pie" )

## ----barplotIP, fig.width=8, fig.height=8----------------------------------
geneAttrPlot( m1, type = "index" )

## ----enrichment------------------------------------------------------------
tbl <- enrichedPD( genesOfInterest, database = "ALL")
tbl

## ----topAnat, eval=FALSE---------------------------------------------------
#  tpAnat <- topAnatEnrichment( genesOfInterest, cutOff = 1 )

## ----load_topAnat, echo=FALSE----------------------------------------------
load( system.file( "extdata", "topAnat.RData", package="psygenet2r" ) )

## ----show_topAnat----------------------------------------------------------
head( tpAnat )

## ----gda_sentenceGene------------------------------------------------------
genesOfInterest
sss <- psygenetGeneSentences( geneList = genesOfInterest,
                             database = "ALL")
sss

geneSentences <- extractSentences( object = sss,
                                   disorder = "alcohol abuse")
dim( geneSentences )

## ----getUMLS---------------------------------------------------------------
getUMLs( "depressive", database = "ALL" )

## ----search_diseaseId_1----------------------------------------------------
d1 <- psygenetDisease( disease  = "umls:C1839839", 
                       database = "ALL", 
                       score    = c('>', 0.5 ) )
d1

## ----search_diseaseName_1--------------------------------------------------
d2 <- psygenetDisease( disease = "major affective disorder 2", 
                       database = "ALL",
                       score    = c('>', 0.5 ) )
d2

## ----search_gene_class-----------------------------------------------------
class( d1 )
class( d2 )

## ----plot_visualizing_single_disease_search, fig.width=8, fig.height=8-----
plot ( d1 )

## ----diseaseList-----------------------------------------------------------
diseasesOfInterest <- c( "chronic schizophrenia","alcohol use disorder" )

## ----search_diseases_1-----------------------------------------------------
tt <- psygenetDisease( disease  = diseasesOfInterest,
                       database = "ALL" )
tt

## ----search_diseases_2-----------------------------------------------------
dm <- psygenetDisease( disease  = c( "umls:C0221765", "umls:C0001956" ), 
                       database = "ALL" )
dm

## ----search_diseases_3-----------------------------------------------------
tm <- psygenetDisease( disease  = c( "chronic schizophrenia","umls:C0001956" ), 
                       database = "ALL" )
tm

## ----search_gene_class_2---------------------------------------------------
class( tt )
class( dm )
class( tm )

## ----plot_disease_tm-------------------------------------------------------
plot( tm )

## ----heatmap_disease_tm, warning = FALSE,  fig.wide = TRUE-----------------
plot( tm, type = "heatmap" )

## ----barplot_visualizing_single_disease_search, fig.width=8, fig.height=8----
plot( d1, name = "major affective disorder 2", type = "barplot" )

## ----barplot_visualizing_single_gene_search, fig.width=8, fig.height=8-----
plot( t1, name = "NPY", type = "barplot" )

## ----jaccardObjectEx1, echo=FALSE, warning=FALSE, message=FALSE------------
genes_interest <- c("SLC6A4", "DRD2", "HTR1B", "PLP1", "TH", "DRD3")
ji1 <- jaccardEstimation(genes_interest, database = "ALL")

## ----jaccardObjectEx2------------------------------------------------------
ji1
class( ji1 )

## ----ji_1, warnings=FALSE--------------------------------------------------
genes_interest <- c("SLC6A4", "DRD2", "HTR1B", "PLP1", "TH", "DRD3")
ji1 <- jaccardEstimation(genes_interest, database = "ALL")

## ----ji_2, warnings=FALSE--------------------------------------------------
disease_interest <- 
  c("delirium", "bipolar i disorder", "severe depression", "cocaine dependence")
ji2 <- jaccardEstimation(genes_interest, disease_interest, database = "ALL")

## ----ji_3, warnings=FALSE--------------------------------------------------
ji3 <- jaccardEstimation(disease_interest, database = "ALL")

## ----ji1_extract-----------------------------------------------------------
head(extract(ji1))
tail(extract(ji1))

## ----ji1_plot, fig.width=8, fig.height=8-----------------------------------
plot(ji1, cutOff = 0.1)

## ----ji2_plot, fig.width=8, fig.height=8-----------------------------------
plot(ji2)

## ----ji3_plot, fig.width=8, fig.height=8-----------------------------------
plot(ji3)

