/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.gsea;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.AbstractTraverser;
import org.biopax.paxtools.controller.Fetcher;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.controller.Traverser;
import org.biopax.paxtools.converter.LevelUpgrader;
import org.biopax.paxtools.io.gsea.GSEAEntry;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.Provenance;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.util.Filter;

public class GSEAConverter {
    private static final Log LOG = LogFactory.getLog(GSEAConverter.class);
    private final String database;
    private final boolean crossSpeciesCheckEnabled;
    private final boolean skipSubPathways;
    private final Set<Provenance> skipSubPathwaysOf;

    public GSEAConverter() {
        this("", true);
    }

    public GSEAConverter(String database, boolean crossSpeciesCheckEnabled) {
        this(database, crossSpeciesCheckEnabled, false);
    }

    public GSEAConverter(String database, boolean crossSpeciesCheckEnabled, boolean skipSubPathways) {
        this.database = database;
        this.crossSpeciesCheckEnabled = crossSpeciesCheckEnabled;
        this.skipSubPathways = skipSubPathways;
        this.skipSubPathwaysOf = Collections.emptySet();
    }

    public GSEAConverter(String database, boolean crossSpeciesCheckEnabled, Set<Provenance> skipSubPathwaysOf) {
        this.database = database;
        this.crossSpeciesCheckEnabled = crossSpeciesCheckEnabled;
        if (skipSubPathwaysOf == null) {
            skipSubPathwaysOf = Collections.emptySet();
        }
        this.skipSubPathwaysOf = skipSubPathwaysOf;
        this.skipSubPathways = false;
    }

    public void writeToGSEA(Model model, OutputStream out) throws IOException {
        Collection<GSEAEntry> entries = this.convert(model);
        if (entries.size() > 0) {
            OutputStreamWriter writer = new OutputStreamWriter(out);
            for (GSEAEntry entry : entries) {
                writer.write(entry.toString() + "\n");
            }
            ((Writer)writer).flush();
        }
    }

    public Collection<GSEAEntry> convert(Model model) {
        Map<String, Set<ProteinReference>> orgToPrsMap;
        final TreeSet<GSEAEntry> toReturn = new TreeSet<GSEAEntry>(new Comparator<GSEAEntry>(){

            @Override
            public int compare(GSEAEntry o1, GSEAEntry o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        Model l3Model = model.getLevel() == BioPAXLevel.L1 || model.getLevel() == BioPAXLevel.L2 ? new LevelUpgrader().filter(model) : model;
        final Set<ProteinReference> prs = Collections.synchronizedSet(new HashSet<ProteinReference>(l3Model.getObjects(ProteinReference.class)));
        ExecutorService exe = Executors.newFixedThreadPool(10);
        Set<Pathway> pathways = l3Model.getObjects(Pathway.class);
        for (Pathway pathway2 : pathways) {
            String name;
            String string = name = pathway2.getDisplayName() == null ? pathway2.getStandardName() : pathway2.getDisplayName();
            if (name == null || name.isEmpty()) {
                name = pathway2.getRDFId();
            }
            final Pathway currentPathway = pathway2;
            final String currentPathwayName = name;
            final boolean ignoreSubPathways = this.skipSubPathways || !this.skipSubPathwaysOf.isEmpty() && this.shareSomeObjects(currentPathway.getDataSource(), this.skipSubPathwaysOf);
            exe.submit(new Runnable(){

                @Override
                public void run() {
                    LOG.info("Begin converting " + currentPathwayName + " pathway, uri=" + currentPathway.getRDFId());
                    final HashSet pathwayProteinRefs = new HashSet();
                    AbstractTraverser traverser = new AbstractTraverser(SimpleEditorMap.L3, new Filter[]{Fetcher.nextStepFilter, Fetcher.objectPropertiesOnlyFilter}){

                        protected void visit(Object range, BioPAXElement domain, Model model, PropertyEditor editor) {
                            BioPAXElement bpe = (BioPAXElement)range;
                            if (bpe instanceof ProteinReference) {
                                pathwayProteinRefs.add((ProteinReference)bpe);
                            }
                            if (bpe instanceof Pathway) {
                                Pathway subPathway = (Pathway)bpe;
                                if (ignoreSubPathways) {
                                    LOG.info("Skipping sub-pathway: " + subPathway.getRDFId());
                                } else {
                                    this.traverse(subPathway, null);
                                }
                            } else {
                                this.traverse(bpe, null);
                            }
                        }
                    };
                    ((Traverser)traverser).traverse(currentPathway, null);
                    LOG.info("- fetched PRs: " + pathwayProteinRefs.size());
                    if (!pathwayProteinRefs.isEmpty()) {
                        LOG.info("- grouping the PRs by organism...");
                        Map orgToPrsMap = GSEAConverter.this.organismToProteinRefsMap(pathwayProteinRefs);
                        String dataSource2 = GSEAConverter.this.getDataSource(currentPathway.getDataSource());
                        LOG.info("- creating GSEA/GMT entries...");
                        Collection entries = GSEAConverter.this.createGseaEntries(currentPathwayName, dataSource2, orgToPrsMap);
                        if (!entries.isEmpty()) {
                            toReturn.addAll(entries);
                        }
                        prs.removeAll(pathwayProteinRefs);
                        LOG.info("- collected " + entries.size() + "entries.");
                    }
                }
            });
        }
        exe.shutdown();
        try {
            exe.awaitTermination(48L, TimeUnit.HOURS);
        }
        catch (InterruptedException e2) {
            throw new RuntimeException("Interrupted unexpectedly!");
        }
        LOG.info("Creating entries for the rest fo (unused) PRs...");
        if (!prs.isEmpty() && !(orgToPrsMap = this.organismToProteinRefsMap(prs)).isEmpty()) {
            toReturn.addAll(this.createGseaEntries("Not pathway", this.getDataSource(l3Model.getObjects(Provenance.class)), orgToPrsMap));
        }
        return toReturn;
    }

    private Collection<GSEAEntry> createGseaEntries(final String name, final String dataSource2, final Map<String, Set<ProteinReference>> orgToPrsMap) {
        final List<GSEAEntry> toReturn = Collections.synchronizedList(new ArrayList());
        ExecutorService exe = Executors.newFixedThreadPool(5);
        for (final String org : orgToPrsMap.keySet()) {
            if (orgToPrsMap.get(org).size() <= 0) continue;
            exe.submit(new Runnable(){

                @Override
                public void run() {
                    LOG.info("adding " + GSEAConverter.this.database + " IDs of " + org + " proteins (PRs) from '" + name + "', " + dataSource2 + " pathway...");
                    GSEAEntry gseaEntry = new GSEAEntry(name, org, GSEAConverter.this.database, "datasource: " + dataSource2);
                    GSEAConverter.this.processProteinReferences((Set)orgToPrsMap.get(org), gseaEntry);
                    toReturn.add(gseaEntry);
                }
            });
        }
        exe.shutdown();
        try {
            exe.awaitTermination(4L, TimeUnit.HOURS);
        }
        catch (InterruptedException e2) {
            throw new RuntimeException("Interrupted unexpectedly!");
        }
        return toReturn;
    }

    private Map<String, Set<ProteinReference>> organismToProteinRefsMap(Set<ProteinReference> proteinRefs) {
        HashMap<String, Set<ProteinReference>> map = new HashMap<String, Set<ProteinReference>>();
        if (proteinRefs.isEmpty()) {
            throw new IllegalArgumentException("Empty set");
        }
        if (this.crossSpeciesCheckEnabled) {
            for (ProteinReference r : proteinRefs) {
                String key = this.getOrganismKey(r.getOrganism());
                HashSet<ProteinReference> prs = (HashSet<ProteinReference>)map.get(key);
                if (prs == null) {
                    prs = new HashSet<ProteinReference>();
                    map.put(key, prs);
                }
                prs.add(r);
            }
        } else {
            map.put("", proteinRefs);
        }
        return map;
    }

    void processProteinReferences(Set<ProteinReference> prs, GSEAEntry targetEntry) {
        for (ProteinReference aProteinRef : prs) {
            if (this.crossSpeciesCheckEnabled && !targetEntry.taxID().equals(this.getOrganismKey(aProteinRef.getOrganism()))) continue;
            if (this.database != null && !this.database.isEmpty()) {
                String lowercaseDb = this.database.toLowerCase();
                String lowcaseUri = aProteinRef.getRDFId().toLowerCase();
                if (lowcaseUri.startsWith("http://identifiers.org/") && lowcaseUri.contains(lowercaseDb)) {
                    String accession = aProteinRef.getRDFId();
                    accession = accession.substring(accession.lastIndexOf("/") + 1);
                    targetEntry.getIdentifiers().add(accession);
                    continue;
                }
                TreeSet<Xref> orderedXrefs = new TreeSet<Xref>(new Comparator<Xref>(){

                    @Override
                    public int compare(Xref o1, Xref o2) {
                        return o1.toString().compareTo(o2.toString());
                    }
                });
                orderedXrefs.addAll(aProteinRef.getXref());
                for (Xref aXref : orderedXrefs) {
                    if (aXref.getId() == null || aXref.getDb() == null || !aXref.getDb().toLowerCase().startsWith(lowercaseDb) && !aXref.getId().toLowerCase().startsWith(lowercaseDb + ":") && !aXref.getId().toLowerCase().startsWith(lowercaseDb + "_")) continue;
                    targetEntry.getIdentifiers().add(aXref.getId());
                }
                continue;
            }
            targetEntry.getIdentifiers().add(aProteinRef.getRDFId());
        }
    }

    private String getDataSource(Set<Provenance> provenances) {
        if (provenances.isEmpty()) {
            return "N/A";
        }
        TreeSet<String> dsNames = new TreeSet<String>();
        for (Provenance provenance : provenances) {
            String name = provenance.getDisplayName();
            if (name == null) {
                name = provenance.getStandardName();
            }
            if (name == null && !provenance.getName().isEmpty()) {
                name = provenance.getName().iterator().next();
            }
            if (name == null || name.length() <= 0) continue;
            dsNames.add(name.toLowerCase());
        }
        return StringUtils.join(dsNames, ";");
    }

    private String getOrganismKey(BioSource org) {
        String key = "";
        if (org != null) {
            Set<Xref> xrefs = org.getXref();
            if (!xrefs.isEmpty()) {
                for (Xref xref2 : xrefs) {
                    if (!(xref2 instanceof UnificationXref) || !xref2.getDb().equalsIgnoreCase("taxonomy")) continue;
                    if (key.isEmpty()) {
                        key = xref2.getId();
                        continue;
                    }
                    LOG.warn("BioSource " + org + " has multiple taxonomy ID unification xrefs; " + "I use " + key + " and ignore other, but the conversion might go wrong...");
                }
            }
            if (key.isEmpty()) {
                if (org.getStandardName() != null) {
                    key = org.getStandardName().toLowerCase();
                } else if (org.getDisplayName() != null) {
                    key = org.getDisplayName().toLowerCase();
                } else if (!org.getName().isEmpty()) {
                    key = org.getName().iterator().next().toLowerCase();
                }
            }
        }
        return key;
    }

    private boolean shareSomeObjects(Set<?> setA, Set<?> setB) {
        return !setA.isEmpty() && !setB.isEmpty() ? !CollectionUtils.intersection(setA, setB).isEmpty() : false;
    }
}

