/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingProject;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterConvert;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.PrintUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.Collection;
import java.util.List;

public class QueryIterProject
extends QueryIterConvert {
    List projectionVars;

    public QueryIterProject(QueryIterator input, List vars, ExecutionContext qCxt) {
        super(input, QueryIterProject.project(vars, qCxt), qCxt);
        this.projectionVars = vars;
    }

    static QueryIterConvert.Converter project(List vars, ExecutionContext qCxt) {
        return new Projection(vars, qCxt);
    }

    public List getProjectionVars() {
        return this.projectionVars;
    }

    protected void details(IndentedWriter out, SerializationContext sCxt) {
        out.print(Utils.className(this));
        out.print(" ");
        PrintUtils.printList(out, (Collection)this.projectionVars);
    }

    static class Projection
    implements QueryIterConvert.Converter {
        List projectionVars;

        Projection(List vars, ExecutionContext qCxt) {
            this.projectionVars = vars;
        }

        public Binding convert(Binding bind) {
            return new BindingProject(this.projectionVars, bind);
        }
    }
}

