/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpPrefixesUsed;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.sse.writers.WriterOp;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import java.io.OutputStream;

class OpWriter {
    private static final int NL = 1;
    private static final int NoNL = -1;

    OpWriter() {
    }

    public static void out(Op op) {
        OpWriter.out(System.out, op);
    }

    public static void out(Op op, PrefixMapping pMap) {
        OpWriter.out((OutputStream)System.out, op, pMap);
    }

    public static void out(Op op, Prologue prologue) {
        OpWriter.out((OutputStream)System.out, op, prologue);
    }

    public static void out(OutputStream out, Op op) {
        OpWriter.out(out, op, (PrefixMapping)null);
    }

    public static void out(OutputStream out, Op op, PrefixMapping pMap) {
        OpWriter.out(new IndentedWriter(out), op, pMap);
    }

    public static void out(OutputStream out, Op op, Prologue prologue) {
        OpWriter.out(new IndentedWriter(out), op, prologue);
    }

    public static void out(IndentedWriter iWriter, Op op) {
        OpWriter.out(iWriter, op, (PrefixMapping)null);
    }

    public static void out(IndentedWriter iWriter, Op op, PrefixMapping pMap) {
        if (pMap == null) {
            pMap = OpPrefixesUsed.used(op, ARQConstants.getGlobalPrefixMap());
        }
        SerializationContext sCxt = new SerializationContext(pMap);
        OpWriter.out(iWriter, op, sCxt);
    }

    public static void out(IndentedWriter iWriter, Op op, Prologue prologue) {
        SerializationContext sCxt = new SerializationContext(prologue);
        OpWriter.out(iWriter, op, sCxt);
    }

    public static void out(OutputStream out, Op op, SerializationContext sCxt) {
        OpWriter.out(new IndentedWriter(out), op, sCxt);
    }

    public static void out(IndentedWriter iWriter, Op op, SerializationContext sCxt) {
        WriterOp.output(iWriter, op, sCxt);
    }
}

