/*
 * Decompiled with CFR 0.152.
 */
package rationals.algebra;

import java.util.Iterator;
import java.util.Set;
import rationals.Rational;
import rationals.State;
import rationals.Transition;
import rationals.algebra.Matrix;
import rationals.expr.Letter;
import rationals.expr.Plus;
import rationals.expr.RationalExpr;

public class RationalMatrix {
    private Matrix init;
    private Matrix fini;
    private Matrix transitions;

    public Matrix getFini() {
        return this.fini;
    }

    public void setFini(Matrix fini) {
        this.fini = fini;
    }

    public Matrix getInit() {
        return this.init;
    }

    public void setInit(Matrix init) {
        this.init = init;
    }

    public Matrix getTransitions() {
        return this.transitions;
    }

    public void setTransitions(Matrix transitions) {
        this.transitions = transitions;
    }

    public RationalMatrix(Rational rat) {
        Set st = rat.states();
        int n = st.size();
        this.init = Matrix.zero(1, n, RationalExpr.zero);
        this.fini = Matrix.zero(n, 1, RationalExpr.zero);
        this.transitions = Matrix.zero(n, n, RationalExpr.zero);
        State[] sta = rat.states().toArray(new State[n]);
        for (int i = 0; i < sta.length; ++i) {
            this.init.matrix[0][i] = sta[i].isInitial() ? Letter.epsilon : RationalExpr.zero;
            this.fini.matrix[i][0] = sta[i].isTerminal() ? Letter.epsilon : RationalExpr.zero;
            for (int j = 0; j < n; ++j) {
                Set trs = rat.deltaFrom(sta[i], sta[j]);
                RationalExpr re = null;
                Iterator it = trs.iterator();
                while (it.hasNext()) {
                    Letter l;
                    Transition tr = (Transition)it.next();
                    Object o = tr.label();
                    Letter letter = l = o == null ? Letter.epsilon : new Letter(o);
                    if (re == null) {
                        re = l;
                        continue;
                    }
                    re = new Plus(re, l);
                }
                this.transitions.matrix[i][j] = re == null ? RationalExpr.zero : re;
            }
        }
    }

    public Matrix nwords(int n) {
        Matrix res = this.transitions.power(n, Matrix.zero(this.transitions.getLine(), this.transitions.getLine(), RationalExpr.zero));
        Matrix in = (Matrix)this.init.mult(res);
        return (Matrix)in.mult(this.fini);
    }

    public String toString() {
        return this.init.toString() + '\n' + this.transitions.toString() + '\n' + this.fini.toString();
    }
}

