/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ontocat;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.ebi.ontocat.OntologyService;
import uk.ac.ebi.ontocat.OntologyServiceException;
import uk.ac.ebi.ontocat.OntologyTerm;
import uk.ac.ebi.ontocat.file.ReasonedFileOntologyService;
import uk.ac.ebi.ontocat.special.AbstractOntologyServiceTest;

public class ReasonedOBOTest
extends AbstractOntologyServiceTest {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        os = new ReasonedFileOntologyService(new URI("http://www.geneontology.org/GO_slims/goslim_generic.obo"), "GOslim");
        ONTOLOGY_ACCESSION = "GOslim";
        TERM_ACCESSION = "GO_0005622";
    }

    @Test
    public final void testGetAllTerms() throws OntologyServiceException {
        ReasonedOBOTest.printCurrentTest();
        Set<OntologyTerm> set = os.getAllTerms(ONTOLOGY_ACCESSION);
        Assert.assertNotSame((String)"Empty set returned!", (Object)0, (Object)set.size());
        ReasonedOBOTest.println(set.size());
    }

    @Test
    public final void testSearchAll() throws OntologyServiceException {
        ReasonedOBOTest.printCurrentTest();
        List<OntologyTerm> list = os.searchAll("gene", new OntologyService.SearchOptions[0]);
        Assert.assertNotSame((String)"Empty list returned!", (Object)0, (Object)list.size());
        for (OntologyTerm ot : list) {
            ReasonedOBOTest.println(ot);
        }
    }

    @Test(expected=AssertionError.class)
    public final void testGetChildren() throws OntologyServiceException {
        super.testGetChildren();
    }

    @Test
    public final void testGetRelations() throws OntologyServiceException {
        ReasonedOBOTest.printCurrentTest();
        Map<String, Set<OntologyTerm>> map = os.getRelations(ONTOLOGY_ACCESSION, TERM_ACCESSION);
        Assert.assertNotSame((String)"Empty map returned!", (Object)0, (Object)map.size());
        Assert.assertFalse((String)"No expected relations returned", (boolean)map.get("has_part").isEmpty());
        for (Map.Entry<String, Set<OntologyTerm>> e : map.entrySet()) {
            System.out.println(e.getKey());
            for (OntologyTerm s : e.getValue()) {
                System.out.println("\t" + s.getAccession() + "\t" + s.getLabel());
            }
        }
    }
}

