#! /usr/bin/perl
#I need to insert also the reformatting ofr MT genome
# perl chrstrloc.pl file.to.be.reformatted
# remember column numbering start from 0
# perl ./shrimpENSEMBL2genominator.hg19.pl s1cs20.mapped
# >@HWI-EAS269B:1:1:1614:601      gi|224589800|ref|NC_000001.10| Homo sapiens chromosome 1, GRCh37 primary reference assembly      -       31208008        31208025        5       22      32      180     18	
my ($mappingFileName) = @ARGV;

open INFILE_MAP, "<$mappingFileName" or die $!;
open OUTFILE_MAP, ">$mappingFileName.bed" or die $!;
#in logos file I get some info needed for quality evaluation of the results the name of the ensembl gene and the description of the alignment and start of alignment in reference seq and start in read
open OUTFILE_LOGOS, ">$mappingFileName.logos" or die $!;
  while (my $line = <INFILE_MAP>){
          if($line =~ /^>/){
             my @myarr = split('\t', $line);
             my @tmparr = split('\|', $myarr[1]);
             $chr = $tmparr[3];
             $chr =~ s/^NC_//;
             my @tmpchr = split('\.', $chr);
             $chr = $tmpchr[0];
            #removing 0s
             while($chr =~ m/^0/)
                {
                $chr =~ s/^0//;
                }
             if ($chr =~ /23/) {
                  $chr = "88"; #
             } 
             elsif ($chr =~ /24/) {
                  $chr = "89"; #
             }
             $strand = $myarr[2];
             if ($strand =~ /\+/) {
                  $strand = "1"; #
             } 
             elsif ($strand =~ /-/) {
                  $strand = "-1"; #
             }
             my $string = join("\t", $chr, $strand, $myarr[3]); #chr, strand (1, -1), start alignment
             my $logos = join("\t", $tmparr[3], $myarr[9], $myarr[3], $myarr[5]);  #gene name, aligning info, start in gene, start in read
             print OUTFILE_MAP $string;
             print OUTFILE_MAP "\n";
             print OUTFILE_LOGOS $logos;
             print OUTFILE_LOGOS "\n";
          }
  }  
close INFILE_MAP;
close OUTFILE_MAP;
