### R code from vignette source 'geneplast.Rnw'

###################################################
### code chunk number 1: style
###################################################
BiocStyle::latex()


###################################################
### code chunk number 2: loadToy
###################################################
library(geneplast)
data(gpdata.gs)


###################################################
### code chunk number 3: newOgp
###################################################
ogp <- gplast.preprocess(cogdata=cogdata, sspids=sspids, cogids=cogids, verbose=FALSE)


###################################################
### code chunk number 4: gplastTest
###################################################
ogp <- gplast(ogp, verbose=FALSE)


###################################################
### code chunk number 5: gplastRes
###################################################
res <- gplast.get(ogp,what="results")
head(res)


###################################################
### code chunk number 6: newOgr
###################################################
ogr <- groot.preprocess(cogdata=cogdata, phyloTree=phyloTree, spid="9606", 
                        cogids=cogids, verbose=FALSE)


###################################################
### code chunk number 7: grootTest
###################################################
set.seed(1)
ogr <- groot(ogr, nPermutations=100, verbose=FALSE)


###################################################
### code chunk number 8: grootRes
###################################################
res <- groot.get(ogr,what="results")
head(res)


###################################################
### code chunk number 9: grootRes
###################################################
groot.plot(ogr,whichOG="NOG40170")


###################################################
### code chunk number 10: grootRes
###################################################
groot.plot(ogr,plot.lcas = TRUE)


###################################################
### code chunk number 11: sessionInfo
###################################################
toLatex(sessionInfo())


