tabItem(tabName = "tcgaSearch",
        fluidRow(
            column(8, bsAlert("tcgasearchmessage"),
                   bsCollapse(id = "collapseTCGA", open = "GDC search results: Summary",
                              bsCollapsePanel("GDC search results: Summary",
                                              htmltools::div(style = "display:inline-block", plotlyOutput("nb.samples", width = 250, height = 250)),
                                              htmltools::div(style = "display:inline-block", plotlyOutput("file.size", width = 250, height = 250)),
                                              htmltools::div(style = "display:inline-block", plotlyOutput("experimental.strategy", width = 250, height = 250)),
                                              htmltools::div(style = "display:inline-block", plotlyOutput("tissue.definition", width = 250, height = 250)),
                                              htmltools::div(style = "display:inline-block", plotlyOutput("data.type", width = 250, height = 250)),
                                              htmltools::div(style = "display:inline-block", plotlyOutput("vital.status", width = 250, height = 250)),
                                              htmltools::div(style = "display:inline-block", plotlyOutput("tumor.stage", width = 250, height = 250)),
                                              htmltools::div(style = "display:inline-block", plotlyOutput("race", width = 250, height = 250)),
                                              htmltools::div(style = "display:inline-block", plotlyOutput("gender", width = 250, height = 250)),
                                              style = "default"),
                              bsCollapsePanel("GDC search results: Results", dataTableOutput('queryresutlstable'), style = "default")
                   )),
            column(4,
                   box(title = "Molecular data search",width = NULL,
                       status = "danger",
                       solidHeader = FALSE, collapsible = TRUE,
                       radioButtons("tcgaDatabase", "Database:",
                                    c("Harmonized database (hg38)" = FALSE,
                                      "Legacy database (hg19)" = TRUE)),
                       selectizeInput('tcgaProjectFilter',
                                      'Project filter',
                                      NULL,
                                      multiple = FALSE),
                       selectizeInput('tcgaDataCategoryFilter',
                                      'Data Category filter',
                                      NULL,
                                      multiple = FALSE),
                       selectizeInput('tcgaDataTypeFilter',
                                      'Data Type filter',
                                      NULL,
                                      multiple = FALSE),
                       selectizeInput('tcgaPlatformFilter',
                                      'Platform filter',
                                      NULL,
                                      multiple = FALSE),
                       selectizeInput('tcgaWorkFlowFilter',
                                      'Workflow filter',
                                      NULL,
                                      multiple = FALSE),
                       selectizeInput('tcgaFileTypeFilter',
                                      'File type filter',
                                      NULL,
                                      multiple = FALSE),
                       selectizeInput('tcgaExpStrategyFilter',
                                      'Experimental strategy',
                                      NULL,
                                      multiple = FALSE),
                       #selectizeInput('tcgaAcessFilter',
                       #                  'Data access level',
                       #                  c("controlled","open"),
                       #                  multiple = FALSE),
                       #selectizeInput('tcgaExpFilter',
                       #              'Platforms filter',
                       #               sort(unique(TCGAquery()$Platform)),
                       #               multiple = TRUE, selected = NULL),
                       #bsTooltip("tcgaMatchedPlatform", "If checked only samples that have data in all platforms will be downloaded", "left"),
                       #checkboxInput("tcgaMatchedPlatform", "Only samples with all platforms?", value = FALSE, width = NULL),
                       #selectizeInput('tcgaLevelFilter',
                       #              'Level filter',
                       #               c(1:3),
                       #                  multiple = TRUE, selected = NULL),
                       selectizeInput('tcgasamplestypeFilter',
                                      'Sample type filter',
                                      names(table.code),
                                      multiple = TRUE),
                       useShinyjs(),
                       h5(strong("Barcode")),
                       inputTextarea('tcgaDownloadBarcode', '', 2, 60),
                       bsTooltip("tcgaDownloadBarcode", "Barcodes separeted by (;), (,) or (new line). Example: TCGA-02-0047, TCGA-06-2559", "left"),
                       box(title = "Clinical filters",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                           checkboxInput("tcgaMolecularFilterClinical", "Filter using clinical data ?", value = FALSE, width = NULL),
                           bsTooltip("tcgaMolecularFilterClinical", "If checked and all filters are empty, only data with indexed clinical information will be selected.", "left"),
                           selectizeInput('tcgaClinicalGenderFilter',
                                          'Gender',
                                          NULL,
                                          multiple = TRUE),
                           selectizeInput('tcgaClinicalRaceFilter',
                                          'Race',
                                          NULL,
                                          multiple = TRUE),
                           selectizeInput('tcgaClinicalVitalStatusFilter',
                                          'Vital status',
                                          NULL,
                                          multiple = TRUE),
                           selectizeInput('tcgaClinicalTumorStageFilter',
                                          'Tumor stage',
                                          NULL,
                                          multiple = TRUE)
                       ),
                       actionButton("tcgaSearchBt",
                                    "Visualize Data",
                                    style = "background-color: #000080;
                                    color: #FFFFFF;
                                    margin-left: auto;
                                    margin-right: auto;
                                    width: 100%",
                                    icon = icon("search"))),
                   box(title = "Download & Prepare",width = NULL,
                       status = "danger",
                       solidHeader = FALSE, collapsible = TRUE, collapsed = TRUE,
                       radioButtons("prepareRb", "Data type:",
                                    c("SummarizedExperiment" = TRUE,
                                      "Dataframe" = FALSE)),
                       bsTooltip("prepareRb", "The SummarizedExperiment container contains one or more assays, each represented by a matrix-like object of numeric or other mode. The rows typically represent genomic ranges of interest and the columns represent samples.",
                                 "left"),
                       useShinyjs(),
                       checkboxInput("addGistic", "Add gistic2 and mutation information ?", value = FALSE, width = NULL),
                       bsTooltip("addGistic", "GISTIC2 results from GDAC firehose (data aligned against hg19) and Mutation information from MAF will be added to SummarizedExperiment (data aligned against hg38)",
                                 "left"),
                       selectizeInput('gisticGenes',
                                      "Genes",
                                      choices = NULL,
                                      multiple = TRUE),
                       useShinyjs(),
                       selectizeInput('tcgaPrepareMutPipeline',
                                      'Variant calling pipelines',
                                      choices = c("muse"="muse", "somaticsniper"="somaticsniper","mutect2"="mutect2","varscan2"="varscan2"),
                                      multiple = FALSE),
                       textInput("tcgafilename", "File name", value = "TCGA.rda", width = NULL, placeholder = NULL),
                       actionButton("tcgaPrepareBt",
                                    "Download and prepare data",
                                    style = "background-color: #000080;
                                            color: #FFFFFF;
                                            margin-left: auto;
                                            margin-right: auto;
                                            width: 100%",
                                    icon = icon("cogs")))
            ))
)
