tabItem(tabName = "heatmap",

        fluidRow(
            column(8,  bsAlert("heatmapmessage"),
                   bsCollapse(id = "collapseHeatmap", open = "Heatmap",
                              bsCollapsePanel("Heatmap",
                                              #busyIndicator("Rendering in progress...",wait = 10000),
                                              uiOutput("heatmapPlot"), style = "default"))),
            column(4,
                   box(title = "Heatmap",width = NULL,
                       status = "danger",
                       solidHeader = FALSE, collapsible = FALSE,
                       box(title = "Data",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = FALSE,
                           shinyFilesButton('heatmapfile', 'Select file',
                                            'Please select SummarizedExperiment or data frame object',
                                            multiple = FALSE),
                           tags$br(),
                           tags$br(),
                           shinyFilesButton('heatmapresultsfile', 'Select results', 'Please select object',
                                            multiple = FALSE)),
                       box(title = "Type of heatmap",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,

                           radioButtons("heatmapTypeInputRb", NULL,
                                        c("DNA methylation"="met",
                                          "Gene expression"="exp"),selected = "met")
                       ),
                       box(title = "Genes/Probes selection",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,

                           useShinyjs(),
                           radioButtons("heatmapProbesInputRb", "Select probes by:",
                                        c("Status"="Status",
                                          "Selection"="Selection",
                                          "Text"="text")),
                           selectizeInput('heatmaprobes',
                                          "Probes",
                                          choices = NULL,
                                          multiple = TRUE),
                           inputTextarea('heatmapProbesTextArea', '', 2, 30),
                           checkboxInput("heatmap.hypoprobesCb", "Hypermethylatd probes", value = TRUE, width = NULL),
                           checkboxInput("heatmap.hyperprobesCb", "Hypomethylated probes", value = TRUE, width = NULL),
                           radioButtons("heatmapGenesInputRb", "Select genes by:",
                                        c("Status"="Status",
                                          "Selection"="Selection",
                                          "Text"="text")),
                           selectizeInput('heatmagenes',
                                          "Genes",
                                          choices = NULL,
                                          multiple = TRUE),
                           inputTextarea('heatmapGenesTextArea', '', 2, 30),
                           checkboxInput("heatmap.upGenesCb", "Up regulated genes", value = TRUE, width = NULL),
                           checkboxInput("heatmap.downGenewsCb", "Down regulated genes", value = TRUE, width = NULL)),
                       box(title = "Annotations options",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                           selectizeInput('colmetadataheatmap',
                                          "Columns annotations",
                                          choices = NULL,  multiple = TRUE),
                           bsTooltip("colmetadataheatmap", "Add annotation from SummarizedExperiment into heatmap", "left"),
                           checkboxInput("heatmap.sortCb", "Sort by column?", value = FALSE, width = NULL),
                           selectizeInput('heatmapSortCol',
                                          "Sort by columns",
                                          choices = NULL,  multiple = FALSE),
                           selectizeInput('rowmetadataheatmap',
                                          "Rows annotations",
                                          choices = NULL,  multiple = TRUE),
                           checkboxInput("heatmap.show.row.names", "Show row names?", value = FALSE, width = NULL),
                           checkboxInput("heatmap.show.col.names", "Show col names?", value = FALSE, width = NULL)
                           ),
                       box(title = "Text options",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                           textInput("heatmapMain", label = "Title", value = "Heatmap"),
                           textInput("heatmapLabel", label = "Values label", value = "Values")
                       ),
                       box(title = "Color options",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                           checkboxInput("heatmap.colorsCb", "Set colors?", value = FALSE, width = NULL),
                           colourpicker::colourInput("heatmapcolMax", "Max level", value = "red"),
                           colourpicker::colourInput("heatmapcolMid", "Mid level", value = "black"),
                           colourpicker::colourInput("heatmapcolMin", "Min level", value = "green"),
                           checkboxInput("heatmap.extremesCb", "Set extremes?", value = FALSE, width = NULL),
                           numericInput("heatmapExtremeMax", "Max Level extreme",
                                        min = -1000000, max = 10000000, value = 0, step = 1),
                           numericInput("heatmapExtremeMid",  "Mid Level extreme",
                                        min = -1000000, max = 10000000, value = 0, step = 1),
                           numericInput("heatmapExtremeMin",  "Min Level extreme",
                                        min = -1000000, max = 10000000, value = 0, step = 1)
                       ),
                       box(title = "Clustering and transformation",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                           selectizeInput('heatmapScale',
                                          "Scale data",
                                          choices = c("none","row","col"),selected = "none",  multiple = FALSE),
                           bsTooltip("heatmapScale", "col: scale and center columns (samples); row: scale and center rows (genes)", "left"),
                           checkboxInput("heatmaplog2_plus_one", "Take the log2(matrix + 1)?", value = FALSE, width = NULL),
                           bsTooltip("heatmaplog2_plus_one", "This will plot log2(expression data + 1). This is not used for DNA methylation hetmaps.", "left"),
                           checkboxInput("heatmap.clusterrows", "Cluster rows?", value = FALSE, width = NULL),
                           checkboxInput("heatmap.clustercol", "Cluster columns?", value = FALSE, width = NULL)),
                       box(title = "Size control",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                           sliderInput("heatmapwidth", "Plot Width (%)", min = 0, max = 100, value = 100),
                           sliderInput("heatmapheight", "Plot Height (px)", min = 0, max = 1200, value = 1000),
                           sliderInput("heatmapRownamesSize", "Row names size", min = 1, max = 18, value = 10)
                       ),
                       actionButton("heatmapPlotBt",
                                    "Heatmap plot",
                                    style = "background-color: #000080;
                                    color: #FFFFFF;
                                    margin-left: auto;
                                    margin-right: auto;
                                    width: 100%",
                                    icon = icon("picture-o")))
            )
        )
)
