## ----knitr-options, echo=FALSE, message=FALSE, warning=FALSE-------------
library(knitr)
opts_chunk$set(fig.align = 'center', fig.width = 6, fig.height = 5, dev = 'png')

## ---- message=FALSE, warning=FALSE---------------------------------------
library(scater)
library(SC3)
treutlein[1:3, 1:3]

## ------------------------------------------------------------------------
# cell annotation
ann <- data.frame(cell_type1 = colnames(treutlein))
pd <- new("AnnotatedDataFrame", data = ann)
# cell expression
tmp <- treutlein
colnames(tmp) <- rownames(ann)
# SCESEt object
sceset <- newSCESet(fpkmData = tmp, phenoData = pd, logExprsOffset = 1)

## ------------------------------------------------------------------------
sceset <- calculateQCMetrics(sceset)

## ------------------------------------------------------------------------
plotPCA(sceset, colour_by = "cell_type1")

## ------------------------------------------------------------------------
# Note that n_cores = 1 is required for compilation of this vignette.
# Please remove this parameter when running on your computer:
# sceset <- sc3(sceset, ks = 2:4, biology = TRUE)
sceset <- sc3(sceset, ks = 2:4, biology = TRUE, n_cores = 1)

## ---- eval=FALSE---------------------------------------------------------
#  sc3_interactive(sceset)

## ----eval=FALSE----------------------------------------------------------
#  sc3_export_results_xls(sceset)

## ------------------------------------------------------------------------
p_data <- pData(sceset)
head(p_data[ , grep("sc3_", colnames(p_data))])

## ------------------------------------------------------------------------
plotPCA(
    sceset, 
    colour_by = "sc3_3_clusters", 
    size_by = "sc3_3_log2_outlier_score"
)

## ------------------------------------------------------------------------
f_data <- fData(sceset)
head(f_data[ , grep("sc3_", colnames(f_data))])

## ------------------------------------------------------------------------
plotFeatureData(
    sceset, 
    aes(
        x = sc3_3_markers_clusts, 
        y = sc3_3_markers_auroc, 
        colour = sc3_3_markers_padj
    )
)

## ---- fig.height=6-------------------------------------------------------
sc3_plot_consensus(sceset, k = 3)

## ---- fig.height=6, fig.width=8------------------------------------------
sc3_plot_consensus(
    sceset, k = 3, 
    show_pdata = c(
        "cell_type1", 
        "log10_total_features",
        "sc3_3_clusters", 
        "sc3_3_log2_outlier_score"
    )
)

## ------------------------------------------------------------------------
sc3_plot_silhouette(sceset, k = 3)

## ---- fig.height=6-------------------------------------------------------
sc3_plot_expression(sceset, k = 3)

## ---- fig.height=6, fig.width=8------------------------------------------
sc3_plot_expression(
    sceset, k = 3, 
    show_pdata = c(
        "cell_type1", 
        "log10_total_features",
        "sc3_3_clusters", 
        "sc3_3_log2_outlier_score"
    )
)

## ---- fig.height=3-------------------------------------------------------
sc3_plot_cluster_stability(sceset, k = 3)

## ---- fig.height=9-------------------------------------------------------
sc3_plot_de_genes(sceset, k = 3)

## ---- fig.height=9, fig.width=8------------------------------------------
sc3_plot_de_genes(
    sceset, k = 3, 
    show_pdata = c(
        "cell_type1", 
        "log10_total_features",
        "sc3_3_clusters", 
        "sc3_3_log2_outlier_score"
    )
)

## ---- fig.height=6-------------------------------------------------------
sc3_plot_markers(sceset, k = 3)

## ---- fig.height=6, fig.width=8------------------------------------------
sc3_plot_markers(
    sceset, k = 3, 
    show_pdata = c(
        "cell_type1", 
        "log10_total_features",
        "sc3_3_clusters", 
        "sc3_3_log2_outlier_score"
    )
)

## ------------------------------------------------------------------------
# Note that n_cores = 1 is required for compilation of this vignette.
# Please remove this parameter when running on your computer:
# sceset <- sc3_prepare(sceset, ks = 2:4)
sceset <- sc3_prepare(sceset, ks = 2:4, n_cores = 1)
str(sceset@sc3)

## ------------------------------------------------------------------------
sceset <- sc3_estimate_k(sceset)
str(sceset@sc3)

## ------------------------------------------------------------------------
sceset <- sc3_calc_dists(sceset)
names(sceset@sc3$distances)

## ------------------------------------------------------------------------
sceset <- sc3_calc_transfs(sceset)
names(sceset@sc3$transformations)

## ------------------------------------------------------------------------
sceset@sc3$distances

## ------------------------------------------------------------------------
sceset <- sc3_kmeans(sceset)
names(sceset@sc3$kmeans)

## ------------------------------------------------------------------------
p_data <- pData(sceset)
head(p_data[ , grep("sc3_", colnames(p_data))])

## ------------------------------------------------------------------------
sceset <- sc3_calc_consens(sceset)
names(sceset@sc3$consensus)
names(sceset@sc3$consensus$`3`)

## ------------------------------------------------------------------------
sceset@sc3$kmeans

## ------------------------------------------------------------------------
p_data <- pData(sceset)
head(p_data[ , grep("sc3_", colnames(p_data))])

## ------------------------------------------------------------------------
sceset <- sc3_calc_biology(sceset)

## ------------------------------------------------------------------------
p_data <- pData(sceset)
head(p_data[ , grep("sc3_", colnames(p_data))])

## ------------------------------------------------------------------------
f_data <- fData(sceset)
head(f_data[ , grep("sc3_", colnames(f_data))])

## ------------------------------------------------------------------------
no_svm_labels <- pData(sceset)$sc3_3_clusters

## ------------------------------------------------------------------------
# Note that n_cores = 1 is required for compilation of this vignette.
# Please remove this parameter when running on your computer:
# sceset <- sc3(sceset, ks = 2:4, svm.num.cells = 50)
sceset <- sc3(sceset, ks = 2:4, biology = TRUE, svm_num_cells = 50, n_cores = 1)

## ------------------------------------------------------------------------
p_data <- pData(sceset)
head(p_data[ , grep("sc3_", colnames(p_data))])

## ---- message=FALSE, warning=FALSE---------------------------------------
sceset <- sc3_run_svm(sceset)
p_data <- pData(sceset)
head(p_data[ , grep("sc3_", colnames(p_data))])

## ------------------------------------------------------------------------
sceset@sc3$svm_train_inds <- NULL
sceset <- sc3_calc_biology(sceset)
p_data <- pData(sceset)
head(p_data[ , grep("sc3_", colnames(p_data))])

## ------------------------------------------------------------------------
svm_labels <- pData(sceset)$sc3_3_clusters

## ------------------------------------------------------------------------
if (require("mclust")) {
  adjustedRandIndex(no_svm_labels, svm_labels)
}

