## ----style, echo=FALSE, results="asis", message=FALSE--------------------
BiocStyle::markdown()
knitr::opts_chunk$set(tidy = FALSE,
                      warning = FALSE,
                      message = FALSE)

## ----echo=FALSE, results='hide', message=FALSE---------------------------
library(org.Hs.eg.db)
library(DOSE)
library(ReactomePA)

## ------------------------------------------------------------------------
library(ReactomePA)
data(geneList)
de <- names(geneList)[abs(geneList) > 1.5]
head(de)
x <- enrichPathway(gene=de,pvalueCutoff=0.05, readable=T)
head(as.data.frame(x))

## ----fig.height=4, fig.width=7-------------------------------------------
barplot(x, showCategory=8)

## ----fig.height=6, fig.width=8-------------------------------------------
dotplot(x, showCategory=15)

## ----fig.height=16, fig.width=20, eval=FALSE-----------------------------
#  enrichMap(x, layout=igraph::layout.kamada.kawai, vertex.label.cex = 1)

## ----fig.height=12, fig.width=12, eval=FALSE-----------------------------
#  cnetplot(x, categorySize="pvalue", foldChange=geneList)

## ----fig.height=8, fig.width=13, eval=FALSE------------------------------
#  require(clusterProfiler)
#  data(gcSample)
#  res <- compareCluster(gcSample, fun="enrichPathway")
#  plot(res)

## ------------------------------------------------------------------------
y <- gsePathway(geneList, nPerm=1000,
                minGSSize=120, pvalueCutoff=0.2,
                pAdjustMethod="BH", verbose=FALSE)
res <- as.data.frame(y)
head(res)

## ----fig.height=16, fig.width=16, eval=FALSE-----------------------------
#  enrichMap(y)

## ----fig.height=7, fig.width=10------------------------------------------
gseaplot(y, geneSetID = "R-HSA-69242")

## ----fig.height=16, fig.width=16, eval=FALSE-----------------------------
#  viewPathway("E2F mediated regulation of DNA replication", readable=TRUE, foldChange=geneList)

## ----echo=FALSE----------------------------------------------------------
sessionInfo()

