/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.metrics;

import net.sf.picard.metrics.Header;
import net.sf.samtools.util.StringUtil;

public class StringHeader
implements Header {
    private String value;

    public StringHeader() {
    }

    public StringHeader(String value) {
        this.setValue(value);
    }

    @Override
    public void parse(String in) {
        this.value = in.trim();
    }

    @Override
    public String toString() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = StringUtil.assertCharactersNotInString(value, '\n');
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof StringHeader) {
            StringHeader that = (StringHeader)o;
            if (this.value == null) {
                return that.value == null;
            }
            return this.value.equals(that.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }
}

