### R code from vignette source 'REMP.Rnw'

###################################################
### code chunk number 1: REMP.Rnw:26-34
###################################################
library(knitr)
options(width=60)

listing <- function(x, options) {
  paste("\\begin{lstlisting}[basicstyle=\\ttfamily,breaklines=true]\n",
    x, "\\end{lstlisting}\n", sep = "")
}
knit_hooks$set(source=listing, output=listing)


###################################################
### code chunk number 2: bioconductorREMPrelease (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("REMP")


###################################################
### code chunk number 3: bioconductorREMPdev (eval = FALSE)
###################################################
## library(devtools)
## install_github("YinanZheng/REMP")


###################################################
### code chunk number 4: loadREMP
###################################################
library(REMP)


###################################################
### code chunk number 5: grooMethy
###################################################
# Get GM12878 methylation data (450k array)
GM12878_450k <- getGM12878('450k') 
GM12878_450k <- grooMethy(GM12878_450k, verbose = TRUE)
GM12878_450k


###################################################
### code chunk number 6: remparcel
###################################################
data(Alu.demo)
remparcel <- initREMP(arrayType = "450k", REtype = "Alu", 
                      RE = Alu.demo, ncore = 1)
remparcel


###################################################
### code chunk number 7: saveParcel
###################################################
saveParcel(remparcel)


###################################################
### code chunk number 8: rempredict
###################################################
remp.res <- remp(GM12878_450k, REtype = 'Alu', 
                 parcel = remparcel, ncore = 1, seed = 777)


###################################################
### code chunk number 9: rempprint
###################################################
remp.res

# Display more detailed information
details(remp.res)


###################################################
### code chunk number 10: rempaccessors
###################################################
# Predicted RE-CpG methylation value (Beta value)
rempB(remp.res)

# Predicted RE-CpG methylation value (M value)
rempM(remp.res)

# Genomic location information of the predicted RE-CpG
# Function inherit from class 'RangedSummarizedExperiment'
rowRanges(remp.res)

# Standard error-scaled permutation importance of predictors
imp(remp.res)

# Retrive seed number used for the reesults
metadata(remp.res)$Seed


###################################################
### code chunk number 11: remptrim
###################################################
# Any predicted CpG values with quality score < threshold (default = 1.7) will be replaced with NA. CpGs contain more than missingRate * 100% (default = 20%) missing rate across samples will be discarded. 
# For mechanism study, more stringent cutoff is recommended.
remp.res <- trim(remp.res)
details(remp.res)


###################################################
### code chunk number 12: rempdecodeAnnot (eval = FALSE)
###################################################
## # By default gene symbol annotation will be added
## remp.res <- decodeAnnot(remp.res, ncore = 1)
## annotation(remp.res)


###################################################
### code chunk number 13: rempplot
###################################################
plot(remp.res, main = "Alu methylation (GM12878)", col = "blue")


###################################################
### code chunk number 14: SessionInfo
###################################################
sessionInfo()


