/*
 * Decompiled with CFR 0.152.
 */
package de.proteinms.xtandemparser.viewer;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;

public class ProgressDialog
extends JDialog {
    private JProgressBar progressBar;

    public ProgressDialog(Frame aParent) {
        super(aParent);
        this.initComponents();
        this.setLocationRelativeTo(aParent);
    }

    private void initComponents() {
        this.progressBar = new JProgressBar();
        this.setDefaultCloseOperation(0);
        this.setTitle("Please Wait...");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ProgressDialog.this.closeDialog(evt);
            }
        });
        this.progressBar.setFont(this.progressBar.getFont().deriveFont((float)this.progressBar.getFont().getSize() - 1.0f));
        this.progressBar.setIndeterminate(true);
        this.progressBar.setStringPainted(true);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.progressBar, -1, 285, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.progressBar, -2, 19, -2).addContainerGap()));
        this.pack();
    }

    public void setValue(final int value) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.progressBar.setValue(value);
            }
        });
    }

    public void setMaxValue(final int maxValue) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.progressBar.setMaximum(maxValue);
            }
        });
    }

    public void setIndeterminate(final boolean indeterminate) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.progressBar.setStringPainted(!indeterminate);
                ProgressDialog.this.progressBar.setIndeterminate(indeterminate);
            }
        });
    }

    public void setFileName(final String fileName) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.progressBar.setStringPainted(fileName != null);
                ProgressDialog.this.progressBar.setString(fileName);
            }
        });
    }

    private void closeDialog(WindowEvent event) {
        int option = JOptionPane.showConfirmDialog(this.getParent(), "Closing the progress bar will close XTandem Viewer.\nDo you still want to close the progress bar?", "Close XTandem Viewer?", 0);
        if (option == 0) {
            System.exit(0);
        }
    }
}

