/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.preferences;

import com.compomics.util.experiment.biology.MutationMatrix;
import com.compomics.util.experiment.identification.SearchParameters;
import java.io.Serializable;

public class SequenceMatchingPreferences
implements Serializable {
    static final long serialVersionUID = 228961121369106450L;
    private MatchingType sequenceMatchingType;
    private Double ms2MzTolerance = null;
    private Double limitX = null;
    private MutationMatrix mutationMatrix = null;
    private Integer maxMutationsPerPeptide = null;
    public static final SequenceMatchingPreferences defaultStringMatching = SequenceMatchingPreferences.getStringMatching();

    public static SequenceMatchingPreferences getStringMatching() {
        SequenceMatchingPreferences sequenceMatchingPreferences = new SequenceMatchingPreferences();
        sequenceMatchingPreferences.setSequenceMatchingType(MatchingType.string);
        return sequenceMatchingPreferences;
    }

    public static SequenceMatchingPreferences getDefaultSequenceMatching(SearchParameters searchParameters) {
        SequenceMatchingPreferences sequenceMatchingPreferences = new SequenceMatchingPreferences();
        sequenceMatchingPreferences.setSequenceMatchingType(MatchingType.indistiguishableAminoAcids);
        sequenceMatchingPreferences.setMs2MzTolerance(searchParameters.getFragmentIonAccuracy());
        sequenceMatchingPreferences.setLimitX(0.25);
        return sequenceMatchingPreferences;
    }

    public MatchingType getSequenceMatchingType() {
        return this.sequenceMatchingType;
    }

    public void setSequenceMatchingType(MatchingType sequenceMatchingType) {
        this.sequenceMatchingType = sequenceMatchingType;
    }

    public Double getMs2MzTolerance() {
        return this.ms2MzTolerance;
    }

    public void setMs2MzTolerance(Double ms2MzTolerance) {
        this.ms2MzTolerance = ms2MzTolerance;
    }

    public Double getLimitX() {
        return this.limitX;
    }

    public boolean hasLimitX() {
        return this.limitX != null && this.limitX >= 0.0;
    }

    public void setLimitX(Double limitX) {
        this.limitX = limitX;
    }

    public MutationMatrix getMutationMatrix() {
        return this.mutationMatrix;
    }

    public void setMutationMatrix(MutationMatrix mutationMatrix) {
        this.mutationMatrix = mutationMatrix;
    }

    public boolean hasMutationMatrix() {
        return this.mutationMatrix != null;
    }

    public Integer getMaxMutationsPerPeptide() {
        return this.maxMutationsPerPeptide;
    }

    public void setMaxMutationsPerPeptide(Integer maxMutationsPerPeptide) {
        this.maxMutationsPerPeptide = maxMutationsPerPeptide;
    }

    public boolean isSameAs(SequenceMatchingPreferences proteinInferencePreferences) {
        double diff;
        if (this.sequenceMatchingType != proteinInferencePreferences.getSequenceMatchingType()) {
            return false;
        }
        if (this.ms2MzTolerance != null && proteinInferencePreferences.getMs2MzTolerance() != null && (diff = Math.abs(this.ms2MzTolerance - proteinInferencePreferences.getMs2MzTolerance())) > 1.0E-13) {
            return false;
        }
        if (this.ms2MzTolerance == null && proteinInferencePreferences.getMs2MzTolerance() != null) {
            return false;
        }
        if (this.ms2MzTolerance != null && proteinInferencePreferences.getMs2MzTolerance() == null) {
            return false;
        }
        if (this.hasLimitX() && proteinInferencePreferences.hasLimitX() && (diff = Math.abs(this.limitX - proteinInferencePreferences.getLimitX())) > 1.0E-13) {
            return false;
        }
        if (this.hasLimitX() && !proteinInferencePreferences.hasLimitX()) {
            return false;
        }
        if (!this.hasLimitX() && proteinInferencePreferences.hasLimitX()) {
            return false;
        }
        if (this.hasMutationMatrix() && proteinInferencePreferences.hasMutationMatrix() && !this.mutationMatrix.isSameAs(proteinInferencePreferences.getMutationMatrix())) {
            return false;
        }
        if (!this.hasMutationMatrix() && proteinInferencePreferences.hasMutationMatrix()) {
            return false;
        }
        return !this.hasMutationMatrix() || proteinInferencePreferences.hasMutationMatrix();
    }

    public static enum MatchingType {
        string,
        aminoAcid,
        indistiguishableAminoAcids;

    }
}

