/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.matches;

import com.compomics.util.experiment.biology.Atom;
import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.ions.ElementaryIon;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.biology.ions.TagFragmentIon;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.pride.CvTerm;

public class IonMatch
extends ExperimentObject {
    static final long serialVersionUID = 5753142782728884464L;
    public Peak peak;
    public Ion ion;
    public Charge charge;

    public IonMatch(Peak aPeak, Ion anIon, Charge aCharge) {
        this.peak = aPeak;
        this.ion = anIon;
        this.charge = aCharge;
    }

    public double getError() {
        return this.peak.mz - (this.ion.getTheoreticMass() + (double)this.charge.value * Atom.H.getMonoisotopicMass()) / (double)this.charge.value;
    }

    public double getAbsoluteError(boolean subtractIsotope) {
        double theoreticMass = this.ion.getTheoreticMass();
        if (subtractIsotope) {
            theoreticMass -= (double)this.getIsotopeNumber() * Atom.C.getDifferenceToMonoisotopic(1);
        }
        return this.peak.mz - (theoreticMass + (double)this.charge.value * ElementaryIon.proton.getTheoreticMass()) / (double)this.charge.value;
    }

    public double getAbsoluteError() {
        return this.getAbsoluteError(false);
    }

    public double getRelativeError(boolean subtractIsotope) {
        if (this.charge != null && this.charge.value != 0) {
            double theoreticMz = (this.ion.getTheoreticMass() + (double)this.charge.value * ElementaryIon.proton.getTheoreticMass()) / (double)this.charge.value;
            double measuredMz = this.peak.mz;
            if (subtractIsotope) {
                measuredMz -= (double)this.getIsotopeNumber() * Atom.C.getDifferenceToMonoisotopic(1) / (double)this.charge.value;
            }
            return (measuredMz - theoreticMz) / theoreticMz * 1000000.0;
        }
        return Double.MAX_VALUE;
    }

    public double getRelativeError() {
        return this.getRelativeError(false);
    }

    public int getIsotopeNumber() {
        double experimentalMass = this.peak.mz * (double)this.charge.value - (double)this.charge.value * ElementaryIon.proton.getTheoreticMass();
        double result = (experimentalMass - this.ion.getTheoreticMass()) / Atom.C.getDifferenceToMonoisotopic(1);
        return Math.min(Math.max((int)Math.round(result), 0), 4);
    }

    public double getError(boolean isPpm, boolean subtractIsotope) {
        if (isPpm) {
            return this.getRelativeError(subtractIsotope);
        }
        return this.getAbsoluteError(subtractIsotope);
    }

    public String getPeakAnnotation() {
        return IonMatch.getPeakAnnotation(false, this.ion, this.charge);
    }

    public static String getPeakAnnotation(Ion ion, Charge charge) {
        return IonMatch.getPeakAnnotation(false, ion, charge);
    }

    public static String getMatchKey(Ion ion, int charge) {
        StringBuilder key = new StringBuilder();
        key.append(ion.getType().index).append("_");
        key.append(ion.getSubType()).append("_");
        if (ion.getType() == Ion.IonType.PEPTIDE_FRAGMENT_ION) {
            PeptideFragmentIon fragmentIon = (PeptideFragmentIon)ion;
            key.append(fragmentIon.getNumber()).append("_");
        } else if (ion.getType() == Ion.IonType.TAG_FRAGMENT_ION) {
            TagFragmentIon tagFragmentIon = (TagFragmentIon)ion;
            key.append(tagFragmentIon.getSubNumber()).append("_");
        }
        key.append(ion.getNeutralLossesAsString()).append("_");
        key.append(charge);
        return key.toString();
    }

    public static String getPeakAnnotation(boolean html, Ion ion, Charge charge) {
        StringBuilder result = new StringBuilder();
        switch (ion.getType()) {
            case PEPTIDE_FRAGMENT_ION: {
                if (html) {
                    result.append("<html>");
                }
                result.append(ion.getSubTypeAsString());
                PeptideFragmentIon fragmentIon = (PeptideFragmentIon)ion;
                if (html) {
                    result.append("<sub>").append(fragmentIon.getNumber()).append("</sub>");
                } else {
                    result.append(fragmentIon.getNumber());
                }
                result.append(charge.getChargeAsFormattedString());
                if (html) {
                    String neutralLoss = ion.getNeutralLossesAsString();
                    for (int i = 0; i < neutralLoss.length(); ++i) {
                        if (Character.isDigit(neutralLoss.charAt(i))) {
                            result.append("<sub>").append(neutralLoss.charAt(i)).append("</sub>");
                            continue;
                        }
                        result.append(neutralLoss.charAt(i));
                    }
                } else {
                    result.append(ion.getNeutralLossesAsString());
                }
                if (html) {
                    result.append("</html>");
                }
                return result.toString();
            }
            case TAG_FRAGMENT_ION: {
                TagFragmentIon tagFragmentIon = (TagFragmentIon)ion;
                if (html) {
                    result.append("<html>");
                }
                result.append(ion.getSubTypeAsString());
                if (html) {
                    result.append("<sub>").append(tagFragmentIon.getSubNumber()).append("</sub>");
                } else {
                    result.append(tagFragmentIon.getSubNumber());
                }
                result.append(charge.getChargeAsFormattedString());
                if (html) {
                    String neutralLoss = ion.getNeutralLossesAsString();
                    for (int i = 0; i < neutralLoss.length(); ++i) {
                        if (Character.isDigit(neutralLoss.charAt(i))) {
                            result.append("<sub>").append(neutralLoss.charAt(i)).append("</sub>");
                            continue;
                        }
                        result.append(neutralLoss.charAt(i));
                    }
                } else {
                    result.append(ion.getNeutralLossesAsString());
                }
                if (html) {
                    result.append("</html>");
                }
                return result.toString();
            }
            case PRECURSOR_ION: {
                if (html) {
                    result.append("<html>");
                }
                result.append(ion.getSubTypeAsString()).append("-");
                result.append(charge.getChargeAsFormattedString());
                String neutralLoss = ion.getNeutralLossesAsString();
                if (html) {
                    for (int i = 0; i < neutralLoss.length(); ++i) {
                        if (Character.isDigit(neutralLoss.charAt(i))) {
                            result.append("<sub>").append(neutralLoss.charAt(i)).append("</sub>");
                            continue;
                        }
                        result.append(neutralLoss.charAt(i));
                    }
                } else {
                    result.append(neutralLoss);
                }
                if (html) {
                    result.append("</html>");
                }
                return result.toString();
            }
        }
        if (html) {
            result.append("<html>");
        }
        result.append(ion.getName());
        if (html) {
            result.append("</html>");
        }
        return result.toString();
    }

    public String getPeakAnnotation(boolean html) {
        return IonMatch.getPeakAnnotation(html, this.ion, this.charge);
    }

    public CvTerm getMZPrideCvTerm() {
        return new CvTerm("PRIDE", "PRIDE:0000188", "product ion m/z", this.peak.mz + "");
    }

    public CvTerm getIntensityPrideCvTerm() {
        return new CvTerm("PRIDE", "PRIDE:0000189", "product ion intensity", this.peak.intensity + "");
    }

    public CvTerm getIonMassErrorPrideCvTerm() {
        return new CvTerm("PRIDE", "PRIDE:0000190", "product ion mass error", this.getAbsoluteError(true) + "");
    }

    public CvTerm getChargePrideCvTerm() {
        return new CvTerm("PRIDE", "PRIDE:0000204", "product ion charge", this.charge.value + "");
    }
}

