/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.identification_parameters;

import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.IdentificationAlgorithmParameter;
import java.io.Serializable;
import java.util.ArrayList;

public class DirecTagParameters
implements Serializable,
IdentificationAlgorithmParameter {
    static final long serialVersionUID = -3107089648450731330L;
    private double ticCutoffPercentage = 85.0;
    private int maxPeakCount = 100;
    private int numIntensityClasses = 3;
    private boolean adjustPrecursorMass = false;
    private double minPrecursorAdjustment = -2.5;
    private double maxPrecursorAdjustment = 2.5;
    private double precursorAdjustmentStep = 0.1;
    private int numChargeStates = 3;
    private String outputSuffix = "";
    private boolean useChargeStateFromMS = false;
    private boolean duplicateSpectra = true;
    private int deisotopingMode = 0;
    private double isotopeMzTolerance = 0.25;
    private double complementMzTolerance = 0.5;
    private int tagLength = 4;
    private int maxDynamicMods = 2;
    private int maxTagCount = 20;
    private double intensityScoreWeight = 1.0;
    private double mzFidelityScoreWeight = 1.0;
    private double complementScoreWeight = 1.0;
    private ArrayList<String> variablePtms = new ArrayList();

    public int getNumChargeStates() {
        return this.numChargeStates;
    }

    public void setNumChargeStates(int numChargeStates) {
        this.numChargeStates = numChargeStates;
    }

    public String getOutputSuffix() {
        return this.outputSuffix;
    }

    public void setOutputSuffix(String outputSuffix) {
        this.outputSuffix = outputSuffix;
    }

    public boolean isUseChargeStateFromMS() {
        return this.useChargeStateFromMS;
    }

    public void setUseChargeStateFromMS(boolean useChargeStateFromMS) {
        this.useChargeStateFromMS = useChargeStateFromMS;
    }

    public boolean isDuplicateSpectra() {
        return this.duplicateSpectra;
    }

    public void setDuplicateSpectra(boolean duplicateSpectra) {
        this.duplicateSpectra = duplicateSpectra;
    }

    public int getDeisotopingMode() {
        return this.deisotopingMode;
    }

    public void setDeisotopingMode(int deisotopingMode) {
        this.deisotopingMode = deisotopingMode;
    }

    public double getIsotopeMzTolerance() {
        return this.isotopeMzTolerance;
    }

    public void setIsotopeMzTolerance(double isotopeMzTolerance) {
        this.isotopeMzTolerance = isotopeMzTolerance;
    }

    public double getComplementMzTolerance() {
        return this.complementMzTolerance;
    }

    public void setComplementMzTolerance(double complementMzTolerance) {
        this.complementMzTolerance = complementMzTolerance;
    }

    public int getTagLength() {
        return this.tagLength;
    }

    public void setTagLength(int tagLength) {
        this.tagLength = tagLength;
    }

    public int getMaxDynamicMods() {
        return this.maxDynamicMods;
    }

    public void setMaxDynamicMods(int maxDynamicMods) {
        this.maxDynamicMods = maxDynamicMods;
    }

    public int getMaxTagCount() {
        return this.maxTagCount;
    }

    public void setMaxTagCount(int maxTagCount) {
        this.maxTagCount = maxTagCount;
    }

    public double getIntensityScoreWeight() {
        return this.intensityScoreWeight;
    }

    public void setIntensityScoreWeight(double intensityScoreWeight) {
        this.intensityScoreWeight = intensityScoreWeight;
    }

    public double getMzFidelityScoreWeight() {
        return this.mzFidelityScoreWeight;
    }

    public void setMzFidelityScoreWeight(double mzFidelityScoreWeight) {
        this.mzFidelityScoreWeight = mzFidelityScoreWeight;
    }

    public double getComplementScoreWeight() {
        return this.complementScoreWeight;
    }

    public void setComplementScoreWeight(double complementScoreWeight) {
        this.complementScoreWeight = complementScoreWeight;
    }

    public double getTicCutoffPercentage() {
        return this.ticCutoffPercentage;
    }

    public void setTicCutoffPercentage(double ticCutoffPercentage) {
        this.ticCutoffPercentage = ticCutoffPercentage;
    }

    public int getMaxPeakCount() {
        return this.maxPeakCount;
    }

    public void setMaxPeakCount(int maxPeakCount) {
        this.maxPeakCount = maxPeakCount;
    }

    public int getNumIntensityClasses() {
        return this.numIntensityClasses;
    }

    public void setNumIntensityClasses(int numIntensityClasses) {
        this.numIntensityClasses = numIntensityClasses;
    }

    public boolean isAdjustPrecursorMass() {
        return this.adjustPrecursorMass;
    }

    public void setAdjustPrecursorMass(boolean adjustPrecursorMass) {
        this.adjustPrecursorMass = adjustPrecursorMass;
    }

    public double getMinPrecursorAdjustment() {
        return this.minPrecursorAdjustment;
    }

    public void setMinPrecursorAdjustment(double minPrecursorAdjustment) {
        this.minPrecursorAdjustment = minPrecursorAdjustment;
    }

    public double getMaxPrecursorAdjustment() {
        return this.maxPrecursorAdjustment;
    }

    public void setMaxPrecursorAdjustment(double maxPrecursorAdjustment) {
        this.maxPrecursorAdjustment = maxPrecursorAdjustment;
    }

    public double getPrecursorAdjustmentStep() {
        return this.precursorAdjustmentStep;
    }

    public void setPrecursorAdjustmentStep(double PrecursorAdjustmentStep) {
        this.precursorAdjustmentStep = PrecursorAdjustmentStep;
    }

    public void setPtms(ArrayList<String> variablePtms) {
        this.variablePtms = variablePtms;
    }

    public String getUtilitiesPtmName(int index) {
        if (this.variablePtms == null || this.variablePtms.isEmpty()) {
            throw new IllegalArgumentException("Variable PTM index map not set for this DirecTag sequencing.");
        }
        if (index < 0 || index >= this.variablePtms.size()) {
            throw new IllegalArgumentException("Variable PTM index " + index + " not found in mapping.");
        }
        return this.variablePtms.get(index);
    }

    @Override
    public Advocate getAlgorithm() {
        return Advocate.direcTag;
    }

    @Override
    public boolean equals(IdentificationAlgorithmParameter identificationAlgorithmParameter) {
        if (identificationAlgorithmParameter instanceof DirecTagParameters) {
            DirecTagParameters direcTagParameters = (DirecTagParameters)identificationAlgorithmParameter;
            if (this.ticCutoffPercentage != direcTagParameters.getTicCutoffPercentage()) {
                return false;
            }
            if (this.maxPeakCount != direcTagParameters.getMaxPeakCount()) {
                return false;
            }
            if (this.numIntensityClasses != direcTagParameters.getNumIntensityClasses()) {
                return false;
            }
            if (this.adjustPrecursorMass != direcTagParameters.isAdjustPrecursorMass()) {
                return false;
            }
            double diff = Math.abs(this.minPrecursorAdjustment - direcTagParameters.getMinPrecursorAdjustment());
            if (diff > 1.0E-13) {
                return false;
            }
            diff = Math.abs(this.maxPrecursorAdjustment - direcTagParameters.getMaxPrecursorAdjustment());
            if (diff > 1.0E-13) {
                return false;
            }
            diff = Math.abs(this.precursorAdjustmentStep - direcTagParameters.getPrecursorAdjustmentStep());
            if (diff > 1.0E-13) {
                return false;
            }
            if (this.numChargeStates != direcTagParameters.getNumChargeStates()) {
                return false;
            }
            if (this.outputSuffix.equalsIgnoreCase(direcTagParameters.getOutputSuffix()) && !this.outputSuffix.isEmpty() && direcTagParameters.getOutputSuffix().isEmpty()) {
                return false;
            }
            if (this.useChargeStateFromMS != direcTagParameters.isUseChargeStateFromMS()) {
                return false;
            }
            if (this.duplicateSpectra != direcTagParameters.isDuplicateSpectra()) {
                return false;
            }
            if (this.deisotopingMode != direcTagParameters.getDeisotopingMode()) {
                return false;
            }
            diff = Math.abs(this.isotopeMzTolerance - direcTagParameters.getIsotopeMzTolerance());
            if (diff > 1.0E-13) {
                return false;
            }
            diff = Math.abs(this.complementMzTolerance - direcTagParameters.getComplementMzTolerance());
            if (diff > 1.0E-13) {
                return false;
            }
            if (this.tagLength != direcTagParameters.getTagLength()) {
                return false;
            }
            if (this.maxDynamicMods != direcTagParameters.getMaxDynamicMods()) {
                return false;
            }
            if (this.maxTagCount != direcTagParameters.getMaxTagCount()) {
                return false;
            }
            diff = Math.abs(this.intensityScoreWeight - direcTagParameters.getIntensityScoreWeight());
            if (diff > 1.0E-13) {
                return false;
            }
            diff = Math.abs(this.mzFidelityScoreWeight - direcTagParameters.getMzFidelityScoreWeight());
            if (diff > 1.0E-13) {
                return false;
            }
            diff = Math.abs(this.complementScoreWeight - direcTagParameters.getComplementScoreWeight());
            return !(diff > 1.0E-13);
        }
        return false;
    }

    @Override
    public String toString(boolean html) {
        String newLine = System.getProperty("line.separator");
        if (html) {
            newLine = "<br>";
        }
        StringBuilder output = new StringBuilder();
        Advocate advocate = this.getAlgorithm();
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append("# ").append(advocate.getName()).append(" Specific Parameters");
        output.append(newLine);
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append(newLine);
        output.append("TIC_CUTOFF_PERCENTAGE=");
        output.append(this.ticCutoffPercentage);
        output.append(newLine);
        output.append("MAX_PEAK_COUNT=");
        output.append(this.maxPeakCount);
        output.append(newLine);
        output.append("NUM_INTENSITY_CLASSES=");
        output.append(this.numIntensityClasses);
        output.append(newLine);
        output.append("ADJUST_PRECURSOR_MASS=");
        output.append(this.adjustPrecursorMass);
        output.append(newLine);
        output.append("MIN_PRECUSOR_ADJUSTMENT=");
        output.append(this.minPrecursorAdjustment);
        output.append(newLine);
        output.append("MAX_PRECUSOR_ADJUSTMENT=");
        output.append(this.maxPrecursorAdjustment);
        output.append(newLine);
        output.append("PRECUSOR_ADJUSTMENT_STEP=");
        output.append(this.precursorAdjustmentStep);
        output.append(newLine);
        output.append("NUM_CHARGE_STATES=");
        output.append(this.numChargeStates);
        output.append(newLine);
        output.append("OUTPUT_SUFFIX=");
        output.append(this.outputSuffix);
        output.append(newLine);
        output.append("USE_CHARGE_STATE_FROM_MS=");
        output.append(this.useChargeStateFromMS);
        output.append(newLine);
        output.append("DUPLICATE_SPECTRA=");
        output.append(this.duplicateSpectra);
        output.append(newLine);
        output.append("DEISOTOPING_MODE=");
        output.append(this.deisotopingMode);
        output.append(newLine);
        output.append("ISOTOPE_MZ_TOLERANCE=");
        output.append(this.isotopeMzTolerance);
        output.append(newLine);
        output.append("COMPLEMENT_MZ_TOLERANCE=");
        output.append(this.complementMzTolerance);
        output.append(newLine);
        output.append("TAG_LENGTH=");
        output.append(this.tagLength);
        output.append(newLine);
        output.append("MAX_DYNAMIC_MODS=");
        output.append(this.maxDynamicMods);
        output.append(newLine);
        output.append("MAX_TAG_COUNT=");
        output.append(this.maxTagCount);
        output.append(newLine);
        output.append("INTENSITY_SCORE_WEIGHT=");
        output.append(this.intensityScoreWeight);
        output.append(newLine);
        output.append("MZ_FIDELITY_SCORE_WEIGHT=");
        output.append(this.mzFidelityScoreWeight);
        output.append(newLine);
        output.append("COMPLEMENT_SCORE_WEIGHT=");
        output.append(this.complementScoreWeight);
        output.append(newLine);
        return output.toString();
    }
}

