/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.builtins;

import java.util.Arrays;
import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Median
extends AbstractFunction {
    public Median() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.FLOATS, "numbers", "Any combination of lists of numbers or individual numbers.")});
    }

    public String getName() {
        return "MEDIAN";
    }

    public String getFunctionSummary() {
        return "Returns the median of a list of numbers.";
    }

    public Class getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        double[] numbers;
        try {
            numbers = FunctionUtil.getDoubles(args);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't convert an argument or list element to a number in a call to MEDIAN()!");
        }
        if (numbers.length == 0) {
            throw new IllegalArgumentException("can't calculate the median of an empty list!");
        }
        Arrays.sort(numbers);
        if (numbers.length % 2 == 1) {
            return numbers[numbers.length / 2];
        }
        return (numbers[numbers.length / 2 - 1] + numbers[numbers.length / 2]) / 2.0;
    }
}

