/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.properties;

import cytoscape.Cytoscape;
import cytoscape.render.stateful.CustomGraphic;
import cytoscape.visual.VisualPropertyDependency;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.customgraphic.CustomGraphicsManager;
import cytoscape.visual.customgraphic.CyCustomGraphics;
import cytoscape.visual.customgraphic.Layer;
import cytoscape.visual.customgraphic.NullCustomGraphics;
import cytoscape.visual.customgraphic.impl.vector.VectorCustomGraphics;
import cytoscape.visual.properties.AbstractVisualProperty;
import cytoscape.visual.ui.icon.NodeIcon;
import cytoscape.visual.ui.icon.VisualPropertyIcon;
import ding.view.DNodeView;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeCustomGraphicsProp
extends AbstractVisualProperty {
    private final int index;
    private Map<DNodeView, Set<CustomGraphic>> currentMap;

    public NodeCustomGraphicsProp(Integer index) {
        this.index = index - 1;
        this.currentMap = new HashMap<DNodeView, Set<CustomGraphic>>();
    }

    @Override
    public Icon getIcon(final Object value) {
        NodeIcon icon = new NodeIcon(){
            private static final long serialVersionUID = 403672612403499816L;
            private static final int ICON_SIZE = 128;
            private String name = null;

            public String getName() {
                if (this.name == null) {
                    this.name = value != null && value instanceof CyCustomGraphics ? ((CyCustomGraphics)value).getDisplayName() : "Unknown Custom Graphics";
                }
                return this.name;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                super.setColor(new Color(10, 10, 10, 25));
                this.g2d = (Graphics2D)g;
                this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                this.setIconHeight(134);
                if (value == null || !(value instanceof CyCustomGraphics)) {
                    this.drawDefaultIcon(c);
                } else {
                    CyCustomGraphics cg = (CyCustomGraphics)value;
                    Image originalImg = cg.getRenderedImage();
                    if (originalImg == null) {
                        this.drawDefaultIcon(c);
                    } else {
                        this.scaleImage(originalImg);
                    }
                }
            }

            public int getIconWidth() {
                return 128;
            }

            public int getIconHeight() {
                return 128;
            }

            private void drawDefaultIcon(Component c) {
                this.g2d.setFont(new Font("SansSerif", 1, 34));
                this.g2d.setColor(Color.DARK_GRAY);
                this.g2d.drawString(" Empty ", c.getX() + 25, c.getHeight() / 2 + 7);
                this.g2d.setFont(new Font("SansSerif", 1, 14));
            }

            private void scaleImage(Image originalImg) {
                float originalW = originalImg.getWidth(null);
                float originalH = originalImg.getHeight(null);
                float ratio = 1.0f;
                int shorterDim = 0;
                if (originalW <= 128.0f && originalH <= 128.0f) {
                    int xLocation = 72 - (int)originalW / 2;
                    int yLocation = 67 - (int)originalH / 2;
                    this.g2d.drawImage(originalImg, xLocation, yLocation, null);
                } else if (originalW > originalH) {
                    ratio = originalH / originalW;
                    shorterDim = (int)(128.0f * ratio);
                    Image scaledImg = originalImg.getScaledInstance(128, shorterDim, 16);
                    this.g2d.drawImage(scaledImg, 8, 3 + (128 - shorterDim) / 2, null);
                } else {
                    ratio = originalW / originalH;
                    shorterDim = (int)(128.0f * ratio);
                    Image scaledImg = originalImg.getScaledInstance(shorterDim, 128, 16);
                    this.g2d.drawImage(scaledImg, 8, 3, null);
                }
            }
        };
        return icon;
    }

    @Override
    public VisualPropertyType getType() {
        return VisualPropertyType.getCustomGraphicsType(this.index);
    }

    @Override
    public void applyToNodeView(NodeView nv, Object customGraphics, VisualPropertyDependency dep) {
        if (nv == null || !(nv instanceof DNodeView)) {
            return;
        }
        DNodeView dv = (DNodeView)nv;
        Set<CustomGraphic> targets = this.currentMap.get(dv);
        if (targets != null) {
            for (CustomGraphic cg : targets) {
                dv.removeCustomGraphic(cg);
            }
            targets.clear();
            targets = null;
        }
        if (customGraphics == null || !(customGraphics instanceof CyCustomGraphics) || customGraphics instanceof NullCustomGraphics) {
            this.currentMap.remove(dv);
            return;
        }
        targets = new HashSet<CustomGraphic>();
        CyCustomGraphics graphics = (CyCustomGraphics)customGraphics;
        List<Layer> layers = graphics.getLayers();
        if (layers == null || layers.size() == 0) {
            this.currentMap.remove(dv);
            return;
        }
        boolean sync = false;
        if (dep != null) {
            sync = dep.check(VisualPropertyDependency.Definition.NODE_CUSTOM_GRAPHICS_SIZE_SYNC);
        }
        for (Layer layer : layers) {
            CustomGraphic cg = (CustomGraphic)layer.getLayerObject();
            if (sync) {
                CustomGraphic resized = this.syncSize(graphics, cg, dv, dep);
                dv.addCustomGraphic(resized);
                targets.add(resized);
                continue;
            }
            dv.addCustomGraphic(cg);
            targets.add(cg);
        }
        this.currentMap.put(dv, targets);
    }

    private CustomGraphic syncSize(CyCustomGraphics graphics, CustomGraphic cg, DNodeView dv, VisualPropertyDependency dep) {
        double nodeW = dv.getWidth();
        double nodeH = dv.getHeight();
        Shape originalShape = cg.getShape();
        Rectangle2D originalBounds = originalShape.getBounds2D();
        double cgW = originalBounds.getWidth();
        double cgH = originalBounds.getHeight();
        if (nodeW == cgW && nodeH == cgH) {
            return cg;
        }
        boolean whLock = dep.check(VisualPropertyDependency.Definition.NODE_SIZE_LOCKED);
        float fit = graphics.getFitRatio();
        AffineTransform scale = whLock || graphics instanceof VectorCustomGraphics ? AffineTransform.getScaleInstance((double)fit * nodeW / cgW, (double)fit * nodeH / cgH) : (nodeW >= nodeH ? AffineTransform.getScaleInstance((double)fit * (nodeW / cgW) * (nodeH / nodeW), (double)fit * nodeH / cgH) : AffineTransform.getScaleInstance((double)fit * nodeW / cgW, (double)fit * (nodeH / cgH) * (nodeW / nodeH)));
        return new CustomGraphic(scale.createTransformedShape(originalShape), cg.getPaintFactory());
    }

    @Override
    public Object getDefaultAppearanceObject() {
        return NullCustomGraphics.getNullObject();
    }

    @Override
    public Map<Object, Icon> getIconSet() {
        HashMap<Object, Icon> customGraphicsIcons = new HashMap<Object, Icon>();
        CustomGraphicsManager pool = Cytoscape.getVisualMappingManager().getCustomGraphicsManager();
        for (CyCustomGraphics graphics : pool.getAll()) {
            VisualPropertyIcon icon = (VisualPropertyIcon)this.getIcon(graphics);
            icon.setName(graphics.getDisplayName());
            customGraphicsIcons.put(graphics, icon);
        }
        return customGraphicsIcons;
    }

    protected Set<CustomGraphic> getCurrentCustomGraphics(DNodeView dv) {
        return this.currentMap.get(dv);
    }
}

