/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.plugin;

import cytoscape.plugin.DownloadableInfo;
import cytoscape.plugin.DownloadableType;
import cytoscape.plugin.PluginInfo;
import cytoscape.plugin.PluginManager;
import cytoscape.plugin.PluginStatus;
import cytoscape.plugin.ThemeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagerUtil {
    private static final Comparator<DownloadableInfo> NAME_ORDER = new Comparator<DownloadableInfo>(){

        @Override
        public int compare(DownloadableInfo p1, DownloadableInfo p2) {
            int nameCmp = p2.getName().toLowerCase().compareTo(p1.getName().toLowerCase());
            return nameCmp;
        }
    };

    public static Map<String, List<DownloadableInfo>> sortByCategory(List<DownloadableInfo> Plugins2) {
        HashMap<String, List<DownloadableInfo>> Categories = new HashMap<String, List<DownloadableInfo>>();
        for (DownloadableInfo Current : Plugins2) {
            if (Categories.containsKey(Current.getCategory())) {
                ((List)Categories.get(Current.getCategory())).add(Current);
                continue;
            }
            ArrayList<DownloadableInfo> List2 = new ArrayList<DownloadableInfo>();
            List2.add(Current);
            Collections.sort(List2, NAME_ORDER);
            Categories.put(Current.getCategory(), List2);
        }
        return Categories;
    }

    public static Map<String, List<PluginInfo>> sortByClass(List<PluginInfo> Plugins2) {
        HashMap<String, List<PluginInfo>> Classes = new HashMap<String, List<PluginInfo>>();
        for (PluginInfo Current : Plugins2) {
            if (Classes.containsKey(Current.getPluginClassName())) {
                ((List)Classes.get(Current.getPluginClassName())).add(Current);
                continue;
            }
            ArrayList<PluginInfo> List2 = new ArrayList<PluginInfo>();
            List2.add(Current);
            Classes.put(Current.getPluginClassName(), List2);
        }
        return Classes;
    }

    public static Map<String, List<PluginInfo>> sortByID(List<PluginInfo> Plugins2) {
        HashMap<String, List<PluginInfo>> Ids = new HashMap<String, List<PluginInfo>>();
        for (PluginInfo Current : Plugins2) {
            if (Ids.containsKey(Current.getID())) {
                ((List)Ids.get(Current.getID())).add(Current);
                continue;
            }
            ArrayList<PluginInfo> List2 = new ArrayList<PluginInfo>();
            List2.add(Current);
            Ids.put(Current.getID(), List2);
        }
        return Ids;
    }

    public static List<DownloadableInfo> getUnique(List<DownloadableInfo> Current, List<DownloadableInfo> Available) {
        HashSet<DownloadableInfo> CurrentSet = new HashSet<DownloadableInfo>(Current);
        ArrayList<DownloadableInfo> UniqueAvail = new ArrayList<DownloadableInfo>(Available);
        if (Current == null) {
            return Available;
        }
        for (DownloadableInfo infoAvail : Available) {
            for (DownloadableInfo infoCur : Current) {
                PluginManager.getPluginManager();
                if (!PluginManager.usingWebstartManager()) {
                    if (!infoCur.getType().equals((Object)infoAvail.getType()) || !infoCur.equalsDifferentObjectVersion(infoAvail)) continue;
                    UniqueAvail.remove(infoAvail);
                    continue;
                }
                if (!infoCur.equalsDifferentObjectVersion(infoAvail) && !infoCur.getName().equals(infoAvail.getName())) continue;
                infoAvail.setDescription(infoCur.getDescription() + "<p><font color='red'><i><b>Webstart Warning:</b><br>This plugin may be the same as a plugin loaded with the webstart bundle '" + infoCur.toString() + "' </i></font>");
            }
        }
        return UniqueAvail;
    }

    public static DownloadableInfo getInfoObject(Class pluginClass) {
        PluginManager mgr = PluginManager.getPluginManager();
        List<DownloadableInfo> Downloadables = mgr.getDownloadables(PluginStatus.CURRENT);
        for (DownloadableInfo Current : Downloadables) {
            if (Current.getType().equals((Object)DownloadableType.THEME)) {
                ThemeInfo t = (ThemeInfo)Current;
                for (PluginInfo p : t.getPlugins()) {
                    if (!p.getPluginClassName().equals(pluginClass.getName())) continue;
                    return t;
                }
                continue;
            }
            PluginInfo p = (PluginInfo)Current;
            if (!p.getPluginClassName().equals(pluginClass.getName())) continue;
            return p;
        }
        return null;
    }

    public static List sort(List toSort) {
        return null;
    }
}

