/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.AllTests;
import cytoscape.data.Interaction;
import cytoscape.data.readers.InteractionsReader;
import cytoscape.data.servers.BioDataServer;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class InteractionsReaderTest
extends TestCase {
    private boolean runAllTests = AllTests.runAllTests();
    private BioDataServer nullServer = null;
    private String species = "unknown";

    public InteractionsReaderTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testReadFromTypicalFile() throws Exception {
        AllTests.standardOut("testFromTypicalFile");
        InteractionsReader reader = this.getReader("testData/sample.sif");
        reader.read();
        InteractionsReaderTest.assertTrue(reader.getCount() == 25);
        Interaction[] interactions = reader.getAllInteractions();
        InteractionsReaderTest.assertTrue(interactions[0].getSource().equals("YNL312W"));
        InteractionsReaderTest.assertTrue(interactions[0].getType().equals("pd"));
        InteractionsReaderTest.assertTrue(interactions[0].numberOfTargets() == 1);
        InteractionsReaderTest.assertTrue(interactions[0].getTargets()[0].equals("YPL111W"));
        InteractionsReaderTest.assertTrue(interactions[11].numberOfTargets() == 3);
    }

    public void testReadFileWithNoInteractions() throws Exception {
        AllTests.standardOut("testReadFileWithNoInteractions");
        InteractionsReader reader = this.getReader("testData/degenerate.sif");
        reader.read();
        InteractionsReaderTest.assertTrue(reader.getCount() == 9);
        Interaction[] interactions = reader.getAllInteractions();
        for (int i = 0; i < interactions.length; ++i) {
            InteractionsReaderTest.assertTrue(interactions[i].getSource().startsWith("Y"));
            InteractionsReaderTest.assertTrue(interactions[i].getType() == null);
            InteractionsReaderTest.assertTrue(interactions[i].numberOfTargets() == 0);
        }
    }

    public void testGetGraph() throws Exception {
        AllTests.standardOut("testGetGraph");
        InteractionsReader reader = this.getReader("testData/sample.sif");
        reader.read();
        InteractionsReaderTest.assertTrue(reader.getCount() == 25);
        int[] nodes = reader.getNodeIndicesArray();
        int[] edges = reader.getEdgeIndicesArray();
        InteractionsReaderTest.assertTrue("node count: expect 31, got " + nodes.length, nodes.length == 31);
        InteractionsReaderTest.assertTrue("edge count: expect 27, got " + edges.length, edges.length == 27);
    }

    public void testGetGraphAndEdgeAttributes() throws Exception {
        AllTests.standardOut("testGetGraphAndEdgeAttributes");
        InteractionsReader reader = this.getReader("testData/sample.sif");
        reader.read();
        InteractionsReaderTest.assertTrue(reader.getCount() == 25);
        int[] nodes = reader.getNodeIndicesArray();
        int[] edges = reader.getEdgeIndicesArray();
        InteractionsReaderTest.assertTrue("node count: expect 31, got " + nodes.length, nodes.length == 31);
        InteractionsReaderTest.assertTrue("edge count: expect 27, got " + edges.length, edges.length == 27);
    }

    public void testReadMultiWordProteinsFile() throws Exception {
        AllTests.standardOut("testReadMultiWordProteinsFile");
        String filename = "testData/multiWordProteins.sif";
        InteractionsReader reader = this.getReader(filename);
        reader.read();
        InteractionsReaderTest.assertTrue(reader.getCount() == 29);
        Interaction[] interactions = reader.getAllInteractions();
        InteractionsReaderTest.assertTrue(interactions[16].getSource().equals("26S ubiquitin dependent proteasome"));
        InteractionsReaderTest.assertTrue(interactions[16].getType().equals("interactsWith"));
        InteractionsReaderTest.assertTrue(interactions[16].numberOfTargets() == 1);
        InteractionsReaderTest.assertTrue(interactions[16].getTargets()[0].equals("I-kappa-B-alpha"));
        InteractionsReaderTest.assertTrue(interactions[28].getSource().equals("TRAF6"));
        InteractionsReaderTest.assertTrue(interactions[28].getType().equals("interactsWith"));
        InteractionsReaderTest.assertTrue(interactions[28].numberOfTargets() == 3);
        InteractionsReaderTest.assertTrue(interactions[28].getTargets()[0].equals("RIP2"));
        InteractionsReaderTest.assertTrue(interactions[28].getTargets()[1].equals("ABCDE oopah"));
        InteractionsReaderTest.assertTrue(interactions[28].getTargets()[2].equals("HJKOL coltrane"));
    }

    public void testReadMultiWordProteinsFileWithErrantSpaces() throws Exception {
        AllTests.standardOut("testReadMultiWordProteinsFileWithErrantSpaces");
        String filename = "testData/multiWordProteinsFileTrailingSpaces.sif";
        InteractionsReader reader = this.getReader(filename);
        reader.read();
        InteractionsReaderTest.assertTrue(reader.getCount() == 29);
        Interaction[] interactions = reader.getAllInteractions();
        InteractionsReaderTest.assertTrue(interactions[16].getSource().equals("26S ubiquitin dependent proteasome"));
        InteractionsReaderTest.assertTrue(interactions[16].getType().equals("interactsWith"));
        InteractionsReaderTest.assertTrue(interactions[16].numberOfTargets() == 1);
        InteractionsReaderTest.assertTrue(interactions[16].getTargets()[0].equals("I-kappa-B-alpha"));
        InteractionsReaderTest.assertTrue(interactions[28].getSource().equals("TRAF6"));
        InteractionsReaderTest.assertTrue(interactions[28].getType().equals("interactsWith"));
        InteractionsReaderTest.assertTrue(interactions[28].numberOfTargets() == 3);
        InteractionsReaderTest.assertTrue(interactions[28].getTargets()[0].equals("RIP2"));
        InteractionsReaderTest.assertTrue(interactions[28].getTargets()[1].equals("ABCDE oopah"));
        InteractionsReaderTest.assertTrue(interactions[28].getTargets()[2].equals("HJKOL coltrane"));
    }

    private InteractionsReader getReader(String file) {
        if (this.runAllTests) {
            file = new String("testData/" + file);
        }
        InteractionsReader reader = new InteractionsReader(file);
        return reader;
    }

    public static void main(String[] args) {
        TestRunner.run(new TestSuite(InteractionsReaderTest.class));
    }
}

