/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.properties;

import cytoscape.visual.VisualPropertyDependency;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.properties.AbstractVisualProperty;
import cytoscape.visual.properties.GTZeroValidator;
import cytoscape.visual.ui.icon.NodeIcon;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;

public class NodeSizeProp
extends AbstractVisualProperty {
    public NodeSizeProp() {
        this.validator = new GTZeroValidator();
    }

    public VisualPropertyType getType() {
        return VisualPropertyType.NODE_SIZE;
    }

    public Icon getIcon(final Object value) {
        NodeIcon icon = new NodeIcon(){

            public void paintIcon(Component c, Graphics g, int x, int y) {
                super.setColor(new Color(10, 10, 10, 25));
                super.paintIcon(c, g, x, y);
                this.g2d.setFont(new Font("SansSerif", 1, 24));
                this.g2d.setColor(Color.DARK_GRAY);
                this.g2d.drawString(value.toString(), c.getX() + 7, c.getHeight() / 2 + 7);
                this.g2d.setFont(new Font("SansSerif", 1, 12));
            }
        };
        icon.setBottomPadding(-2);
        return icon;
    }

    public void applyToNodeView(NodeView nv, Object o, VisualPropertyDependency dep) {
        if (o == null || nv == null) {
            return;
        }
        if (dep != null && !dep.check(VisualPropertyDependency.Definition.NODE_SIZE_LOCKED)) {
            return;
        }
        double size = ((Number)o).doubleValue();
        double difference = size - nv.getHeight();
        if (Math.abs(difference) > 0.1) {
            nv.setHeight(size);
        }
        if (Math.abs(difference = size - nv.getWidth()) > 0.1) {
            nv.setWidth(size);
        }
    }

    public Object getDefaultAppearanceObject() {
        return new Double(35.0);
    }

    public boolean constrained(VisualPropertyDependency dep) {
        if (dep == null) {
            return false;
        }
        return !dep.check(VisualPropertyDependency.Definition.NODE_SIZE_LOCKED);
    }
}

