/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.properties;

import cytoscape.visual.VisualPropertyDependency;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.properties.AbstractVisualProperty;
import cytoscape.visual.ui.icon.LineTypeIcon;
import giny.view.EdgeView;
import giny.view.Label;
import java.awt.Color;
import java.awt.Font;
import javax.swing.Icon;

public class EdgeFontSizeProp
extends AbstractVisualProperty {
    public VisualPropertyType getType() {
        return VisualPropertyType.EDGE_FONT_SIZE;
    }

    public Icon getIcon(Object value) {
        LineTypeIcon icon = new LineTypeIcon();
        icon.setColor(new Color(10, 10, 10, 20));
        icon.setText(value.toString());
        icon.setBottomPadding(-7);
        return icon;
    }

    public void applyToEdgeView(EdgeView ev, Object o, VisualPropertyDependency dep) {
        if (o == null || ev == null) {
            return;
        }
        Label edgelabel = ev.getLabel();
        Font f = edgelabel.getFont();
        float newFontSize = ((Number)o).floatValue();
        if (newFontSize != f.getSize2D()) {
            edgelabel.setFont(f.deriveFont(newFontSize));
        }
    }

    public Object getDefaultAppearanceObject() {
        return new Float(10.0f);
    }
}

