/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs.plugins;

import cytoscape.plugin.DownloadableInfo;
import cytoscape.plugin.PluginInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;

public class PluginIndex {
    private static StandardAnalyzer analyzer = new StandardAnalyzer(Version.LUCENE_30);
    private static Vector indices = new Vector();
    private static HashMap<String, Directory> indexTracker = new HashMap();
    private static HashMap<String, Vector> pluginVectTracker = new HashMap();
    private static Vector allPluginVect;

    public static void setAllPluginVector(Vector allPluginVect, boolean versionCheck, String downloadLocText) throws Exception {
        String index_id = downloadLocText.trim() + Boolean.toString(versionCheck);
        pluginVectTracker.put(index_id, allPluginVect);
        RAMDirectory index = new RAMDirectory();
        IndexWriter w = new IndexWriter((Directory)index, (Analyzer)analyzer, true, IndexWriter.MaxFieldLength.UNLIMITED);
        for (int i = 0; i < allPluginVect.size(); ++i) {
            Vector aPlugin = (Vector)allPluginVect.elementAt(i);
            if (aPlugin.elementAt(2) instanceof PluginInfo) {
                PluginInfo info = (PluginInfo)aPlugin.elementAt(2);
                List<PluginInfo.AuthorInfo> authorInfo = info.getAuthors();
                String authorNames = "";
                String institutionNames = "";
                for (int j = 0; j < authorInfo.size(); ++j) {
                    PluginInfo.AuthorInfo oneAuthor = authorInfo.get(j);
                    authorNames = authorNames + " " + oneAuthor.getAuthor();
                    institutionNames = institutionNames + " " + oneAuthor.getInstitution();
                }
                String wholeText = info.getName() + " " + info.getDescription() + " " + authorNames + " " + institutionNames;
                PluginIndex.addDoc(w, wholeText, "default");
                continue;
            }
            DownloadableInfo downloadableInfo = (DownloadableInfo)aPlugin.elementAt(2);
            PluginIndex.addDoc(w, downloadableInfo.getDescription(), "default");
        }
        w.close();
        indexTracker.put(index_id, index);
    }

    private static void addDoc(IndexWriter w, String value, String title) throws IOException {
        Document doc = new Document();
        doc.add(new Field(title, value, Field.Store.YES, Field.Index.ANALYZED));
        w.addDocument(doc);
    }

    public static Vector getSearchResult(String querystr, boolean versionCheck, String downloadLocText) throws Exception {
        String index_id = downloadLocText.trim() + Boolean.toString(versionCheck);
        if (!indexTracker.containsKey(index_id)) {
            return null;
        }
        Directory index = indexTracker.get(index_id);
        Query q = new QueryParser(Version.LUCENE_30, "default", analyzer).parse(querystr);
        int hitsPerPage = 1000;
        IndexSearcher searcher = new IndexSearcher(index, true);
        TopScoreDocCollector collector = TopScoreDocCollector.create(hitsPerPage, true);
        searcher.search(q, collector);
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        Vector pluginVect = pluginVectTracker.get(index_id);
        Vector filteredPluginVector = new Vector();
        for (int i = 0; i < hits.length; ++i) {
            int docId = hits[i].doc;
            filteredPluginVector.add(pluginVect.elementAt(docId));
        }
        return filteredPluginVector;
    }
}

