/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.data.readers.KeyValue;
import cytoscape.util.FileUtil;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMLParser {
    private static final int QUOTE_CHAR = 34;
    private static final String QUOTE_STRING = "\"";
    private static final Pattern keyPattern = Pattern.compile("\\w+");
    private static final Pattern integerPattern = Pattern.compile("(\\+|\\-){0,1}\\d+");
    private static final Pattern realPattern = Pattern.compile("(\\+|\\-){0,1}\\d+\\.\\d+((E|e)(\\+|\\-){0,1}\\d+){0,1}");
    private static final String LIST_OPEN = "[";
    private static final String LIST_CLOSE = "]";
    private StreamTokenizer tokenizer;

    public GMLParser(StreamTokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public GMLParser(String file) throws IOException, Exception {
        this(FileUtil.getInputStream(file));
    }

    public GMLParser(InputStream stream) throws IOException, Exception {
        this.tokenizer = new StreamTokenizer(new FilterNewlineReader(new InputStreamReader(stream)));
        this.tokenizer.resetSyntax();
        this.tokenizer.commentChar(35);
        this.tokenizer.quoteChar(34);
        this.tokenizer.eolIsSignificant(false);
        this.tokenizer.wordChars(32, 33);
        this.tokenizer.wordChars(36, 126);
        this.tokenizer.wordChars(160, 255);
        this.tokenizer.whitespaceChars(0, 32);
        this.tokenizer.nextToken();
    }

    public static void printList(List<KeyValue> list, Writer writer) throws IOException {
        GMLParser.printList(list, "", writer);
    }

    protected static void printList(List<KeyValue> list, String indent, Writer writer) throws IOException {
        for (KeyValue keyVal : list) {
            if (keyVal.value instanceof List) {
                writer.write(indent + keyVal.key + "\t");
                writer.write("[\n");
                GMLParser.printList((List)keyVal.value, indent + "\t", writer);
                writer.write(indent + LIST_CLOSE + "\n");
                continue;
            }
            if (keyVal.value instanceof String) {
                writer.write(indent + keyVal.key + "\t");
                writer.write(QUOTE_STRING + keyVal.value + QUOTE_STRING + "\n");
                continue;
            }
            if (keyVal.value instanceof Double) {
                Double value = (Double)keyVal.value;
                if (value.isNaN() || value.isInfinite()) continue;
                writer.write(indent + keyVal.key + "\t");
                writer.write(keyVal.value + "\n");
                continue;
            }
            if (!(keyVal.value instanceof Integer)) continue;
            writer.write(indent + keyVal.key + "\t");
            writer.write(keyVal.value + "\n");
        }
    }

    public List<KeyValue> parseList() throws IOException, ParseException {
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        while (this.isKey()) {
            String key = this.parseKey();
            if (key == null) {
                throw new ParseException("Bad key", this.tokenizer.lineno());
            }
            this.tokenizer.nextToken();
            Object value = this.parseValue();
            if (value == null) {
                throw new ParseException("Bad value associated with key " + key, this.tokenizer.lineno());
            }
            result.add(new KeyValue(key, value));
            this.tokenizer.nextToken();
        }
        return result;
    }

    private boolean isKey() {
        if (this.tokenizer.ttype != -3) {
            return false;
        }
        return keyPattern.matcher(this.tokenizer.sval).matches();
    }

    private boolean isInteger() {
        return integerPattern.matcher(this.tokenizer.sval).matches();
    }

    private boolean isReal() {
        return realPattern.matcher(this.tokenizer.sval).matches();
    }

    private boolean isQuatedString() {
        return this.tokenizer.ttype == 34;
    }

    private boolean isList() {
        return this.tokenizer.sval.equals(LIST_OPEN);
    }

    private String parseKey() {
        if (this.isKey()) {
            return this.tokenizer.sval;
        }
        return null;
    }

    private Object parseValue() throws IOException, ParseException {
        if (this.tokenizer.ttype == 10) {
            return null;
        }
        if (this.isQuatedString()) {
            return this.tokenizer.sval;
        }
        if (this.isInteger()) {
            return Integer.parseInt(this.tokenizer.sval);
        }
        if (this.isReal()) {
            return Double.parseDouble(this.tokenizer.sval);
        }
        if (this.isList()) {
            this.tokenizer.nextToken();
            List<KeyValue> list = this.parseList();
            if (!this.tokenizer.sval.equals(LIST_CLOSE)) {
                throw new ParseException("Unterminated list", this.tokenizer.lineno());
            }
            return list;
        }
        return this.tokenizer.sval;
    }

    private class FilterNewlineReader
    extends FilterReader {
        public FilterNewlineReader(Reader r) {
            super(r);
        }

        public int read() throws IOException {
            int c = super.read();
            if (c == 10 || c == 13) {
                return 32;
            }
            return c;
        }
    }
}

