/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.actions.CreateNetworkViewTask;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyNetworkView;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import javax.swing.JOptionPane;
import javax.swing.event.MenuEvent;

public class CreateNetworkViewAction
extends CytoscapeAction {
    private static final long serialVersionUID = 5033320941306310434L;

    public CreateNetworkViewAction() {
        super("Create View");
        this.setPreferredMenu("Edit");
        this.setAcceleratorCombo(86, 8);
    }

    public CreateNetworkViewAction(boolean label) {
    }

    public void actionPerformed(ActionEvent e) {
        CyNetwork cyNetwork = Cytoscape.getCurrentNetwork();
        CreateNetworkViewAction.createViewFromCurrentNetwork(cyNetwork);
    }

    public static void createViewFromCurrentNetwork(CyNetwork cyNetwork) {
        int n;
        DecimalFormat formatter = new DecimalFormat("#,###,###");
        if (cyNetwork.getNodeCount() > Integer.parseInt(CytoscapeInit.getProperties().getProperty("secondaryViewThreshold")) && (n = JOptionPane.showConfirmDialog(Cytoscape.getDesktop(), "Network contains " + formatter.format(cyNetwork.getNodeCount()) + " nodes and " + formatter.format(cyNetwork.getEdgeCount()) + " edges.  " + "\nRendering a network this size may take several " + "minutes.\n" + "Do you wish to proceed?", "Rendering Large Network", 0)) == 1) {
            return;
        }
        CreateNetworkViewTask task = new CreateNetworkViewTask(cyNetwork);
        JTaskConfig jTaskConfig = new JTaskConfig();
        jTaskConfig.displayCancelButton(false);
        jTaskConfig.setOwner(Cytoscape.getDesktop());
        jTaskConfig.displayCloseButton(false);
        jTaskConfig.displayStatus(true);
        jTaskConfig.setAutoDispose(true);
        TaskManager.executeTask(task, jTaskConfig);
    }

    public void menuSelected(MenuEvent e) {
        CyNetwork currNet = Cytoscape.getCurrentNetwork();
        if (currNet == null || currNet == Cytoscape.getNullNetwork()) {
            this.setEnabled(false);
            return;
        }
        CyNetworkView currView = Cytoscape.getNetworkView(currNet.getIdentifier());
        if (currView == null || currView == Cytoscape.getNullNetworkView()) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

