## ----include=FALSE, cache=FALSE------------------------------------------
library(CancerInSilico)

## ----eval=FALSE----------------------------------------------------------
#  single_cell_run <- runCancerSim(initialNum = 1, runTime = 84)
#  

## ----eval=F--------------------------------------------------------------
#  plotCells(single_cell_run, 84)

## ---- eval=F-------------------------------------------------------------
#  runCancerSim(initialNum,
#               runTime,
#               density = 0.1,
#               cycleLengthDist = 12,
#               inheritGrowth = F,
#               outputIncrement = 6,
#               randSeed = 0,
#               modelType = "DrasdoHohme2003",
#               ...)

## ------------------------------------------------------------------------
# the result of runCancerSim stored in
# basic_sim are a CellModel object
basic_sim <- runCancerSim(initialNum = 3,
                          runTime = 48,
                          density = 0.1,
                          cycleLengthDist = 10 + rexp(1000,1/4),
                          inheritGrowth = FALSE,
                          outputIncrement = 6,
                          randSeed = 10,
                          epsilon = 10,
                          nG = 6)

## ---- eval=FALSE---------------------------------------------------------
#  show(model)

## ------------------------------------------------------------------------
## example call
show(basic_sim) 

## ----eval=FALSE----------------------------------------------------------
#  getParameters(model, fullDist = FALSE)

## ------------------------------------------------------------------------
## example call
getParameters(basic_sim) 

## ------------------------------------------------------------------------
d <- getParameters(basic_sim, fullDist=TRUE)$cycleLengthDist
plot(density(d),main="Cycle Length Distribution - Parameter",xlab="length")

## ----eval=FALSE----------------------------------------------------------
#  getNumberOfCells(model, time)

## ------------------------------------------------------------------------
length <- getParameters(basic_sim)$runTime
t <- sapply(0:length,getNumberOfCells,model=basic_sim)
plot(0:length, t, type = "l", xlab="time", ylab="# of cells")

## ----eval=FALSE----------------------------------------------------------
#  getCycleLengths(model, time)

## ------------------------------------------------------------------------
cyc_len <- getCycleLengths(basic_sim,0)
plot(density(cyc_len),main="Cycle Length Distribution - Time 0",xlab="length")

## ----eval=FALSE----------------------------------------------------------
#  getDensity(model, time)

## ------------------------------------------------------------------------
den <- sapply(0:length,getDensity,model=basic_sim)
plot(0:length,den,type="l",xlab="time",ylab="cell density")

## ----eval=FALSE----------------------------------------------------------
#  plotCells(model, time)

## ------------------------------------------------------------------------
plotCells(basic_sim,0)
plotCells(basic_sim,length)

## ----eval=FALSE----------------------------------------------------------
#  interactivePlot(model, time = 0)

