/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.bio;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.bridgedb.DataSource;
import org.bridgedb.DataSourcePatterns;
import org.bridgedb.bio.DataSourceTxt;
import org.bridgedb.bio.Organism;
import org.bridgedb.impl.InternalUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BioDataSource {
    public static final DataSource TAIR = DataSource.register("A", "TAIR").asDataSource();
    public static final DataSource AGILENT = DataSource.register("Ag", "Agilent").asDataSource();
    public static final DataSource BIOGRID = DataSource.register("Bg", "BioGrid").asDataSource();
    public static final DataSource BIOCYC = DataSource.register("Bc", "BioCyc").asDataSource();
    public static final DataSource CCDS = DataSource.register("Cc", "CCDS").asDataSource();
    public static final DataSource CAS = DataSource.register("Ca", "CAS").asDataSource();
    public static final DataSource CHEBI = DataSource.register("Ce", "ChEBI").asDataSource();
    public static final DataSource HMDB = DataSource.register("Ch", "HMDB").asDataSource();
    public static final DataSource KEGG_COMPOUND = DataSource.register("Ck", "KEGG Compound").asDataSource();
    public static final DataSource PUBCHEM = DataSource.register("Cp", "PubChem").asDataSource();
    public static final DataSource PUBCHEM_SUBSTANCE = DataSource.register("Cps", "PubChem-substance").asDataSource();
    public static final DataSource PUBCHEM_COMPOUND = DataSource.register("Cpc", "PubChem-compound").asDataSource();
    public static final DataSource CHEMSPIDER = DataSource.register("Cs", "Chemspider").asDataSource();
    public static final DataSource SGD = DataSource.register("D", "SGD").asDataSource();
    public static final DataSource ENZYME_CODE = DataSource.register("E", "Enzyme Nomenclature").asDataSource();
    public static final DataSource ECOLI = DataSource.register("Ec", "EcoGene").asDataSource();
    public static final DataSource EMBL = DataSource.register("Em", "EMBL").asDataSource();
    public static final DataSource ENSEMBL = DataSource.register("En", "Ensembl").asDataSource();
    public static final DataSource ENSEMBL_MOSQUITO = DataSource.register("EnAg", "Ensembl Mosquito").asDataSource();
    public static final DataSource GRAMENE_ARABIDOPSIS = DataSource.register("EnAt", "Gramene Arabidopsis").asDataSource();
    public static final DataSource ENSEMBL_BSUBTILIS = DataSource.register("EnBs", "Ensembl B. subtilis").asDataSource();
    public static final DataSource ENSEMBL_COW = DataSource.register("EnBt", "Ensembl Cow").asDataSource();
    public static final DataSource ENSEMBL_CELEGANS = DataSource.register("EnCe", "Ensembl C. elegans").asDataSource();
    public static final DataSource ENSEMBL_DOG = DataSource.register("EnCf", "Ensembl Dog").asDataSource();
    public static final DataSource ENSEMBL_FRUITFLY = DataSource.register("EnDm", "Ensembl Fruitfly").asDataSource();
    public static final DataSource ENSEMBL_ZEBRAFISH = DataSource.register("EnDr", "Ensembl Zebrafish").asDataSource();
    public static final DataSource ENSEMBL_ECOLI = DataSource.register("EnEc", "Ensembl E. coli").asDataSource();
    public static final DataSource ENSEMBL_CHICKEN = DataSource.register("EnGg", "Ensembl Chicken").asDataSource();
    public static final DataSource ENSEMBL_HUMAN = DataSource.register("EnHs", "Ensembl Human").asDataSource();
    public static final DataSource ENSEMBL_MOUSE = DataSource.register("EnMm", "Ensembl Mouse").asDataSource();
    public static final DataSource ENSEMBL_MTUBERCULOSIS = DataSource.register("EnMx", "Ensembl M. tuberculosis").asDataSource();
    public static final DataSource GRAMENE_RICE = DataSource.register("EnOj", "Gramene Rice").asDataSource();
    public static final DataSource ENSEMBL_CHIMP = DataSource.register("EnPt", "Ensembl Chimp").asDataSource();
    public static final DataSource ENSEMBL_HORSE = DataSource.register("EnQc", "Ensembl Horse").asDataSource();
    public static final DataSource ENSEMBL_RAT = DataSource.register("EnRn", "Ensembl Rat").asDataSource();
    public static final DataSource ENSEMBL_SCEREVISIAE = DataSource.register("EnSc", "Ensembl Yeast").asDataSource();
    public static final DataSource ENSEMBL_XENOPUS = DataSource.register("EnXt", "Ensembl Xenopus").asDataSource();
    public static final DataSource FLYBASE = DataSource.register("F", "FlyBase").asDataSource();
    public static final DataSource GENBANK = DataSource.register("G", "GenBank").asDataSource();
    public static final DataSource CODELINK = DataSource.register("Ge", "CodeLink").asDataSource();
    public static final DataSource GRAMENE_GENES_DB = DataSource.register("Gg", "Gramene Genes DB").asDataSource();
    public static final DataSource GRAMENE_LITERATURE = DataSource.register("Gl", "Gramene Literature").asDataSource();
    public static final DataSource GRAMENE_PATHWAY = DataSource.register("Gp", "Gramene Pathway").asDataSource();
    public static final DataSource GENE_WIKI = DataSource.register("Gw", "Gene Wiki").asDataSource();
    public static final DataSource HUGO = DataSource.register("H", "HGNC").asDataSource();
    public static final DataSource HSGENE = DataSource.register("Hs", "HsGene").asDataSource();
    public static final DataSource INTERPRO = DataSource.register("I", "InterPro").asDataSource();
    public static final DataSource ILLUMINA = DataSource.register("Il", "Illumina").asDataSource();
    public static final DataSource IPI = DataSource.register("Ip", "IPI").asDataSource();
    public static final DataSource IRGSP_GENE = DataSource.register("Ir", "IRGSP Gene").asDataSource();
    public static final DataSource KEGG_GENES = DataSource.register("Kg", "KEGG Genes").asDataSource();
    public static final DataSource ENTREZ_GENE = DataSource.register("L", "Entrez Gene").asDataSource();
    public static final DataSource MGI = DataSource.register("M", "MGI").asDataSource();
    public static final DataSource MIRBASE = DataSource.register("Mb", "miRBase Sequence").asDataSource();
    public static final DataSource MIRBASE_MATURE = DataSource.register("Mbm", "miRBase mature sequence").asDataSource();
    public static final DataSource MAIZE_GDB = DataSource.register("Mg", "MaizeGDB").asDataSource();
    public static final DataSource NASC_GENE = DataSource.register("N", "NASC Gene").asDataSource();
    public static final DataSource NUGOWIKI = DataSource.register("Nw", "NuGO wiki").asDataSource();
    public static final DataSource OTHER = DataSource.register("O", "Other").asDataSource();
    public static final DataSource ORYZA_BASE = DataSource.register("Ob", "Oryzabase").asDataSource();
    public static final DataSource OMIM = DataSource.register("Om", "OMIM").asDataSource();
    public static final DataSource RICE_ENSEMBL_GENE = DataSource.register("Os", "Rice Ensembl Gene").asDataSource();
    public static final DataSource PDB = DataSource.register("Pd", "PDB").asDataSource();
    public static final DataSource PFAM = DataSource.register("Pf", "Pfam").asDataSource();
    public static final DataSource PLANTGDB = DataSource.register("Pl", "PlantGDB").asDataSource();
    public static final DataSource REFSEQ = DataSource.register("Q", "RefSeq").asDataSource();
    public static final DataSource RGD = DataSource.register("R", "RGD").asDataSource();
    public static final DataSource REACTOME = DataSource.register("Re", "Reactome").asDataSource();
    public static final DataSource KEGG_REACTION = DataSource.register("Rk", "KEGG Reaction").asDataSource();
    public static final DataSource RFAM = DataSource.register("Rf", "Rfam").asDataSource();
    public static final DataSource UNIPROT = DataSource.register("S", "Uniprot-TrEMBL").asDataSource();
    public static final DataSource UNIPROT_SWISSPROT = DataSource.register("Sp", "Uniprot-SwissProt").asDataSource();
    public static final DataSource SNP = DataSource.register("Sn", "dbSNP").asDataSource();
    public static final DataSource GENE_ONTOLOGY = DataSource.register("T", "GeneOntology").asDataSource();
    public static final DataSource TAXONOMY_NCBI = DataSource.register("Tn", "NCBI Taxonomy Database").asDataSource();
    public static final DataSource TIGR = DataSource.register("Ti", "TIGR").asDataSource();
    public static final DataSource TUBERCULIST = DataSource.register("Tb", "TubercuList").asDataSource();
    public static final DataSource UNIGENE = DataSource.register("U", "UniGene").asDataSource();
    public static final DataSource UCSC = DataSource.register("Uc", "UCSC Genome Browser").asDataSource();
    public static final DataSource WORMBASE = DataSource.register("W", "WormBase").asDataSource();
    public static final DataSource WIKIGENE = DataSource.register("Wg", "WikiGenes").asDataSource();
    public static final DataSource WIKIPEDIA = DataSource.register("Wi", "Wikipedia").asDataSource();
    public static final DataSource WIKIPATHWAYS = DataSource.register("Wp", "WikiPathways").asDataSource();
    public static final DataSource WHEAT_GENE_NAMES = DataSource.register("Wn", "Wheat gene names").asDataSource();
    public static final DataSource WHEAT_GENE_REFERENCES = DataSource.register("Wr", "Wheat gene refs").asDataSource();
    public static final DataSource AFFY = DataSource.register("X", "Affy").asDataSource();
    public static final DataSource ZFIN = DataSource.register("Z", "ZFIN").asDataSource();
    public static final DataSource RHEA = DataSource.register("Rh", "Rhea").asDataSource();
    public static final DataSource MACIE = DataSource.register("Ma", "MACiE").asDataSource();
    public static final DataSource UNIPATHWAY = DataSource.register("Up", "Unipathway").asDataSource();
    private static final Map<Organism, DataSource> ensemblBySpecies = new HashMap<Organism, DataSource>();

    public static DataSource getSpeciesSpecificEnsembl(Organism org) {
        return ensemblBySpecies.get((Object)org);
    }

    public static void init() {
        InputStream is = BioDataSource.class.getClassLoader().getResourceAsStream("org/bridgedb/bio/datasources.txt");
        try {
            DataSourceTxt.loadInputStream(is);
            InternalUtils.readXmlConfig(new InputSource(BioDataSource.class.getClassLoader().getResourceAsStream("org/bridgedb/bio/datasources.xml")));
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
        catch (ParserConfigurationException e) {
            throw new Error(e);
        }
        catch (SAXException e) {
            throw new Error(e);
        }
    }

    static {
        DataSourcePatterns.registerPattern(TAXONOMY_NCBI, Pattern.compile("\\d+"));
        DataSourcePatterns.registerPattern(SGD, Pattern.compile("S\\d{9}"));
        DataSourcePatterns.registerPattern(FLYBASE, Pattern.compile("(C[RG]\\d{4,5}|FBgn\\d{7})"));
        DataSourcePatterns.registerPattern(GENBANK, Pattern.compile("(\\w\\d{5})|(\\w{2}\\d{6})|(\\w{3}\\d{5})"));
        DataSourcePatterns.registerPattern(INTERPRO, Pattern.compile("IPR\\d{6}"));
        DataSourcePatterns.registerPattern(ENTREZ_GENE, Pattern.compile("\\d+"));
        DataSourcePatterns.registerPattern(GENE_WIKI, Pattern.compile("\\d+"));
        DataSourcePatterns.registerPattern(MGI, Pattern.compile("MGI:\\d+"));
        DataSourcePatterns.registerPattern(RFAM, Pattern.compile("RF\\d+"));
        DataSourcePatterns.registerPattern(IPI, Pattern.compile("IPI\\d+"));
        DataSourcePatterns.registerPattern(UCSC, Pattern.compile("uc\\d{3}[a-z]{3}\\.\\d"));
        DataSourcePatterns.registerPattern(ILLUMINA, Pattern.compile("ILMN_\\d+"));
        DataSourcePatterns.registerPattern(MIRBASE, Pattern.compile("MI\\d+"));
        DataSourcePatterns.registerPattern(REFSEQ, Pattern.compile("\\w{2}_\\d+"));
        DataSourcePatterns.registerPattern(RGD, Pattern.compile("RGD:\\d+"));
        DataSourcePatterns.registerPattern(UNIPROT, Pattern.compile("([A-N,R-][0-9][A-Z][A-Z,0-9][A-Z,0-9][0-9])|([O,P,Q][0-9][A-Z,0-9][A-Z,0-9][A-Z,0-9][0-9])"));
        DataSourcePatterns.registerPattern(UNIPROT_SWISSPROT, Pattern.compile("[A-Z0-9]+_[A-Z]+"));
        DataSourcePatterns.registerPattern(GENE_ONTOLOGY, Pattern.compile("GO:\\d+"));
        DataSourcePatterns.registerPattern(UNIGENE, Pattern.compile("[A-Z][a-z][a-z]?\\.\\d+"));
        DataSourcePatterns.registerPattern(WORMBASE, Pattern.compile("WBGene\\d{8}"));
        DataSourcePatterns.registerPattern(AFFY, Pattern.compile(".+_at"));
        DataSourcePatterns.registerPattern(ENSEMBL_HUMAN, Pattern.compile("ENSG\\d{11}"));
        DataSourcePatterns.registerPattern(ENSEMBL_MOUSE, Pattern.compile("ENSMUSG\\d{11}"));
        DataSourcePatterns.registerPattern(ENSEMBL_RAT, Pattern.compile("ENSRNOG\\d{11}"));
        DataSourcePatterns.registerPattern(ENSEMBL_MOSQUITO, Pattern.compile("AGAP\\d{6}"));
        DataSourcePatterns.registerPattern(ENSEMBL_BSUBTILIS, Pattern.compile("EBBACG\\d{11}"));
        DataSourcePatterns.registerPattern(ENSEMBL_ECOLI, Pattern.compile("EBESCG\\d{11}"));
        DataSourcePatterns.registerPattern(ENSEMBL_CHICKEN, Pattern.compile("ENSGALG\\d{11}"));
        DataSourcePatterns.registerPattern(ENSEMBL_HORSE, Pattern.compile("ENSECAG\\d{11}"));
        DataSourcePatterns.registerPattern(ENSEMBL_XENOPUS, Pattern.compile("ENSXETG\\d{11}"));
        DataSourcePatterns.registerPattern(ENSEMBL_CHIMP, Pattern.compile("ENSPTRG\\d{11}"));
        DataSourcePatterns.registerPattern(ENSEMBL_COW, Pattern.compile("ENSBTAG\\d{11}"));
        DataSourcePatterns.registerPattern(ENSEMBL_DOG, Pattern.compile("ENSCAFG\\d{11}"));
        DataSourcePatterns.registerPattern(ENSEMBL_ZEBRAFISH, Pattern.compile("ENSDARG\\d{11}"));
        DataSourcePatterns.registerPattern(ENSEMBL_MTUBERCULOSIS, Pattern.compile("EBMYCG\\d{11}"));
        DataSourcePatterns.registerPattern(ENSEMBL_FRUITFLY, Pattern.compile("FBgn\\d{7}"));
        DataSourcePatterns.registerPattern(ENSEMBL_SCEREVISIAE, Pattern.compile("Y[A-Z][RL]\\d{3}[WC](?:\\-[A-Z])?"));
        DataSourcePatterns.registerPattern(TAIR, Pattern.compile("AT[\\dCM]G\\d{5}"));
        DataSourcePatterns.registerPattern(GRAMENE_ARABIDOPSIS, Pattern.compile("AT[\\dCM]G\\d{5}\\-TAIR\\-G"));
        DataSourcePatterns.registerPattern(IRGSP_GENE, Pattern.compile("Os\\d{2}g\\d+"));
        DataSourcePatterns.registerPattern(GRAMENE_GENES_DB, Pattern.compile("GR:\\d+"));
        DataSourcePatterns.registerPattern(BIOGRID, Pattern.compile("\\d+"));
        DataSourcePatterns.registerPattern(NASC_GENE, Pattern.compile("AT[\\dCM]G\\d{5}\\-TAIR\\-G"));
        DataSourcePatterns.registerPattern(PLANTGDB, Pattern.compile("PUT-[\\w\\d-]+"));
        DataSourcePatterns.registerPattern(EMBL, Pattern.compile("\\w{2}\\d{6}"));
        DataSourcePatterns.registerPattern(HUGO, Pattern.compile("[A-Z][A-Z,0-9]+"));
        DataSourcePatterns.registerPattern(OMIM, Pattern.compile("\\d{6}(\\.\\d{4})?"));
        DataSourcePatterns.registerPattern(PDB, Pattern.compile("\\d[A-Z\\d]{3}"));
        DataSourcePatterns.registerPattern(PFAM, Pattern.compile("(PF\\d{5})|(PB\\d{6})"));
        DataSourcePatterns.registerPattern(ZFIN, Pattern.compile("ZDB.+"));
        DataSourcePatterns.registerPattern(AGILENT, Pattern.compile("A_\\d+_.+"));
        DataSourcePatterns.registerPattern(HMDB, Pattern.compile("HMDB\\d{5}"));
        DataSourcePatterns.registerPattern(CAS, Pattern.compile("\\d+-\\d{2}-\\d{1}"));
        DataSourcePatterns.registerPattern(ENZYME_CODE, Pattern.compile("(\\d+\\.){3}\\d+"));
        DataSourcePatterns.registerPattern(CHEBI, Pattern.compile("CHEBI\\:\\d+"));
        DataSourcePatterns.registerPattern(KEGG_COMPOUND, Pattern.compile("C\\d+"));
        DataSourcePatterns.registerPattern(KEGG_GENES, Pattern.compile("[a-z]{3}:.+"));
        DataSourcePatterns.registerPattern(BIOCYC, Pattern.compile("^\\w+\\:[A-Za-z0-9-]+$"));
        DataSourcePatterns.registerPattern(TUBERCULIST, Pattern.compile("Rv\\d{4}(A|B|c|\\.\\d)?"));
        DataSourcePatterns.registerPattern(RHEA, Pattern.compile("^\\d{5}$"));
        DataSourcePatterns.registerPattern(MACIE, Pattern.compile("^M\\d{4}$"));
        DataSourcePatterns.registerPattern(UNIPATHWAY, Pattern.compile("^UPA\\d{5}$"));
        ensemblBySpecies.put(Organism.BacillusSubtilis, ENSEMBL_BSUBTILIS);
        ensemblBySpecies.put(Organism.CaenorhabditisElegans, ENSEMBL_CELEGANS);
        ensemblBySpecies.put(Organism.GallusGallus, ENSEMBL_CHICKEN);
        ensemblBySpecies.put(Organism.PanTroglodytes, ENSEMBL_CHIMP);
        ensemblBySpecies.put(Organism.BosTaurus, ENSEMBL_COW);
        ensemblBySpecies.put(Organism.CanisFamiliaris, ENSEMBL_DOG);
        ensemblBySpecies.put(Organism.EscherichiaColi, ENSEMBL_ECOLI);
        ensemblBySpecies.put(Organism.DrosophilaMelanogaster, ENSEMBL_FRUITFLY);
        ensemblBySpecies.put(Organism.EquusCaballus, ENSEMBL_HORSE);
        ensemblBySpecies.put(Organism.HomoSapiens, ENSEMBL_HUMAN);
        ensemblBySpecies.put(Organism.AnophelesGambiae, ENSEMBL_MOSQUITO);
        ensemblBySpecies.put(Organism.MusMusculus, ENSEMBL_MOUSE);
        ensemblBySpecies.put(Organism.RattusNorvegicus, ENSEMBL_RAT);
        ensemblBySpecies.put(Organism.SaccharomycesCerevisiae, ENSEMBL_SCEREVISIAE);
        ensemblBySpecies.put(Organism.XenopusTropicalis, ENSEMBL_XENOPUS);
        ensemblBySpecies.put(Organism.DanioRerio, ENSEMBL_ZEBRAFISH);
        ensemblBySpecies.put(Organism.MycobacteriumTuberculosis, ENSEMBL_MTUBERCULOSIS);
        DataSourcePatterns.registerPattern(KEGG_REACTION, Pattern.compile("^R\\d+$"));
        DataSourcePatterns.registerPattern(REACTOME, Pattern.compile("^REACT_\\d+(\\.\\d+)?$"));
    }
}

