### R code from vignette source 'bioqc.Rnw'

###################################################
### code chunk number 1: setSeed
###################################################
set.seed(1887)


###################################################
### code chunk number 2: libLoad
###################################################
library(Biobase)
library(BioQC)
gmtFile <- system.file("extdata/exp.tissuemark.affy.roche.symbols.gmt", package="BioQC")
gmt <- readGmt(gmtFile)


###################################################
### code chunk number 3: gmtReadin
###################################################
Nrow <- 2000L
Nsample <- 5L
gss <- unique(unlist(sapply(gmt, function(x) x$genes)))
myEset <- new("ExpressionSet",
              exprs=matrix(rnorm(Nrow*Nsample), nrow=Nrow),
              featureData=new("AnnotatedDataFrame", 
                data.frame(GeneSymbol=sample(gss, Nrow))))


###################################################
### code chunk number 4: runBioQC
###################################################
dummyRes <- wmwTest(myEset, gmt, alternative="greater")
summary(p.adjust(dummyRes, "BH"))


###################################################
### code chunk number 5: basicDS
###################################################
myMatrix <- matrix(rnorm(Nrow*Nsample), 
                   ncol=Nsample, 
                   dimnames=list(NULL, LETTERS[1:Nsample]))
myList <- list(signature1=sample(1:Nrow, 100), 
               signature2=sample(1:Nrow, 50), 
               signature3=sample(1:Nrow, 200))
wmwTest(myMatrix, myList)


###################################################
### code chunk number 6: benchmark
###################################################
bm.Nrow <- 22000
bw.Nsample <- 5
bm.Ngs <- 5
bm.Ngssize <- sapply(1:bm.Ngs, function(x) sample(1:bm.Nrow/2, replace=TRUE))
ind <- lapply(1:bm.Ngs, function(i) sample(1:bm.Nrow, bm.Ngssize[i]))
exprs <- matrix(round(rnorm(bm.Nrow*bw.Nsample),4), nrow=bm.Nrow)

system.time(Cres <- wmwTest(exprs, ind, alternative="less"))
wmwTestR <- function(matrix, index, alternative, stat) {
  sub <- rep(FALSE, length(matrix))
  sub[index]=TRUE
  return(wilcox.test(matrix[sub], matrix[!sub], alternative=alternative)$p.value)
}
system.time(Rres <- apply(exprs, 2, function(x)
                          sapply(ind, function(y) 
                                 wmwTestR(x, y, alternative="less", stat=FALSE))))



###################################################
### code chunk number 7: sessionInfo
###################################################
sessionInfo()


