/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.ptm.ptmscores;

import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.identification.NeutralLossesMap;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.math.BasicMathFunctions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class AScore {
    public static HashMap<Integer, Double> getAScore(Peptide peptide, ArrayList<PTM> ptms, MSnSpectrum spectrum, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, ArrayList<Integer> charges, int precursorCharge, double mzTolerance, AminoAcidPattern.MatchingType matchingType) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        return AScore.getAScore(peptide, ptms, spectrum, iontypes, null, charges, precursorCharge, mzTolerance, false, matchingType);
    }

    public static HashMap<Integer, Double> getAScore(Peptide peptide, ArrayList<PTM> ptms, MSnSpectrum spectrum, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int precursorCharge, double mzTolerance, AminoAcidPattern.MatchingType matchingType) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        return AScore.getAScore(peptide, ptms, spectrum, iontypes, neutralLosses, charges, precursorCharge, mzTolerance, true, matchingType);
    }

    public static HashMap<Integer, Double> getAScore(Peptide peptide, ArrayList<PTM> ptms, MSnSpectrum spectrum, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int precursorCharge, double mzTolerance, boolean accountNeutralLosses, AminoAcidPattern.MatchingType matchingType) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        if (ptms.isEmpty()) {
            throw new IllegalArgumentException("No PTM given for A-score calculation.");
        }
        int nPTM = 0;
        for (ModificationMatch modMatch : peptide.getModificationMatches()) {
            if (!modMatch.isVariable()) continue;
            for (PTM ptm : ptms) {
                if (!ptm.getName().equals(modMatch.getTheoreticPtm())) continue;
                ++nPTM;
            }
        }
        if (nPTM == 0) {
            throw new IllegalArgumentException("Given PTMs not found in the peptide for A-score calculation.");
        }
        PTM refPTM = ptms.get(0);
        double ptmMass = refPTM.getMass();
        NeutralLossesMap scoringLossesMap = new NeutralLossesMap();
        if (accountNeutralLosses) {
            for (NeutralLoss neutralLoss : neutralLosses.getAccountedNeutralLosses()) {
                if (!(Math.abs(neutralLoss.mass - ptmMass) > mzTolerance)) continue;
                scoringLossesMap.addNeutralLoss(neutralLoss, 1, 1);
            }
        }
        int peptideLength = peptide.getSequence().length();
        ArrayList<Integer> possibleSites = new ArrayList<Integer>();
        for (PTM ptm : ptms) {
            if (ptm.isNTerm()) {
                if (peptide.getPotentialModificationSites(ptm, matchingType, mzTolerance).contains(1)) {
                    possibleSites.add(0);
                }
            } else if (ptm.isCTerm() && peptide.getPotentialModificationSites(ptm, matchingType, mzTolerance).contains(peptideLength)) {
                possibleSites.add(peptideLength + 1);
            }
            for (int potentialSite : peptide.getPotentialModificationSites(ptm, matchingType, mzTolerance)) {
                if (possibleSites.contains(potentialSite)) continue;
                possibleSites.add(potentialSite);
            }
        }
        if (possibleSites.size() > nPTM) {
            Collections.sort(possibleSites);
            PeptideSpectrumAnnotator spectrumAnnotator = new PeptideSpectrumAnnotator();
            Peptide noModPeptide = Peptide.getNoModPeptide(peptide, ptms);
            HashMap<Integer, MSnSpectrum> spectrumMap = AScore.getReducedSpectra(spectrum, mzTolerance, 10);
            HashMap<Integer, HashMap<Integer, Double>> positionToScoreMap = AScore.getPositionToScoreMap(peptide, noModPeptide, possibleSites, spectrum, spectrumMap, iontypes, scoringLossesMap, charges, precursorCharge, mzTolerance, spectrumAnnotator, refPTM);
            HashMap<Double, ArrayList<Integer>> peptideScoreToPostitionMap = AScore.getPeptideScoreToPositionMap(positionToScoreMap);
            ArrayList<Double> scores = new ArrayList<Double>(peptideScoreToPostitionMap.keySet());
            Collections.sort(scores, Collections.reverseOrder());
            ArrayList<Integer> bestScoringSites = peptideScoreToPostitionMap.get(scores.get(0));
            if (bestScoringSites.size() == 1) {
                int bestPosition = bestScoringSites.get(0);
                ArrayList<Integer> secondScoringSites = null;
                for (int i = 1; i < scores.size() && (secondScoringSites == null || secondScoringSites.isEmpty()); ++i) {
                    secondScoringSites = peptideScoreToPostitionMap.get(scores.get(i));
                }
                if (secondScoringSites == null || secondScoringSites.isEmpty()) {
                    throw new IllegalArgumentException("Only one site found in peptide score to position map when estimating the A-score for spectrum " + spectrum.getSpectrumTitle() + " in file " + spectrum.getFileName() + " for modification " + refPTM.getName() + " on peptide " + peptide.getSequence() + ".");
                }
                HashMap<Integer, Double> lowestScoreMap = null;
                Double lowestScore = null;
                for (int secondPosition : secondScoringSites) {
                    int bestDepth = AScore.getBestDepth(positionToScoreMap, bestPosition, secondPosition);
                    HashMap<Integer, Double> tempMap = AScore.getScoreForPositions(peptide, noModPeptide, refPTM, bestPosition, secondPosition, iontypes, scoringLossesMap, charges, precursorCharge, mzTolerance, spectrumAnnotator, bestDepth, spectrumMap.get(bestDepth));
                    Double tempMapLowestScore = null;
                    for (int tempPos : tempMap.keySet()) {
                        double tempScore = tempMap.get(tempPos);
                        if (tempMapLowestScore == null || tempScore < tempMapLowestScore) {
                            tempMapLowestScore = tempScore;
                        }
                        if (tempMapLowestScore != 0.0) continue;
                        break;
                    }
                    if (tempMapLowestScore == null) {
                        throw new IllegalArgumentException("No secondary position score found for " + spectrum.getSpectrumTitle() + " in file " + spectrum.getFileName() + " for modification " + refPTM.getName() + " on peptide " + peptide.getSequence() + ".");
                    }
                    if (lowestScore == null || tempMapLowestScore < lowestScore) {
                        lowestScore = tempMapLowestScore;
                        lowestScoreMap = tempMap;
                        continue;
                    }
                    if (tempMapLowestScore != lowestScore) continue;
                    lowestScoreMap.putAll(tempMap);
                }
                if (lowestScoreMap == null) {
                    throw new IllegalArgumentException("No A-score found for " + spectrum.getSpectrumTitle() + " in file " + spectrum.getFileName() + " for modification " + refPTM.getName() + " on peptide " + peptide.getSequence() + ".");
                }
                return lowestScoreMap;
            }
            HashMap<Integer, Double> lowestScoreMap = null;
            Double lowestScore = null;
            for (int bestPosition : bestScoringSites) {
                for (int secondPosition : bestScoringSites) {
                    if (bestPosition == secondPosition) continue;
                    int bestDepth = AScore.getBestDepth(positionToScoreMap, bestPosition, secondPosition);
                    HashMap<Integer, Double> tempMap = AScore.getScoreForPositions(peptide, noModPeptide, refPTM, bestPosition, secondPosition, iontypes, scoringLossesMap, charges, precursorCharge, mzTolerance, spectrumAnnotator, bestDepth, spectrumMap.get(bestDepth));
                    Double tempMapLowestScore = null;
                    for (int tempPos : tempMap.keySet()) {
                        double tempScore = tempMap.get(tempPos);
                        if (tempMapLowestScore != null && !(tempScore < tempMapLowestScore)) continue;
                        tempMapLowestScore = tempScore;
                    }
                    if (tempMapLowestScore == null) {
                        throw new IllegalArgumentException("No secondary position score found for " + spectrum.getSpectrumTitle() + " in file " + spectrum.getFileName() + " for modification " + refPTM.getName() + " on peptide " + peptide.getSequence() + ".");
                    }
                    if (lowestScore == null || tempMapLowestScore < lowestScore) {
                        lowestScore = tempMapLowestScore;
                        lowestScoreMap = tempMap;
                        continue;
                    }
                    if (tempMapLowestScore != lowestScore) continue;
                    lowestScoreMap.putAll(tempMap);
                }
                if (lowestScore != 0.0) continue;
                break;
            }
            if (lowestScoreMap == null) {
                throw new IllegalArgumentException("No A-score found for " + spectrum.getSpectrumTitle() + " in file " + spectrum.getFileName() + " for modification " + refPTM.getName() + " on peptide " + peptide.getSequence() + ".");
            }
            return lowestScoreMap;
        }
        if (possibleSites.size() == nPTM) {
            HashMap<Integer, Double> result = new HashMap<Integer, Double>();
            Iterator i$ = possibleSites.iterator();
            while (i$.hasNext()) {
                int pos = (Integer)i$.next();
                result.put(pos, 100.0);
            }
            return result;
        }
        throw new IllegalArgumentException("Found less potential modification sites than PTMs during A-score calculation. Peptide key: " + peptide.getKey());
    }

    private static int getBestDepth(HashMap<Integer, HashMap<Integer, Double>> positionToScoreMap, int bestPosition, int secondPosition) {
        double maxDiff = 0.0;
        int bestI = 0;
        for (int i = 1; i <= 10; ++i) {
            double diff = positionToScoreMap.get(bestPosition).get(i) - positionToScoreMap.get(secondPosition).get(i);
            if (!(diff >= maxDiff)) continue;
            bestI = i - 1;
            maxDiff = diff;
        }
        return bestI;
    }

    private static HashMap<Integer, Double> getScoreForPositions(Peptide peptide, Peptide noModPeptide, PTM refPTM, int bestPosition, int secondPosition, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap scoringLossesMap, ArrayList<Integer> charges, int precursorCharge, double mzTolerance, PeptideSpectrumAnnotator spectrumAnnotator, int bestDepth, MSnSpectrum spectrumAtBestDepth) {
        HashMap<Integer, Double> result = new HashMap<Integer, Double>(2);
        int N = 0;
        int posMin = Math.min(bestPosition, secondPosition);
        int posMax = Math.max(bestPosition, secondPosition);
        for (ArrayList<Ion> ions : spectrumAnnotator.getExpectedIons(iontypes, scoringLossesMap, charges, precursorCharge, peptide).values()) {
            for (Ion ion : ions) {
                int aa;
                if (ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
                PeptideFragmentIon fragmentIon = (PeptideFragmentIon)ion;
                if (ion.getSubType() == 0 || ion.getSubType() == 1 || ion.getSubType() == 2) {
                    aa = fragmentIon.getNumber();
                    if (aa <= posMin || aa > posMax) continue;
                    ++N;
                    continue;
                }
                if (ion.getSubType() != 3 && ion.getSubType() != 4 && ion.getSubType() != 5 || (aa = peptide.getSequence().length() - fragmentIon.getNumber()) <= posMin || aa > posMax) continue;
                ++N;
            }
        }
        double p = ((double)bestDepth + 1.0) / 100.0;
        Peptide tempPeptide = new Peptide(noModPeptide.getSequence(), noModPeptide.getModificationMatches());
        tempPeptide.addModificationMatch(new ModificationMatch(refPTM.getName(), true, posMin));
        ArrayList<IonMatch> matches = spectrumAnnotator.getSpectrumAnnotation(iontypes, scoringLossesMap, charges, precursorCharge, spectrumAtBestDepth, tempPeptide, 0.0, mzTolerance, false, false);
        int n = 0;
        for (IonMatch match : matches) {
            int aa;
            Ion ion = match.ion;
            if (ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
            PeptideFragmentIon fragmentIon = (PeptideFragmentIon)ion;
            if (ion.getSubType() == 0 || ion.getSubType() == 1 || ion.getSubType() == 2) {
                aa = fragmentIon.getNumber();
                if (aa <= posMin || aa > posMax) continue;
                ++n;
                continue;
            }
            if (ion.getSubType() != 3 && ion.getSubType() != 4 && ion.getSubType() != 5 || (aa = peptide.getSequence().length() - fragmentIon.getNumber()) <= posMin || aa > posMax) continue;
            ++n;
        }
        double p1 = 0.0;
        for (int k = n; k <= N; ++k) {
            p1 += BasicMathFunctions.getCombination(k, N) * Math.pow(p, k) * Math.pow(1.0 - p, N - k);
        }
        tempPeptide = new Peptide(noModPeptide.getSequence(), noModPeptide.getModificationMatches());
        tempPeptide.addModificationMatch(new ModificationMatch(refPTM.getName(), true, posMax));
        matches = spectrumAnnotator.getSpectrumAnnotation(iontypes, scoringLossesMap, charges, precursorCharge, spectrumAtBestDepth, tempPeptide, 0.0, mzTolerance, false, false);
        n = 0;
        for (IonMatch match : matches) {
            int aa;
            Ion ion = match.ion;
            if (ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
            PeptideFragmentIon fragmentIon = (PeptideFragmentIon)ion;
            if (ion.getSubType() == 0 || ion.getSubType() == 1 || ion.getSubType() == 2) {
                aa = fragmentIon.getNumber();
                if (aa <= posMin || aa > posMax) continue;
                ++n;
                continue;
            }
            if (ion.getSubType() != 3 && ion.getSubType() != 4 && ion.getSubType() != 5 || (aa = peptide.getSequence().length() - fragmentIon.getNumber()) <= posMin || aa > posMax) continue;
            ++n;
        }
        double p2 = 0.0;
        for (int k = n; k <= N; ++k) {
            p2 += BasicMathFunctions.getCombination(k, N) * Math.pow(p, k) * Math.pow(1.0 - p, N - k);
        }
        if (p1 == p2) {
            result.put(posMin, 0.0);
            result.put(posMax, 0.0);
        } else if (p1 < p2) {
            ArrayList<Integer> modificationProfile = new ArrayList<Integer>();
            modificationProfile.add(posMin);
            double score1 = -10.0 * Math.log10(p1);
            double score2 = -10.0 * Math.log10(p2);
            double score = score1 - score2;
            result.put(posMin, score);
        } else {
            ArrayList<Integer> modificationProfile = new ArrayList<Integer>();
            modificationProfile.add(posMax);
            double score1 = -10.0 * Math.log10(p1);
            double score2 = -10.0 * Math.log10(p2);
            double score = score2 - score1;
            result.put(posMax, score);
        }
        return result;
    }

    public static HashMap<Double, ArrayList<Integer>> getPeptideScoreToPositionMap(HashMap<Integer, HashMap<Integer, Double>> positionToScoreMap) {
        HashMap<Double, ArrayList<Integer>> result = new HashMap<Double, ArrayList<Integer>>();
        for (int pos : positionToScoreMap.keySet()) {
            Double peptideScore = 0.0;
            if (positionToScoreMap.get(pos).containsKey(1)) {
                peptideScore = peptideScore + 0.5 * positionToScoreMap.get(pos).get(1);
            }
            if (positionToScoreMap.get(pos).containsKey(2)) {
                peptideScore = peptideScore + 0.75 * positionToScoreMap.get(pos).get(2);
            }
            if (positionToScoreMap.get(pos).containsKey(3)) {
                peptideScore = peptideScore + 1.0 * positionToScoreMap.get(pos).get(3);
            }
            if (positionToScoreMap.get(pos).containsKey(4)) {
                peptideScore = peptideScore + 1.0 * positionToScoreMap.get(pos).get(4);
            }
            if (positionToScoreMap.get(pos).containsKey(5)) {
                peptideScore = peptideScore + 1.0 * positionToScoreMap.get(pos).get(5);
            }
            if (positionToScoreMap.get(pos).containsKey(6)) {
                peptideScore = peptideScore + 1.0 * positionToScoreMap.get(pos).get(6);
            }
            if (positionToScoreMap.get(pos).containsKey(7)) {
                peptideScore = peptideScore + 0.75 * positionToScoreMap.get(pos).get(7);
            }
            if (positionToScoreMap.get(pos).containsKey(8)) {
                peptideScore = peptideScore + 0.5 * positionToScoreMap.get(pos).get(8);
            }
            if (positionToScoreMap.get(pos).containsKey(9)) {
                peptideScore = peptideScore + 0.25 * positionToScoreMap.get(pos).get(9);
            }
            if (positionToScoreMap.get(pos).containsKey(10)) {
                peptideScore = peptideScore + 0.25 * positionToScoreMap.get(pos).get(10);
            }
            if (!result.containsKey(peptideScore)) {
                result.put(peptideScore, new ArrayList());
            }
            result.get(peptideScore).add(pos);
        }
        return result;
    }

    public static HashMap<Integer, HashMap<Integer, Double>> getPositionToScoreMap(Peptide peptide, Peptide noModPeptide, ArrayList<Integer> possibleSites, MSnSpectrum spectrum, HashMap<Integer, MSnSpectrum> spectrumMap, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap scoringLossesMap, ArrayList<Integer> charges, int precursorCharge, double mzTolerance, PeptideSpectrumAnnotator spectrumAnnotator, PTM refPTM) {
        HashMap<Integer, HashMap<Integer, Double>> positionToScoreMap = new HashMap<Integer, HashMap<Integer, Double>>();
        int N = 0;
        for (ArrayList<Ion> fragmentIons : spectrumAnnotator.getExpectedIons(iontypes, scoringLossesMap, charges, precursorCharge, peptide).values()) {
            N += fragmentIons.size();
        }
        String sequence = noModPeptide.getSequence();
        int sequenceLength = sequence.length();
        for (int i = 0; i < spectrumMap.size(); ++i) {
            double p = ((double)i + 1.0) / 100.0;
            for (int pos : possibleSites) {
                Peptide tempPeptide = new Peptide(noModPeptide.getSequence(), noModPeptide.getModificationMatches());
                int position = pos == 0 ? 1 : (pos == sequenceLength + 1 ? sequenceLength : pos);
                tempPeptide.addModificationMatch(new ModificationMatch(refPTM.getName(), true, position));
                ArrayList<IonMatch> matches = spectrumAnnotator.getSpectrumAnnotation(iontypes, scoringLossesMap, charges, precursorCharge, spectrumMap.get(i), tempPeptide, 0.0, mzTolerance, false, false);
                int n = matches.size();
                double P = 0.0;
                for (int k = n; k <= N; ++k) {
                    P += BasicMathFunctions.getCombination(k, N) * Math.pow(p, k) * Math.pow(1.0 - p, N - k);
                }
                if (P <= Double.MIN_NORMAL) {
                    P = Double.MIN_NORMAL;
                }
                double score = -10.0 * Math.log10(P);
                if (!positionToScoreMap.containsKey(pos)) {
                    positionToScoreMap.put(pos, new HashMap());
                }
                positionToScoreMap.get(pos).put(i + 1, score);
            }
        }
        return positionToScoreMap;
    }

    public static HashMap<Integer, MSnSpectrum> getReducedSpectra(MSnSpectrum baseSpectrum, double mzTolerance) {
        return AScore.getReducedSpectra(baseSpectrum, mzTolerance, -1);
    }

    public static HashMap<Integer, MSnSpectrum> getReducedSpectra(MSnSpectrum baseSpectrum, double mzTolerance, int depthMax) {
        int i;
        double currentmzMin;
        HashMap<Integer, MSnSpectrum> result = new HashMap<Integer, MSnSpectrum>();
        HashMap<Double, Peak> peakMap = baseSpectrum.getPeakMap();
        ArrayList<Double> mz = new ArrayList<Double>(peakMap.keySet());
        Collections.sort(mz);
        double mzMax = mz.get(mz.size() - 1);
        int cpt = 0;
        for (currentmzMin = 0.0; currentmzMin < mzMax; currentmzMin += 200.0 * mzTolerance) {
            int cptTemp = 0;
            while (cpt < mz.size() && mz.get(cpt) < currentmzMin + 20.0 * mzTolerance) {
                ++cptTemp;
                ++cpt;
            }
            if (depthMax != -1 || cptTemp <= depthMax) continue;
            depthMax = cptTemp;
        }
        for (i = 0; i < depthMax; ++i) {
            result.put(i, new MSnSpectrum(2, baseSpectrum.getPrecursor(), baseSpectrum.getSpectrumTitle() + "_" + i, new HashMap<Double, Peak>(), "a score"));
        }
        cpt = 0;
        for (currentmzMin = 0.0; currentmzMin < mzMax; currentmzMin += 200.0 * mzTolerance) {
            ArrayList<Double> intensities = new ArrayList<Double>();
            HashMap<Double, Peak> tempMap = new HashMap<Double, Peak>();
            while (cpt < mz.size() && mz.get(cpt) < currentmzMin + 20.0 * mzTolerance) {
                Peak tempPeak = peakMap.get(mz.get(cpt));
                intensities.add(-tempPeak.intensity);
                tempMap.put(-tempPeak.intensity, tempPeak);
                ++cpt;
            }
            Collections.sort(intensities);
            for (i = 0; i < intensities.size(); ++i) {
                for (int j = i; j < depthMax; ++j) {
                    result.get(j).addPeak((Peak)tempMap.get(intensities.get(i)));
                }
            }
        }
        return result;
    }
}

