/*
 * Decompiled with CFR 0.152.
 */
package cn.bgi;

import cn.bgi.TableHeader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Scanner;

public class ProteinGroup {
    private static String pep2pro;
    private static String outfile;
    private static String fasta;
    private static int sumIdentProteins;

    static {
        sumIdentProteins = 0;
    }

    public static void main(String[] args) throws IOException {
        pep2pro = args[0];
        outfile = args[1];
        fasta = args[2];
        TableHeader.peptideSeq = args[3];
        TableHeader.SpectraIndex = args[4];
        TableHeader.ProteinID = args[5];
        TableHeader.ProteinSep = args[6];
        ProteinGroup.proteinGrouper(pep2pro, outfile, fasta);
    }

    public static void initialize(String pep2pro, String outfile, String fasta) {
        ProteinGroup.pep2pro = pep2pro;
        ProteinGroup.outfile = outfile;
        ProteinGroup.fasta = fasta;
    }

    public static void proteinGrouper(String pep2proString, String outfileString, String fastaString) throws IOException {
        pep2pro = pep2proString;
        outfile = outfileString;
        fasta = fastaString;
        HashMap<String, Protein> proMap = new HashMap<String, Protein>();
        HashMap<String, Peptide> pepMap = new HashMap<String, Peptide>();
        BufferedWriter output = new BufferedWriter(new FileWriter(new File(outfile)));
        output.write("Accession\tMass\tPeptideSeqs\tPepIsUniqe\tNumOfUniqPeps\tNumOfUniqSpectra\tSpectra\tSameSet\tDescription\n");
        output.flush();
        BufferedReader psm = new BufferedReader(new FileReader(new File(pep2pro)));
        String[] header = psm.readLine().trim().split("\t");
        HashMap<String, Integer> header2indexHashMap = new HashMap<String, Integer>();
        int i = 0;
        while (i < header.length) {
            header2indexHashMap.put(header[i], i);
            ++i;
        }
        String line = null;
        while ((line = psm.readLine()) != null) {
            String[] items = line.trim().split("\t");
            String pepSeq = items[(Integer)header2indexHashMap.get(TableHeader.peptideSeq)];
            if (!pepMap.containsKey(pepSeq)) {
                pepMap.put(pepSeq, new Peptide());
            }
            ((Peptide)pepMap.get(pepSeq)).setSeq(pepSeq);
            String specNum = items[(Integer)header2indexHashMap.get(TableHeader.SpectraIndex)];
            ((Peptide)pepMap.get(pepSeq)).getSpectra().add(specNum);
            String[] accs = items[(Integer)header2indexHashMap.get(TableHeader.ProteinID)].split(TableHeader.ProteinSep);
            int i2 = 0;
            while (i2 < accs.length) {
                if (!((Peptide)pepMap.get(pepSeq)).getPros().contains(accs[i2])) {
                    ((Peptide)pepMap.get(pepSeq)).getPros().add(accs[i2]);
                }
                if (proMap.containsKey(accs[i2])) {
                    if (!proMap.get(accs[i2]).getPeps().contains(pepSeq)) {
                        proMap.get(accs[i2]).getPeps().add(pepSeq);
                    }
                } else {
                    Protein pro = new Protein();
                    pro.setAccession(accs[i2]);
                    pro.getPeps().add(pepSeq);
                    proMap.put(accs[i2], pro);
                }
                ++i2;
            }
        }
        psm.close();
        if (!fasta.isEmpty()) {
            ProteinGroup.getProteinSeq(fasta, proMap);
        }
        Iterator iterPro = proMap.keySet().iterator();
        int clusterID = 0;
        ArrayList<String> clusterPro = new ArrayList<String>();
        while (iterPro.hasNext()) {
            String proAcc = (String)iterPro.next();
            Protein proTemp = proMap.get(proAcc);
            if (proTemp.getClusterID() != -1) continue;
            proTemp.setClusterID(++clusterID);
            clusterPro.add(proAcc);
            ArrayList<String> peps = new ArrayList<String>();
            int i3 = 0;
            while (i3 < proTemp.getPeps().size()) {
                peps.add(proTemp.getPeps().get(i3));
                ++i3;
            }
            i3 = 0;
            while (i3 < peps.size()) {
                Peptide pepTemp = (Peptide)pepMap.get(peps.get(i3));
                ArrayList<String> proList = pepTemp.getPros();
                int j = 0;
                while (j < proList.size()) {
                    if (proMap.get(proList.get(j)).getClusterID() == -1) {
                        proMap.get(proList.get(j)).setClusterID(clusterID);
                        proTemp.getSameset().add(proList.get(j));
                        int k = 0;
                        while (k < proMap.get(proList.get(j)).getPeps().size()) {
                            if (!peps.contains(proMap.get(proList.get(j)).getPeps().get(k))) {
                                peps.add(proMap.get(proList.get(j)).getPeps().get(k));
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i3;
            }
        }
        int i4 = 0;
        while (i4 < clusterPro.size()) {
            Protein proTemp = proMap.get(clusterPro.get(i4));
            ArrayList<Protein> proList = new ArrayList<Protein>();
            proList.add(proTemp);
            int j = 0;
            while (j < proTemp.getSameset().size()) {
                boolean addFlag = false;
                int k = proList.size() - 1;
                while (k >= 0) {
                    if (proMap.get(proTemp.getSameset().get(j)).getPeps().size() > ((Protein)proList.get(k)).getPeps().size()) {
                        proList.add(k + 1, proMap.get(proTemp.getSameset().get(j)));
                        addFlag = true;
                        break;
                    }
                    if (proMap.get(proTemp.getSameset().get(j)).getPeps().size() == ((Protein)proList.get(k)).getPeps().size() && proMap.get(proTemp.getSameset().get(j)).getLength() > ((Protein)proList.get(k)).getLength()) {
                        proList.add(k + 1, proMap.get(proTemp.getSameset().get(j)));
                        addFlag = true;
                        break;
                    }
                    --k;
                }
                if (!addFlag) {
                    proList.add(0, proMap.get(proTemp.getSameset().get(j)));
                }
                ++j;
            }
            proTemp.setSameset(new ArrayList<String>());
            j = 0;
            while (j < proList.size()) {
                int k = j + 1;
                while (k < proList.size()) {
                    if (((Protein)proList.get(j)).getPeps().containsAll(((Protein)proList.get(k)).getPeps()) && ((Protein)proList.get(k)).getPeps().containsAll(((Protein)proList.get(j)).getPeps())) {
                        ((Protein)proList.get(j)).getSameset().add(((Protein)proList.get(k)).getAccession());
                        proList.remove(k);
                        --k;
                    }
                    ++k;
                }
                ++j;
            }
            ArrayList<String> pepArray = new ArrayList<String>();
            int j2 = 0;
            while (j2 < proList.size()) {
                int k = 0;
                while (k < ((Protein)proList.get(j2)).getPeps().size()) {
                    if (!pepArray.contains(((Protein)proList.get(j2)).getPeps().get(k))) {
                        pepArray.add(((Protein)proList.get(j2)).getPeps().get(k));
                    }
                    ++k;
                }
                ++j2;
            }
            j2 = 0;
            while (j2 < proList.size()) {
                int k = 0;
                while (k < ((Protein)proList.get(j2)).getPeps().size()) {
                    if (((Peptide)pepMap.get(((Protein)proList.get(j2)).getPeps().get(k))).getPros().size() == 1) {
                        pepMap.get(((Protein)proList.get(j2)).getPeps().get(k)).setUniq(true);
                        ((Protein)proList.get(j2)).setNonsense(false);
                    }
                    ++k;
                }
                if (!((Protein)proList.get(j2)).isNonsense()) {
                    output.write(String.valueOf(ProteinGroup.setOutputLine((Protein)proList.get(j2), pepMap)) + "\n");
                    output.flush();
                } else {
                    ArrayList<String> pepComp = new ArrayList<String>();
                    int k2 = 0;
                    while (k2 < proList.size()) {
                        if (k2 != j2) {
                            int l = 0;
                            while (l < ((Protein)proList.get(k2)).getPeps().size()) {
                                if (!pepComp.contains(((Protein)proList.get(k2)).getPeps().get(l))) {
                                    pepComp.add(((Protein)proList.get(k2)).getPeps().get(l));
                                }
                                ++l;
                            }
                        }
                        ++k2;
                    }
                    if (pepArray.containsAll(pepComp) && pepComp.containsAll(pepArray)) {
                        proList.remove(j2);
                        --j2;
                    } else {
                        k2 = 0;
                        while (k2 < pepArray.size()) {
                            if (!pepComp.contains(pepArray.get(k2))) {
                                pepMap.get(pepArray.get(k2)).setUniq(true);
                            }
                            ++k2;
                        }
                        output.write(String.valueOf(ProteinGroup.setOutputLine((Protein)proList.get(j2), pepMap)) + "\n");
                    }
                    output.flush();
                }
                ++j2;
            }
            ++i4;
        }
        output.close();
    }

    public static int getSumIdentProteins() {
        return sumIdentProteins;
    }

    private static String setOutputLine(Protein proTemp, HashMap<String, Peptide> pepMap) {
        String line = "";
        line = String.valueOf(line) + proTemp.getAccession() + "\t" + proTemp.getMass() + "\t";
        int i = 0;
        while (i < proTemp.getPeps().size()) {
            line = i == proTemp.getPeps().size() - 1 ? String.valueOf(line) + proTemp.getPeps().get(i) : String.valueOf(line) + proTemp.getPeps().get(i) + ";";
            ++i;
        }
        line = String.valueOf(line) + "\t";
        int numOfUniqPeps = 0;
        int numOfUniqSpectra = 0;
        String spectraList = "";
        int i2 = 0;
        while (i2 < proTemp.getPeps().size()) {
            Peptide pepTemp = pepMap.get(proTemp.getPeps().get(i2));
            if (pepTemp.isUniq()) {
                line = i2 == proTemp.getPeps().size() - 1 ? String.valueOf(line) + "1" : String.valueOf(line) + "1;";
                ++numOfUniqPeps;
                numOfUniqSpectra += pepTemp.getSpectra().size();
            } else {
                line = String.valueOf(line) + "0;";
            }
            int j = 0;
            while (j < pepTemp.getSpectra().size() - 1) {
                spectraList = String.valueOf(spectraList) + pepTemp.getSpectra().get(j) + ",";
                ++j;
            }
            spectraList = i2 == proTemp.getPeps().size() - 1 ? String.valueOf(spectraList) + pepTemp.getSpectra().get(pepTemp.getSpectra().size() - 1) : String.valueOf(spectraList) + pepTemp.getSpectra().get(pepTemp.getSpectra().size() - 1) + ";";
            ++i2;
        }
        line = String.valueOf(line) + "\t" + numOfUniqPeps + "\t" + numOfUniqSpectra + "\t" + spectraList + "\t";
        if (proTemp.getSameset().size() == 0) {
            line = String.valueOf(line) + "-";
        } else {
            i2 = 0;
            while (i2 < proTemp.getSameset().size()) {
                line = i2 == proTemp.getSameset().size() - 1 ? String.valueOf(line) + proTemp.getSameset().get(i2) : String.valueOf(line) + proTemp.getSameset().get(i2) + ";";
                ++i2;
            }
        }
        line = String.valueOf(line) + "\t" + proTemp.getDescription();
        ++sumIdentProteins;
        return line;
    }

    public static void getProteinSeq(String fasta, HashMap<String, Protein> proMap) throws FileNotFoundException {
        if (fasta != null) {
            Scanner dbPro = new Scanner(new File(fasta));
            dbPro.useDelimiter(">");
            HashMap<String, Double> acidsMass = new HashMap<String, Double>();
            acidsMass.put("A", 71.037114);
            acidsMass.put("B", 114.53494);
            acidsMass.put("C", 160.030649);
            acidsMass.put("D", 115.026943);
            acidsMass.put("E", 129.042593);
            acidsMass.put("F", 147.068414);
            acidsMass.put("G", 57.021464);
            acidsMass.put("H", 137.058912);
            acidsMass.put("I", 113.084064);
            acidsMass.put("J", 0.0);
            acidsMass.put("K", 128.094963);
            acidsMass.put("L", 113.084064);
            acidsMass.put("M", 131.040485);
            acidsMass.put("N", 114.042927);
            acidsMass.put("O", 0.0);
            acidsMass.put("P", 97.052764);
            acidsMass.put("Q", 128.058578);
            acidsMass.put("R", 156.101111);
            acidsMass.put("S", 87.032028);
            acidsMass.put("T", 101.047679);
            acidsMass.put("U", 150.95363);
            acidsMass.put("V", 99.068414);
            acidsMass.put("W", 186.079313);
            acidsMass.put("X", 111.0);
            acidsMass.put("Y", 163.063329);
            acidsMass.put("Z", 128.55059);
            while (dbPro.hasNext()) {
                String proLine = dbPro.next();
                String[] proInfo = proLine.split("\n");
                String[] proAccAndDesc = proInfo[0].split("\\s");
                String proDesc = "";
                Double proMass = 0.0;
                int proLen = 0;
                String proAcc = proAccAndDesc[0];
                if (!proMap.containsKey(proAcc)) continue;
                int j = 1;
                while (j < proAccAndDesc.length) {
                    proDesc = String.valueOf(proDesc) + proAccAndDesc[j] + " ";
                    ++j;
                }
                int i = 1;
                while (i < proInfo.length) {
                    String[] acidsSeq;
                    String[] stringArray = acidsSeq = proInfo[i].split("");
                    int n = acidsSeq.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String acids = stringArray[n2];
                        if (acidsMass.containsKey(acids)) {
                            proMass = proMass + (Double)acidsMass.get(acids);
                            ++proLen;
                        }
                        ++n2;
                    }
                    ++i;
                }
                if (proDesc.replace(" ", "").isEmpty()) {
                    proDesc = "-";
                }
                if (proDesc.length() > 50) {
                    proDesc = String.valueOf(proDesc.substring(0, 50)) + "...";
                }
                proMap.get(proAcc).setAccession(proAcc);
                proMap.get(proAcc).setDescription(proDesc);
                proMap.get(proAcc).setLength(proLen);
                proMap.get(proAcc).setMass(proMass);
            }
            dbPro.close();
        }
    }

    static class Peptide {
        private String seq = null;
        private ArrayList<String> spectra = null;
        private ArrayList<String> pros = null;
        private boolean uniq = false;

        Peptide() {
            this.setSpectra(new ArrayList<String>());
            this.setPros(new ArrayList<String>());
        }

        public String getSeq() {
            return this.seq;
        }

        public void setSeq(String seq) {
            this.seq = seq;
        }

        public ArrayList<String> getSpectra() {
            return this.spectra;
        }

        public void setSpectra(ArrayList<String> spectra) {
            this.spectra = spectra;
        }

        public ArrayList<String> getPros() {
            return this.pros;
        }

        public void setPros(ArrayList<String> pros) {
            this.pros = pros;
        }

        public boolean isUniq() {
            return this.uniq;
        }

        public void setUniq(boolean uniq) {
            this.uniq = uniq;
        }
    }

    static class Protein {
        private String accession = null;
        private ArrayList<String> peps = null;
        private int clusterID = -1;
        private ArrayList<String> sameset = null;
        private boolean nonsense = true;
        private String description = null;
        private int length = 0;
        private double mass = -1.0;

        Protein() {
            this.setPeps(new ArrayList<String>());
            this.setSameset(new ArrayList<String>());
            this.setClusterID(-1);
            this.setNonsense(true);
        }

        public String getAccession() {
            return this.accession;
        }

        public void setAccession(String accession) {
            this.accession = accession;
        }

        public ArrayList<String> getPeps() {
            return this.peps;
        }

        public void setPeps(ArrayList<String> peps) {
            this.peps = peps;
        }

        public int getClusterID() {
            return this.clusterID;
        }

        public void setClusterID(int clusterID) {
            this.clusterID = clusterID;
        }

        public ArrayList<String> getSameset() {
            return this.sameset;
        }

        public void setSameset(ArrayList<String> sameset) {
            this.sameset = sameset;
        }

        public boolean isNonsense() {
            return this.nonsense;
        }

        public void setNonsense(boolean nonsense) {
            this.nonsense = nonsense;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public int getLength() {
            return this.length;
        }

        public void setMass(double mass) {
            this.mass = mass;
        }

        public double getMass() {
            return this.mass;
        }
    }
}

