/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.avsdf;

import java.util.List;
import org.ivis.layout.LEdge;
import org.ivis.layout.avsdf.AVSDFNode;

public class AVSDFEdge
extends LEdge {
    public AVSDFEdge(AVSDFNode source, AVSDFNode target, Object vEdge) {
        super(source, target, vEdge);
    }

    public AVSDFNode getOtherEnd(AVSDFNode node) {
        return (AVSDFNode)super.getOtherEnd(node);
    }

    public boolean crossesWithEdge(AVSDFEdge other) {
        int sourcePos = ((AVSDFNode)this.source).getIndex();
        int targetPos = ((AVSDFNode)this.target).getIndex();
        int otherSourcePos = ((AVSDFNode)other.source).getIndex();
        int otherTargetPos = ((AVSDFNode)other.target).getIndex();
        if (sourcePos == -1 || targetPos == -1 || otherSourcePos == -1 || otherTargetPos == -1) {
            return false;
        }
        int otherSourceDist = ((AVSDFNode)other.source).getCircDistWithTheNode((AVSDFNode)this.source);
        int otherTargetDist = ((AVSDFNode)other.target).getCircDistWithTheNode((AVSDFNode)this.source);
        int thisTargetDist = ((AVSDFNode)this.target).getCircDistWithTheNode((AVSDFNode)this.source);
        return thisTargetDist < Math.max(otherSourceDist, otherTargetDist) && thisTargetDist > Math.min(otherSourceDist, otherTargetDist) && otherTargetDist != 0 && otherSourceDist != 0;
    }

    public int crossingWithEdge(AVSDFEdge other) {
        boolean result = this.crossesWithEdge(other);
        int res = 0;
        if (result) {
            res = 1;
        }
        return res;
    }

    public int calculateTotalCrossingWithList(List edgeList) {
        int totalCrossing = 0;
        for (AVSDFEdge edge : edgeList) {
            totalCrossing += this.crossingWithEdge(edge);
        }
        return totalCrossing;
    }
}

