/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.constraint;

import java.util.Collection;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.pattern.Constraint;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.constraint.ConstraintAdapter;

public class SelfOrThis
extends ConstraintAdapter {
    int selfIndex;
    Constraint con;

    public SelfOrThis(Constraint con) {
        this(con, 0);
    }

    public SelfOrThis(Constraint con, int selfIndex) {
        this.selfIndex = selfIndex;
        this.con = con;
        if (!con.canGenerate()) {
            throw new IllegalArgumentException("The wrapped constraint has to be generative");
        }
        if (selfIndex >= con.getVariableSize() - 1) {
            throw new IllegalArgumentException("selfIndex has to be smaller than the index of last mapped element. selfIndex = " + selfIndex + ", size = " + con.getVariableSize());
        }
    }

    @Override
    public int getVariableSize() {
        return this.con.getVariableSize();
    }

    @Override
    public boolean canGenerate() {
        return true;
    }

    @Override
    public Collection<BioPAXElement> generate(Match match, int ... ind) {
        Collection<BioPAXElement> gen = this.con.generate(match, ind);
        gen.add(match.get(ind[this.selfIndex]));
        return gen;
    }

    @Override
    public boolean satisfies(Match match, int ... ind) {
        return match.get(ind[this.selfIndex]) == match.get(ind[ind.length - 1]) || super.satisfies(match, ind);
    }
}

