/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core.assembler;

import arq.cmd.CmdException;
import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.assemblers.AssemblerGroup;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.assembler.DataSourceAssembler;
import com.hp.hpl.jena.sparql.core.assembler.DatasetAssemblerVocab;
import com.hp.hpl.jena.sparql.core.assembler.GraphStoreAssembler;
import com.hp.hpl.jena.sparql.util.TypeNotUniqueException;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import com.hp.hpl.jena.util.FileManager;

public class AssemblerUtils {
    private static boolean initialized = false;

    public static PrefixMapping readPrefixMapping(String file) {
        PrefixMapping pm = (PrefixMapping)AssemblerUtils.build(file, JA.PrefixMapping);
        return pm;
    }

    public static void init() {
        if (initialized) {
            return;
        }
        AssemblerUtils.register(Assembler.general);
        initialized = true;
    }

    public static void register(AssemblerGroup g) {
        g.implementWith(DataSourceAssembler.getType(), new DataSourceAssembler());
        g.implementWith(GraphStoreAssembler.getType(), new GraphStoreAssembler());
    }

    private static void assemblerClass(AssemblerGroup g, Resource r, Assembler a) {
        g.implementWith(r, a);
    }

    public static Object build(String assemblerFile, String typeURI) {
        Resource type = ResourceFactory.createResource(typeURI);
        return AssemblerUtils.build(assemblerFile, type);
    }

    public static Object build(String assemblerFile, Resource type) {
        if (assemblerFile == null) {
            throw new CmdException("No assembler file");
        }
        Model spec = null;
        try {
            spec = FileManager.get().loadModel(assemblerFile);
        }
        catch (Exception ex) {
            throw new CmdException("Failed reading assembler description: " + ex.getMessage());
        }
        Resource root = null;
        try {
            root = GraphUtils.findRootByType(spec, type);
            if (root == null) {
                return null;
            }
        }
        catch (TypeNotUniqueException ex) {
            throw new ARQException("Multiple types for: " + DatasetAssemblerVocab.tDataset);
        }
        return Assembler.general.open(root);
    }

    static {
        AssemblerUtils.init();
    }
}

