/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl.oldCode;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.FinderUtil;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BackwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.BasicForwardRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RulePreprocessHook;
import com.hp.hpl.jena.reasoner.rulesys.impl.BBRuleContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.FRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETEEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.TempNodeCache;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.BRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.TopGoalIterator;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveEngine;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveGraphCache;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasoner;
import com.hp.hpl.jena.util.OneToManyMap;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrigFBRuleInfGraph
extends BasicForwardRuleInfGraph
implements BackwardRuleInfGraphI {
    protected BBRuleContext context;
    protected Finder dataFind;
    protected BRuleEngine bEngine;
    protected List rawRules;
    protected List rules;
    public static boolean useRETE = true;
    protected boolean useTGCCaching = false;
    protected TransitiveEngine transitiveEngine;
    protected List preprocessorHooks;
    protected TempNodeCache tempNodecache;
    static Log logger = LogFactory.getLog(FBRuleInfGraph.class);

    public OrigFBRuleInfGraph(Reasoner reasoner, Graph schema) {
        super(reasoner, schema);
        this.bEngine = new BRuleEngine(this);
        this.tempNodecache = new TempNodeCache(this);
    }

    public OrigFBRuleInfGraph(Reasoner reasoner, List rules, Graph schema) {
        super(reasoner, rules, schema);
        this.rawRules = rules;
        this.bEngine = new BRuleEngine(this);
        this.tempNodecache = new TempNodeCache(this);
    }

    public OrigFBRuleInfGraph(Reasoner reasoner, List rules, Graph schema, Graph data) {
        super(reasoner, rules, schema, data);
        this.rawRules = rules;
        this.bEngine = new BRuleEngine(this);
        this.tempNodecache = new TempNodeCache(this);
    }

    protected void instantiateRuleEngine(List rules) {
        this.engine = rules != null ? (useRETE ? new RETEEngine(this, rules) : new FRuleEngine(this, rules)) : (useRETE ? new RETEEngine(this) : new FRuleEngine(this));
    }

    public void setUseTGCCache() {
        this.useTGCCaching = true;
        this.transitiveEngine = this.schemaGraph != null ? new TransitiveEngine(((OrigFBRuleInfGraph)this.schemaGraph).transitiveEngine) : new TransitiveEngine(new TransitiveGraphCache(ReasonerVocabulary.directSubClassOf.asNode(), RDFS.subClassOf.asNode()), new TransitiveGraphCache(ReasonerVocabulary.directSubPropertyOf.asNode(), RDFS.subPropertyOf.asNode()));
    }

    public ExtendedIterator findDataMatches(Node subject, Node predicate, Node object) {
        return this.dataFind.find(new TriplePattern(subject, predicate, object));
    }

    public ExtendedIterator findDataMatches(TriplePattern pattern) {
        return this.dataFind.find(pattern);
    }

    public boolean processBuiltin(ClauseEntry clause, Rule rule, BindingEnvironment env) {
        if (clause instanceof Functor) {
            this.context.setEnv(env);
            this.context.setRule(rule);
            return ((Functor)clause).evalAsBodyClause(this.context);
        }
        throw new ReasonerException("Illegal builtin predicate: " + clause + " in rule " + rule);
    }

    public void addBRule(Rule brule) {
        this.bEngine.addRule(brule);
        this.bEngine.reset();
    }

    public void deleteBRule(Rule brule) {
        this.bEngine.deleteRule(brule);
        this.bEngine.reset();
    }

    public void addBRules(List rules) {
        Iterator i = rules.iterator();
        while (i.hasNext()) {
            Rule rule = (Rule)i.next();
            this.bEngine.addRule(rule);
        }
        this.bEngine.reset();
    }

    public List getBRules() {
        return this.bEngine.getAllRules();
    }

    public List getRules() {
        return this.rules;
    }

    private Object getForwardRuleStore() {
        return this.engine.getRuleStore();
    }

    public void addDeduction(Triple t) {
        this.getDeductionsGraph().add(t);
        if (this.useTGCCaching) {
            this.transitiveEngine.add(t);
        }
    }

    public Node getTemp(Node instance, Node prop, Node pclass) {
        return this.tempNodecache.getTemp(instance, prop, pclass);
    }

    public void addRuleDuringPrepare(Rule rule) {
        if (this.rules == this.rawRules) {
            this.rules = this.rawRules instanceof ArrayList ? (ArrayList)((ArrayList)this.rawRules).clone() : new ArrayList(this.rawRules);
            this.instantiateRuleEngine(this.rules);
        }
        this.rules.add(rule);
    }

    public void addPreprocessingHook(RulePreprocessHook hook) {
        if (this.preprocessorHooks == null) {
            this.preprocessorHooks = new ArrayList();
        }
        this.preprocessorHooks.add(hook);
    }

    public void prepare() {
        if (!this.isPrepared) {
            this.isPrepared = true;
            this.rules = this.rawRules;
            Graph data = null;
            if (this.fdata != null) {
                data = this.fdata.getGraph();
            }
            this.fdeductions = new FGraph(Factory.createGraphMem());
            Finder finder = this.dataFind = data == null ? this.fdeductions : FinderUtil.cascade(this.fdeductions, this.fdata);
            if (this.useTGCCaching) {
                if (this.schemaGraph != null) {
                    if (this.transitiveEngine.checkOccurance(TransitiveReasoner.subPropertyOf, data) || this.transitiveEngine.checkOccurance(TransitiveReasoner.subClassOf, data) || this.transitiveEngine.checkOccurance(RDFS.domain.asNode(), data) || this.transitiveEngine.checkOccurance(RDFS.range.asNode(), data)) {
                        this.transitiveEngine.insert(((OrigFBRuleInfGraph)this.schemaGraph).fdata, this.fdata);
                    }
                } else if (data != null) {
                    this.transitiveEngine.insert(null, this.fdata);
                }
                Iterator i = this.rules.iterator();
                while (i.hasNext()) {
                    Rule r = (Rule)i.next();
                    if (r.bodyLength() != 0) continue;
                    for (int j = 0; j < r.headLength(); ++j) {
                        ClauseEntry head = r.getHeadElement(j);
                        if (!(head instanceof TriplePattern)) continue;
                        TriplePattern h = (TriplePattern)head;
                        this.transitiveEngine.add(h.asTriple());
                    }
                }
                this.transitiveEngine.setCaching(true, true);
                this.dataFind = FinderUtil.cascade(this.dataFind, this.transitiveEngine.getSubClassCache(), this.transitiveEngine.getSubPropertyCache());
            }
            Finder dataSource2 = this.fdata;
            if (this.preprocessorHooks != null && this.preprocessorHooks.size() > 0) {
                Graph inserts = Factory.createGraphMem();
                Iterator i = this.preprocessorHooks.iterator();
                if (i.hasNext()) {
                    RulePreprocessHook hook = (RulePreprocessHook)i.next();
                    throw new ReasonerException("Internal error: attempted to invoke obsoleted reasoner with preprocessing hook");
                }
                if (inserts.size() > 0) {
                    FGraph finserts = new FGraph(inserts);
                    dataSource2 = FinderUtil.cascade(this.fdata, finserts);
                    this.dataFind = FinderUtil.cascade(this.dataFind, finserts);
                }
            }
            boolean rulesLoaded = false;
            if (this.schemaGraph != null) {
                Graph rawPreload = ((InfGraph)this.schemaGraph).getRawGraph();
                if (rawPreload != null) {
                    this.dataFind = FinderUtil.cascade(this.dataFind, new FGraph(rawPreload));
                }
                rulesLoaded = this.preloadDeductions(this.schemaGraph);
            }
            if (rulesLoaded) {
                this.engine.fastInit(dataSource2);
            } else {
                this.addBRules(OrigFBRuleInfGraph.extractPureBackwardRules(this.rules));
                this.engine.init(true, dataSource2);
            }
            this.context = new BBRuleContext(this);
        }
    }

    public void rebind() {
        if (this.bEngine != null) {
            this.bEngine.reset();
        }
        this.isPrepared = false;
    }

    public void setTraceOn(boolean state) {
        super.setTraceOn(state);
        this.bEngine.setTraceOn(state);
    }

    public void setDerivationLogging(boolean recordDerivations) {
        this.recordDerivations = recordDerivations;
        this.engine.setDerivationLogging(recordDerivations);
        this.bEngine.setDerivationLogging(recordDerivations);
        this.derivations = recordDerivations ? new OneToManyMap() : null;
    }

    public long getNRulesFired() {
        return this.engine.getNRulesFired() + this.bEngine.getNRulesFired();
    }

    public ExtendedIterator findWithContinuation(TriplePattern pattern, Finder continuation) {
        this.checkOpen();
        if (!this.isPrepared) {
            this.prepare();
        }
        ExtendedIterator result = null;
        result = continuation == null ? UniqueExtendedIterator.create(new TopGoalIterator(this.bEngine, pattern)) : UniqueExtendedIterator.create(new TopGoalIterator(this.bEngine, pattern)).andThen(continuation.find(pattern));
        return result.filterDrop(Functor.acceptFilter);
    }

    public ExtendedIterator graphBaseFind(Node subject, Node property, Node object) {
        return this.findWithContinuation(new TriplePattern(subject, property, object), null);
    }

    public ExtendedIterator find(TriplePattern pattern) {
        return this.findWithContinuation(pattern, null);
    }

    public void reset() {
        this.bEngine.reset();
        this.isPrepared = false;
    }

    public synchronized void performAdd(Triple t) {
        this.fdata.getGraph().add(t);
        if (this.useTGCCaching && this.transitiveEngine.add(t)) {
            this.isPrepared = false;
        }
        if (this.isPrepared) {
            this.engine.add(t);
        }
        this.bEngine.reset();
    }

    public void performDelete(Triple t) {
        this.fdata.getGraph().delete(t);
        if (this.useTGCCaching && this.transitiveEngine.delete(t)) {
            if (this.isPrepared) {
                this.bEngine.deleteAllRules();
            }
            this.isPrepared = false;
        }
        if (this.isPrepared) {
            this.getDeductionsGraph().delete(t);
            this.engine.delete(t);
        }
        this.bEngine.reset();
    }

    public InfGraph cloneWithPremises(Graph premises) {
        this.prepare();
        FBRuleInfGraph graph = new FBRuleInfGraph(this.getReasoner(), this.rawRules, this);
        if (this.useTGCCaching) {
            graph.setUseTGCCache();
        }
        graph.setDerivationLogging(this.recordDerivations);
        graph.setTraceOn(this.traceOn);
        graph.rebind(premises);
        return graph;
    }

    private static List extractPureBackwardRules(List rules) {
        ArrayList<Rule> bRules = new ArrayList<Rule>();
        Iterator i = rules.iterator();
        while (i.hasNext()) {
            Rule r = (Rule)i.next();
            if (!r.isBackward() || r.bodyLength() <= 0) continue;
            bRules.add(r);
        }
        return bRules;
    }

    protected boolean preloadDeductions(Graph preloadIn) {
        Graph d = this.fdeductions.getGraph();
        OrigFBRuleInfGraph preload = (OrigFBRuleInfGraph)preloadIn;
        if (preload.rules == this.rules) {
            ExtendedIterator i = preload.getDeductionsGraph().find(null, null, null);
            while (i.hasNext()) {
                d.add((Triple)i.next());
            }
            this.addBRules(preload.getBRules());
            this.engine.setRuleStore(preload.getForwardRuleStore());
            return true;
        }
        return false;
    }

    public static class RuleStore {
        protected List rawRules;
        protected Object fRuleStore;
        protected List bRules;

        public RuleStore(List rawRules, Object fRuleStore, List bRules) {
            this.rawRules = rawRules;
            this.fRuleStore = fRuleStore;
            this.bRules = bRules;
        }
    }
}

