/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.impl.level3.EntityReferenceImpl;
import org.biopax.paxtools.impl.level3.EvidenceImpl;
import org.biopax.paxtools.impl.level3.L3ElementImpl;
import org.biopax.paxtools.impl.level3.PhysicalEntityImpl;
import org.biopax.paxtools.impl.level3.SequenceLocationImpl;
import org.biopax.paxtools.impl.level3.SequenceRegionVocabularyImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Evidence;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SequenceLocation;
import org.biopax.paxtools.model.level3.SequenceRegionVocabulary;
import org.biopax.paxtools.util.BPCollections;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Indexed;

@Entity
@Proxy(proxyClass=EntityFeature.class)
@Indexed
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class EntityFeatureImpl
extends L3ElementImpl
implements EntityFeature {
    private final Log LOG = LogFactory.getLog(EntityFeatureImpl.class);
    private Set<Evidence> evidence = BPCollections.I.createSafeSet();
    private EntityReference ownerEntityReference;
    private Set<PhysicalEntity> featureOf = BPCollections.I.createSafeSet();
    private Set<PhysicalEntity> notFeatureOf = BPCollections.I.createSafeSet();
    private SequenceLocation featureLocation;
    private Set<EntityFeature> memberFeature;
    private SequenceRegionVocabulary featureLocationType;
    private Set<EntityFeature> memberFeatureOf = BPCollections.I.createSafeSet();

    public EntityFeatureImpl() {
        this.memberFeature = BPCollections.I.createSafeSet();
    }

    @Transient
    public Class<? extends EntityFeature> getModelInterface() {
        return EntityFeature.class;
    }

    @Override
    @ManyToOne(targetEntity=EntityReferenceImpl.class)
    public EntityReference getEntityFeatureOf() {
        return this.ownerEntityReference;
    }

    public void setEntityFeatureOf(EntityReference entityReference) {
        this.ownerEntityReference = entityReference;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=PhysicalEntityImpl.class, mappedBy="feature")
    public Set<PhysicalEntity> getFeatureOf() {
        return this.featureOf;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=PhysicalEntityImpl.class, mappedBy="notFeature")
    public Set<PhysicalEntity> getNotFeatureOf() {
        return this.notFeatureOf;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=EvidenceImpl.class)
    @JoinTable(name="evidence")
    public Set<Evidence> getEvidence() {
        return this.evidence;
    }

    @Override
    public void addEvidence(Evidence evidence2) {
        if (evidence2 != null) {
            this.evidence.add(evidence2);
        }
    }

    @Override
    public void removeEvidence(Evidence evidence2) {
        if (evidence2 != null) {
            this.evidence.remove(evidence2);
        }
    }

    protected void setEvidence(Set<Evidence> evidence2) {
        this.evidence = evidence2;
    }

    @Override
    @ManyToOne(targetEntity=SequenceLocationImpl.class)
    public SequenceLocation getFeatureLocation() {
        return this.featureLocation;
    }

    @Override
    public void setFeatureLocation(SequenceLocation featureLocation) {
        this.featureLocation = featureLocation;
    }

    @Override
    @ManyToOne(targetEntity=SequenceRegionVocabularyImpl.class)
    public SequenceRegionVocabulary getFeatureLocationType() {
        return this.featureLocationType;
    }

    @Override
    public void setFeatureLocationType(SequenceRegionVocabulary regionVocabulary) {
        this.featureLocationType = regionVocabulary;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=EntityFeatureImpl.class)
    @JoinTable(name="memberFeature")
    public Set<EntityFeature> getMemberFeature() {
        return this.memberFeature;
    }

    protected void setMemberFeature(Set<EntityFeature> memberFeature) {
        this.memberFeature = memberFeature;
    }

    @Override
    public void addMemberFeature(EntityFeature feature) {
        if (feature != null) {
            this.memberFeature.add(feature);
            feature.getMemberFeatureOf().add(this);
        }
    }

    @Override
    public void removeMemberFeature(EntityFeature feature) {
        if (feature != null) {
            this.memberFeature.remove(feature);
            feature.getMemberFeatureOf().remove(this);
        }
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=EntityFeatureImpl.class, mappedBy="memberFeature")
    public Set<EntityFeature> getMemberFeatureOf() {
        return this.memberFeatureOf;
    }

    protected void setMemberFeatureOf(Set<EntityFeature> memberFeatureOf) {
        this.memberFeatureOf = memberFeatureOf;
    }

    @Override
    @Transient
    public boolean atEquivalentLocation(EntityFeature that) {
        return this.getEntityFeatureOf() != null && this.getEntityFeatureOf().isEquivalent(that.getEntityFeatureOf()) && this.getFeatureLocation() != null && this.getFeatureLocation().isEquivalent(that.getFeatureLocation());
    }

    @Transient
    protected int locationCode() {
        if (this.getEntityFeatureOf() == null || this.getFeatureLocation() == null) {
            return this.hashCode();
        }
        return this.getEntityFeatureOf().equivalenceCode() + 13 * this.getFeatureLocation().equivalenceCode();
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        if (!(element instanceof EntityFeature)) {
            return false;
        }
        EntityFeature that = (EntityFeature)element;
        boolean value = this.atEquivalentLocation(that);
        if (value) {
            SequenceRegionVocabulary myType = this.featureLocationType;
            SequenceRegionVocabulary yourType = that.getFeatureLocationType();
            value = yourType == null ? myType == null : yourType.isEquivalent(myType);
        }
        return value;
    }

    @Override
    public int equivalenceCode() {
        SequenceRegionVocabulary siteType = this.getFeatureLocationType();
        int code = siteType == null ? 0 : siteType.hashCode();
        return code + 13 * this.locationCode();
    }

    protected void setFeatureOf(Set<PhysicalEntity> featureOf) {
        this.featureOf = featureOf;
    }

    protected void setNotFeatureOf(Set<PhysicalEntity> notFeatureOf) {
        this.notFeatureOf = notFeatureOf;
    }
}

