/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import uk.ac.manchester.cs.owl.owlapi.Internals;
import uk.ac.manchester.cs.owl.owlapi.OWLNamedObjectReferenceRemover;

public class OWLNamedObjectReferenceRemoverImpl
implements OWLNamedObjectReferenceRemover {
    private OWLAxiom axiom;
    private final Internals oi;

    public OWLNamedObjectReferenceRemoverImpl(Internals oi) {
        this.oi = oi;
    }

    public void setAxiom(OWLAxiom axiom) {
        this.axiom = axiom;
    }

    public void visit(OWLClass owlClass) {
        this.oi.removeOwlClassReferences(owlClass, this.axiom);
    }

    public void visit(OWLObjectProperty property) {
        this.oi.removeOwlObjectPropertyReferences(property, this.axiom);
    }

    public void visit(OWLDataProperty property) {
        this.oi.removeOwlDataPropertyReferences(property, this.axiom);
    }

    public void visit(OWLNamedIndividual owlIndividual) {
        this.oi.removeOwlIndividualReferences(owlIndividual, this.axiom);
    }

    public void visit(OWLAnnotationProperty property) {
        this.oi.removeOwlAnnotationPropertyReferences(property, this.axiom);
    }

    public void visit(OWLDatatype datatype) {
        this.oi.removeOwlDatatypeReferences(datatype, this.axiom);
    }
}

